/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.UnivariateRealSolverUtils;

public class BisectionSolver
extends UnivariateRealSolverImpl {
    private static final long serialVersionUID = 4963578633786538912L;

    public BisectionSolver(UnivariateRealFunction f) {
        super(f, 100, 1.0E-6);
    }

    public double solve(double min2, double max, double initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(min2, max);
    }

    public double solve(double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(min2, max);
        for (int i = 0; i < this.maximalIterationCount; ++i) {
            double m4 = UnivariateRealSolverUtils.midpoint(min2, max);
            double fmin = this.f.value(min2);
            double fm = this.f.value(m4);
            if (fm * fmin > 0.0) {
                min2 = m4;
            } else {
                max = m4;
            }
            if (!(Math.abs(max - min2) <= this.absoluteAccuracy)) continue;
            m4 = UnivariateRealSolverUtils.midpoint(min2, max);
            this.setResult(m4, i);
            return m4;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

