/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.xml;

import java.io.InputStream;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatTools;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.UNITS;
import ome.units.unit.Unit;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PrimitiveNumber;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Upgrade201006Test {
    private static final String XML_FILE = "2010-06.ome";
    private OMEXMLService service;
    private String xml;
    private OMEXMLMetadata metadata;
    private OME ome;

    @BeforeMethod
    public void setUp() throws Exception {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        InputStream s = Upgrade201006Test.class.getResourceAsStream(XML_FILE);
        byte[] b = new byte[s.available()];
        s.read(b);
        s.close();
        this.xml = new String(b);
        this.metadata = this.service.createOMEXMLMetadata(this.xml);
        this.ome = (OME)this.metadata.getRoot();
    }

    @Test
    public void getOMEXMLVersion() throws ServiceException {
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getOMEXMLVersion((Object)this.metadata));
    }

    @Test
    public void validateUpgrade() throws ServiceException {
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Image image = this.ome.getImage(0);
        Pixels pixels = image.getPixels();
        PositiveFloat positiveFloatValue = new PositiveFloat(Double.valueOf(10000.0));
        AssertJUnit.assertEquals((Object)FormatTools.createLength((PrimitiveNumber)positiveFloatValue, (Unit)UNITS.MICROMETER), (Object)pixels.getPhysicalSizeX());
        AssertJUnit.assertEquals((Object)FormatTools.createLength((PrimitiveNumber)positiveFloatValue, (Unit)UNITS.MICROMETER), (Object)pixels.getPhysicalSizeY());
        AssertJUnit.assertNull((Object)pixels.getPhysicalSizeZ());
    }
}

