/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import loci.formats.utests.SPWModelMock;
import ome.xml.model.Channel;
import ome.xml.model.GenericExcitationSource;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.MapPair;
import ome.xml.model.OME;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Pixels;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericExcitationMapTest {
    private OME ome = new OME();

    @BeforeClass
    public void setUp() throws Exception {
        Instrument instrument = new Instrument();
        instrument.setID("Instrument:0");
        GenericExcitationSource geSource = new GenericExcitationSource();
        geSource.setID("LightSource:0");
        ArrayList<MapPair> dataMap = new ArrayList<MapPair>();
        dataMap.add(new MapPair("a", "1"));
        dataMap.add(new MapPair("d", "2"));
        dataMap.add(new MapPair("c", "3"));
        dataMap.add(new MapPair("b", "4"));
        dataMap.add(new MapPair("e", "5"));
        dataMap.add(new MapPair("c", "6"));
        AssertJUnit.assertEquals((int)6, (int)dataMap.size());
        geSource.setMap(dataMap);
        instrument.addLightSource((LightSource)geSource);
        this.ome.addInstrument(instrument);
        Image image = new Image();
        image.setID("Image:0");
        Pixels pixels = new Pixels();
        pixels.setID("Pixels:0");
        Channel channel = new Channel();
        channel.setID("Channel:0");
        LightSourceSettings settings = new LightSourceSettings();
        settings.setID("LightSource:0");
        channel.setLightSourceSettings(settings);
        pixels.addChannel(channel);
        image.setPixels(pixels);
        this.ome.addImage(image);
    }

    @Test
    public void testGenericExcitationSourceValid() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = this.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, false);
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
    }

    @Test
    public void testGenericExcitationSourceMapContent() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = this.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, false);
        OMEModelImpl model = new OMEModelImpl();
        this.ome = new OME(document.getDocumentElement(), (OMEModel)model);
        model.resolveReferences();
        AssertJUnit.assertNotNull((Object)this.ome);
        AssertJUnit.assertEquals((String)this.ome.getImage(0).getPixels().getChannel(0).getLightSourceSettings().getID(), (String)"LightSource:0");
        AssertJUnit.assertNotNull((Object)this.ome.getInstrument(0).getLightSource(0));
        GenericExcitationSource geSource = (GenericExcitationSource)this.ome.getInstrument(0).getLightSource(0);
        List dataMap = geSource.getMap();
        AssertJUnit.assertEquals((int)6, (int)dataMap.size());
        this.assertPair(dataMap, 0, "a", "1");
        this.assertPair(dataMap, 1, "d", "2");
        this.assertPair(dataMap, 2, "c", "3");
        this.assertPair(dataMap, 3, "b", "4");
        this.assertPair(dataMap, 4, "e", "5");
        this.assertPair(dataMap, 5, "c", "6");
    }

    void assertPair(List<MapPair> dataMap, int idx, String name, String value) {
        AssertJUnit.assertEquals((String)name, (String)dataMap.get(idx).getName());
        AssertJUnit.assertEquals((String)value, (String)dataMap.get(idx).getValue());
    }
}

