/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import loci.common.S3Handle;
import loci.common.StreamHandle;
import loci.common.utests.TestUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class S3HandleTest {
    private static boolean runS3RemoteTests;
    private Path TEMPDIR;
    private static final Logger LOGGER;
    private static final String s3public = "s3+http://localhost:31836";
    private static final String s3private = "s3+http://accesskey:secretkey@localhost:31836";

    @BeforeClass
    public void setup() throws IOException {
        this.TEMPDIR = Files.createTempDirectory("S3HandleTest-", new FileAttribute[0]);
        this.TEMPDIR.toFile().deleteOnExit();
        boolean bl = runS3RemoteTests = TestUtilities.getPropValueInt("testng.runS3RemoteTests") > 0;
        if (!runS3RemoteTests) {
            LOGGER.warn("S3 tests are disabled!");
        }
    }

    private void skipIfS3Disabled() throws SkipException {
        if (!runS3RemoteTests) {
            throw new SkipException("S3 tests are disabled");
        }
    }

    @Test
    public void testCanHandleScheme() {
        AssertJUnit.assertTrue((boolean)S3Handle.canHandleScheme((String)"s3://"));
        AssertJUnit.assertTrue((boolean)S3Handle.canHandleScheme((String)"s3+transport://abc"));
        AssertJUnit.assertTrue((boolean)S3Handle.canHandleScheme((String)"s3+transport"));
        AssertJUnit.assertFalse((boolean)S3Handle.canHandleScheme((String)"s345://"));
        AssertJUnit.assertFalse((boolean)S3Handle.canHandleScheme((String)"http+s3://"));
        AssertJUnit.assertFalse((boolean)S3Handle.canHandleScheme((String)"https"));
    }

    @Test
    public void testParseLocalhost() throws IOException {
        S3Handle s3 = new S3Handle("s3://localhost:9000/bucket/key/file.tif", false, null);
        AssertJUnit.assertEquals((String)"https://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)9000, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals((String)"key/file.tif", (String)s3.getPath());
    }

    @Test
    public void testParseAuth() throws IOException {
        S3Handle s3 = new S3Handle("s3://access:secret@s3.example.org/bucket/key/file.tif", false, null);
        AssertJUnit.assertEquals((String)"https://s3.example.org", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals((String)"key/file.tif", (String)s3.getPath());
    }

    @Test
    public void testParseAuthLocalhost() throws IOException {
        S3Handle s3 = new S3Handle("s3://access:secret@localhost:9000/bucket/key/file.tif", false, null);
        AssertJUnit.assertEquals((String)"https://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)9000, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals((String)"key/file.tif", (String)s3.getPath());
    }

    @Test
    public void testParseProtocol() throws IOException {
        S3Handle s3 = new S3Handle("example://localhost/bucket/key/file.tif", false, null);
        AssertJUnit.assertEquals((String)"example://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals((String)"key/file.tif", (String)s3.getPath());
    }

    @Test
    public void testDefaultProtocol() throws IOException {
        S3Handle s3 = new S3Handle("s3+custom://localhost/bucket/key/file.tif", false, null);
        AssertJUnit.assertEquals((String)"custom://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals((String)"key/file.tif", (String)s3.getPath());
    }

    @Test
    public void testParseNoSlash() throws IOException {
        S3Handle s3 = new S3Handle("s3://localhost", false, null);
        AssertJUnit.assertEquals((String)"https://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals(null, (String)s3.getBucket());
        AssertJUnit.assertEquals(null, (String)s3.getPath());
    }

    @Test
    public void testParseSlashNoBucket() throws IOException {
        S3Handle s3 = new S3Handle("s3://localhost/", false, null);
        AssertJUnit.assertEquals((String)"https://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals(null, (String)s3.getBucket());
        AssertJUnit.assertEquals(null, (String)s3.getPath());
    }

    @Test
    public void testParseBucketNoSlash() throws IOException {
        S3Handle s3 = new S3Handle("s3://localhost/bucket", false, null);
        AssertJUnit.assertEquals((String)"https://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals(null, (String)s3.getPath());
    }

    @Test
    public void testParseBucketSlash() throws IOException {
        S3Handle s3 = new S3Handle("s3://localhost/bucket/", false, null);
        AssertJUnit.assertEquals((String)"https://localhost", (String)s3.getServer());
        AssertJUnit.assertEquals((int)0, (int)s3.getPort());
        AssertJUnit.assertEquals((String)"bucket", (String)s3.getBucket());
        AssertJUnit.assertEquals(null, (String)s3.getPath());
    }

    @Test
    public void testIsBucket() throws IOException {
        this.skipIfS3Disabled();
        S3Handle s3 = new S3Handle("s3+http://localhost:31836/bioformats.test.public");
        AssertJUnit.assertTrue((boolean)s3.isBucket());
    }

    @Test
    public void testReadPublic() throws IOException {
        this.skipIfS3Disabled();
        S3Handle s3 = new S3Handle("s3+http://localhost:31836/bioformats.test.public/single-channel.ome.tiff");
        AssertJUnit.assertFalse((boolean)s3.isBucket());
        AssertJUnit.assertTrue((boolean)s3.exists());
        AssertJUnit.assertEquals((long)76097L, (long)s3.length());
    }

    @Test
    public void testReadPrivate() throws IOException {
        this.skipIfS3Disabled();
        S3Handle s3 = new S3Handle("s3+http://accesskey:secretkey@localhost:31836/bioformats.test.private/single-channel.ome.tiff");
        AssertJUnit.assertFalse((boolean)s3.isBucket());
        AssertJUnit.assertTrue((boolean)s3.exists());
        AssertJUnit.assertEquals((long)76097L, (long)s3.length());
    }

    @Test
    public void testReadAndSeek() throws IOException {
        this.skipIfS3Disabled();
        S3Handle s3 = new S3Handle("s3+http://localhost:31836/bioformats.test.public/2MBfile.txt");
        AssertJUnit.assertFalse((boolean)s3.isBucket());
        AssertJUnit.assertTrue((boolean)s3.exists());
        AssertJUnit.assertEquals((long)0x200000L, (long)s3.length());
        byte[] buffer = new byte[32];
        int r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)".                             1\n", (String)new String(buffer));
        r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)".                             2\n", (String)new String(buffer));
        s3.seek(80L);
        r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)"              3\n.               ", (String)new String(buffer));
        s3.seek(2097056L);
        r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)".                         65534\n", (String)new String(buffer));
        s3.seek(144L);
        r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)"              5\n.               ", (String)new String(buffer));
    }

    @Test
    public void testResetStream() throws IOException {
        this.skipIfS3Disabled();
        class S3HandleWrapper
        extends S3Handle {
            public S3HandleWrapper(String url) throws IOException {
                super(url);
            }

            public void resetStream() throws IOException {
                super.resetStream();
            }

            public void resetStream(long offset) throws IOException {
                super.resetStream(offset);
            }
        }
        S3HandleWrapper s3 = new S3HandleWrapper("s3+http://accesskey:secretkey@localhost:31836/bioformats.test.private/2MBfile.txt");
        AssertJUnit.assertFalse((boolean)s3.isBucket());
        AssertJUnit.assertTrue((boolean)s3.exists());
        AssertJUnit.assertEquals((long)0x200000L, (long)s3.length());
        byte[] buffer = new byte[32];
        s3.resetStream(750144L);
        int r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)".                         23443\n", (String)new String(buffer));
        s3.resetStream();
        r = s3.read(buffer, 0, 32);
        AssertJUnit.assertEquals((int)32, (int)r);
        AssertJUnit.assertEquals((String)".                             1\n", (String)new String(buffer));
    }

    @Test
    public void testCache() throws IOException {
        this.skipIfS3Disabled();
        String expectedPath = this.TEMPDIR + "/http/localhost/31836/bioformats.test.public/2MBfile.txt";
        class MockSettings
        extends StreamHandle.Settings {
            MockSettings() {
            }

            public String getRemoteCacheRootDir() {
                return S3HandleTest.this.TEMPDIR.toString();
            }
        }
        String downloaded = S3Handle.cacheObject((String)"s3+http://localhost:31836/bioformats.test.public/2MBfile.txt", (StreamHandle.Settings)new MockSettings());
        AssertJUnit.assertEquals((String)expectedPath, (String)downloaded);
        AssertJUnit.assertEquals((long)0x200000L, (long)Files.size(Paths.get(downloaded, new String[0])));
    }

    static {
        LOGGER = LoggerFactory.getLogger(S3HandleTest.class);
    }
}

