/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteUnsignedByteTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        this.fileHandle.writeByte(1);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(2);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(3);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)3L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(4);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(5);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)5L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(6);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)6L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(7);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)7L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(8);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(9);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)9L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(10);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)10L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(11);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)11L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(12);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(13);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)13L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(14);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)14L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(-1);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)15L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(-2);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)4, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)6, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)8, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)10, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)11, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)12, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)13, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)14, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)255, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)254, (int)this.fileHandle.readUnsignedByte());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(7L);
        this.fileHandle.writeByte(8);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(9);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)9L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(7L);
        this.fileHandle.writeByte(-1);
        this.fileHandle.writeByte(-2);
        this.fileHandle.seek(7L);
        AssertJUnit.assertEquals((int)255, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)254, (int)this.fileHandle.readUnsignedByte());
    }

    @Test
    public void testReset() throws IOException {
        this.fileHandle.writeByte(1);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeByte(2);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        this.fileHandle.writeByte(1);
        this.fileHandle.writeByte(2);
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readUnsignedByte());
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readUnsignedByte());
    }
}

