/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingDefault;
import ucar.nc2.write.Nc4ChunkingStrategyGrib;
import ucar.nc2.write.Nc4ChunkingStrategyNone;

@Immutable
public abstract class Nc4ChunkingStrategy
implements Nc4Chunking {
    private final int deflateLevel;
    private final boolean shuffle;

    public static Nc4Chunking factory(Nc4Chunking.Strategy type, int deflateLevel, boolean shuffle) {
        switch (type) {
            case standard: {
                return new Nc4ChunkingDefault(deflateLevel, shuffle);
            }
            case grib: {
                return new Nc4ChunkingStrategyGrib(deflateLevel, shuffle);
            }
            case none: {
                return new Nc4ChunkingStrategyNone();
            }
        }
        throw new IllegalArgumentException("Illegal Nc4Chunking.Standard " + (Object)((Object)type));
    }

    protected Nc4ChunkingStrategy(int deflateLevel, boolean shuffle) {
        this.deflateLevel = deflateLevel;
        this.shuffle = shuffle;
    }

    @Override
    public int getDeflateLevel(Variable v) {
        return this.deflateLevel;
    }

    @Override
    public boolean isShuffle(Variable v) {
        return this.shuffle;
    }

    protected Attribute getChunkAttribute(Variable v) {
        Attribute att = v.findAttribute("_ChunkSizes");
        if (att != null && att.getDataType().isIntegral() && att.getLength() == v.getRank()) {
            return att;
        }
        return null;
    }

    protected int[] computeChunkingFromAttribute(Variable v) {
        Attribute att = this.getChunkAttribute(v);
        if (att != null) {
            int[] result = new int[v.getRank()];
            for (int i = 0; i < v.getRank(); ++i) {
                result[i] = att.getNumericValue(i).intValue();
            }
            return result;
        }
        return null;
    }
}

