/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.tests.testng.TestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MetadataConfigurableTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataConfigurableTest.class);
    private static final String FILENAME_PROPERTY = "testng.filename";
    private static final String SKIP_MESSAGE = "No image file specified";
    private ImageReader pixelsOnly;
    private ImageReader all;
    private ImageReader noOverlays;
    private String id;

    @BeforeClass
    public void setUp() {
        this.pixelsOnly = new ImageReader();
        this.pixelsOnly.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(MetadataLevel.MINIMUM));
        this.all = new ImageReader();
        this.all.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(MetadataLevel.ALL));
        this.noOverlays = new ImageReader();
        this.noOverlays.setMetadataOptions((MetadataOptions)new DefaultMetadataOptions(MetadataLevel.NO_OVERLAYS));
        this.id = TestTools.getProperty(FILENAME_PROPERTY);
        if (null == this.id) {
            LOGGER.error(SKIP_MESSAGE);
            throw new SkipException(SKIP_MESSAGE);
        }
    }

    @Test
    public void testSetId() throws FormatException, IOException {
        long t0 = System.currentTimeMillis();
        this.pixelsOnly.setId(this.id);
        AssertJUnit.assertEquals((Object)MetadataLevel.MINIMUM, (Object)this.pixelsOnly.getMetadataOptions().getMetadataLevel());
        long t1 = System.currentTimeMillis();
        this.all.setId(this.id);
        AssertJUnit.assertEquals((Object)MetadataLevel.ALL, (Object)this.all.getMetadataOptions().getMetadataLevel());
        AssertJUnit.assertFalse((0 == this.all.getSeriesMetadata().size() + this.all.getGlobalMetadata().size() ? 1 : 0) != 0);
        long t2 = System.currentTimeMillis();
        System.err.println(String.format("Pixels only: %d -- All: %d", t1 - t0, t2 - t1));
        OMEXMLMetadata metadata = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            metadata = service.createOMEXMLMetadata();
            this.noOverlays.setMetadataStore((MetadataStore)metadata);
        }
        catch (Exception e) {
            throw new FormatException("Cannot initialize OMEXML metadata store");
        }
        this.noOverlays.setId(this.id);
        AssertJUnit.assertEquals((Object)MetadataLevel.NO_OVERLAYS, (Object)this.noOverlays.getMetadataOptions().getMetadataLevel());
        AssertJUnit.assertEquals((int)metadata.getROICount(), (int)0);
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testDimensions() {
        AssertJUnit.assertEquals((int)this.all.getSeriesCount(), (int)this.pixelsOnly.getSeriesCount());
        AssertJUnit.assertEquals((int)this.all.getSeriesCount(), (int)this.noOverlays.getSeriesCount());
        for (int i = 0; i < this.pixelsOnly.getSeriesCount(); ++i) {
            this.all.setSeries(i);
            this.pixelsOnly.setSeries(i);
            this.noOverlays.setSeries(i);
            AssertJUnit.assertEquals((int)this.all.getSizeX(), (int)this.pixelsOnly.getSizeX());
            AssertJUnit.assertEquals((int)this.all.getSizeY(), (int)this.pixelsOnly.getSizeY());
            AssertJUnit.assertEquals((int)this.all.getSizeZ(), (int)this.pixelsOnly.getSizeZ());
            AssertJUnit.assertEquals((int)this.all.getSizeC(), (int)this.pixelsOnly.getSizeC());
            AssertJUnit.assertEquals((int)this.all.getSizeT(), (int)this.pixelsOnly.getSizeT());
            AssertJUnit.assertEquals((int)this.all.getPixelType(), (int)this.pixelsOnly.getPixelType());
            AssertJUnit.assertEquals((boolean)this.all.isLittleEndian(), (boolean)this.pixelsOnly.isLittleEndian());
            AssertJUnit.assertEquals((boolean)this.all.isIndexed(), (boolean)this.pixelsOnly.isIndexed());
            AssertJUnit.assertEquals((int)this.all.getSizeX(), (int)this.noOverlays.getSizeX());
            AssertJUnit.assertEquals((int)this.all.getSizeY(), (int)this.noOverlays.getSizeY());
            AssertJUnit.assertEquals((int)this.all.getSizeZ(), (int)this.noOverlays.getSizeZ());
            AssertJUnit.assertEquals((int)this.all.getSizeC(), (int)this.noOverlays.getSizeC());
            AssertJUnit.assertEquals((int)this.all.getSizeT(), (int)this.noOverlays.getSizeT());
            AssertJUnit.assertEquals((int)this.all.getPixelType(), (int)this.noOverlays.getPixelType());
            AssertJUnit.assertEquals((boolean)this.all.isLittleEndian(), (boolean)this.noOverlays.isLittleEndian());
            AssertJUnit.assertEquals((boolean)this.all.isIndexed(), (boolean)this.noOverlays.isIndexed());
        }
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testPlaneData() throws FormatException, IOException {
        for (int i = 0; i < this.pixelsOnly.getSeriesCount(); ++i) {
            this.pixelsOnly.setSeries(i);
            this.all.setSeries(i);
            this.noOverlays.setSeries(i);
            AssertJUnit.assertEquals((int)this.all.getImageCount(), (int)this.pixelsOnly.getImageCount());
            AssertJUnit.assertEquals((int)this.all.getImageCount(), (int)this.noOverlays.getImageCount());
            for (int j = 0; j < this.pixelsOnly.getImageCount(); ++j) {
                byte[] pixelsOnlyPlane = this.pixelsOnly.openBytes(j);
                String pixelsOnlySHA1 = this.sha1(pixelsOnlyPlane);
                byte[] allPlane = this.all.openBytes(j);
                String allSHA1 = this.sha1(allPlane);
                byte[] noOverlaysPlane = this.noOverlays.openBytes(j);
                String noOverlaysSHA1 = this.sha1(noOverlaysPlane);
                if (!pixelsOnlySHA1.equals(allSHA1)) {
                    AssertJUnit.fail((String)String.format("MISMATCH: Series:%d Image:%d PixelsOnly%s All:%s", i, j, pixelsOnlySHA1, allSHA1));
                }
                if (noOverlaysSHA1.equals(allSHA1)) continue;
                AssertJUnit.fail((String)String.format("MISMATCH: Series:%d Image:%d PixelsOnly%s All:%s", i, j, noOverlaysSHA1, allSHA1));
            }
        }
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testUsedFiles() throws FormatException, IOException {
        for (int i = 0; i < this.pixelsOnly.getSeriesCount(); ++i) {
            this.pixelsOnly.setSeries(i);
            this.all.setSeries(i);
            this.noOverlays.setSeries(i);
            Object[] pixelsOnlyFiles = this.pixelsOnly.getSeriesUsedFiles();
            Object[] allFiles = this.all.getSeriesUsedFiles();
            Object[] noOverlaysFiles = this.noOverlays.getSeriesUsedFiles();
            AssertJUnit.assertEquals((int)allFiles.length, (int)pixelsOnlyFiles.length);
            AssertJUnit.assertEquals((int)allFiles.length, (int)noOverlaysFiles.length);
            Arrays.sort(allFiles);
            Arrays.sort(pixelsOnlyFiles);
            Arrays.sort(noOverlaysFiles);
            for (int j = 0; j < pixelsOnlyFiles.length; ++j) {
                AssertJUnit.assertEquals((String)allFiles[j], (String)pixelsOnlyFiles[j]);
                AssertJUnit.assertEquals((String)allFiles[j], (String)noOverlaysFiles[j]);
            }
        }
    }

    private String sha1(byte[] buf) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return DataTools.bytesToHex((byte[])md.digest(buf));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

