/*
 * Decompiled with CFR 0.152.
 */
import loci.common.image.SimpleImageScaler;
import loci.common.services.ServiceFactory;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEPyramidStore;
import loci.formats.services.OMEXMLService;
import ome.xml.model.primitives.PositiveInteger;

public class GeneratePyramidResolutions {
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("GeneratePyramidResolutions input-file scale-factor resolution-count output-file");
            System.exit(1);
        }
        String in = args[0];
        String out = args[3];
        int scale = Integer.parseInt(args[1]);
        int resolutions = Integer.parseInt(args[2]);
        ImageReader reader = new ImageReader();
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        OMEPyramidStore meta = (OMEPyramidStore)service.createOMEXMLMetadata();
        reader.setMetadataStore((MetadataStore)meta);
        reader.setId(in);
        for (int i = 1; i < resolutions; ++i) {
            int divScale = (int)Math.pow(scale, i);
            meta.setResolutionSizeX(new PositiveInteger(Integer.valueOf(reader.getSizeX() / divScale)), 0, i);
            meta.setResolutionSizeY(new PositiveInteger(Integer.valueOf(reader.getSizeY() / divScale)), 0, i);
        }
        SimpleImageScaler scaler = new SimpleImageScaler();
        byte[] img = reader.openBytes(0);
        System.out.println("Writing image to '" + out + "'...");
        ImageWriter writer = new ImageWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        writer.setId(out);
        writer.saveBytes(0, img);
        int type = reader.getPixelType();
        for (int i = 1; i < resolutions; ++i) {
            writer.setResolution(i);
            int x = (Integer)meta.getResolutionSizeX(0, i).getValue();
            int y = (Integer)meta.getResolutionSizeY(0, i).getValue();
            byte[] downsample = scaler.downsample(img, reader.getSizeX(), reader.getSizeY(), Math.pow(scale, i), FormatTools.getBytesPerPixel((int)type), reader.isLittleEndian(), FormatTools.isFloatingPoint((int)type), reader.getRGBChannelCount(), reader.isInterleaved());
            writer.saveBytes(0, downsample);
        }
        writer.close();
        reader.close();
        System.out.println("Done.");
    }
}

