/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.meta.IMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Arc;
import ome.xml.model.Filament;
import ome.xml.model.Instrument;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightSource;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetLightSourceTypeTest {
    private IMetadata metadata;

    @BeforeClass
    public void setUp() throws Exception {
        this.metadata = new OMEXMLMetadataImpl();
        OMEXMLMetadataRoot ome = new OMEXMLMetadataRoot();
        Instrument instrument = new Instrument();
        instrument.addLightSource((LightSource)new Arc());
        instrument.addLightSource((LightSource)new Filament());
        instrument.addLightSource((LightSource)new Laser());
        instrument.addLightSource((LightSource)new LightEmittingDiode());
        ome.addInstrument(instrument);
        this.metadata.setRoot((MetadataRoot)ome);
    }

    @Test
    public void testLightSourceType() throws Exception {
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getInstrumentCount());
        AssertJUnit.assertEquals((int)4, (int)this.metadata.getLightSourceCount(0));
        AssertJUnit.assertEquals((String)"Arc", (String)this.metadata.getLightSourceType(0, 0));
        AssertJUnit.assertEquals((String)"Filament", (String)this.metadata.getLightSourceType(0, 1));
        AssertJUnit.assertEquals((String)"Laser", (String)this.metadata.getLightSourceType(0, 2));
        AssertJUnit.assertEquals((String)"LightEmittingDiode", (String)this.metadata.getLightSourceType(0, 3));
    }
}

