/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.out;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.ICSReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.ICSWriter;
import loci.formats.utests.out.Plane;
import loci.formats.utests.out.WriterUtilities;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.junit.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ICSWriterTest {
    private ICSWriter writer;
    private static int percentageOfSaveBytesTests = 0;

    @DataProvider(name="writeParams")
    public Object[][] createParams() {
        if (percentageOfSaveBytesTests == 0) {
            return new Object[][]{{0, false, false, 0, 0, 0, null, 0, false}};
        }
        int[] tileSizes = new int[]{0};
        int[] channelCounts = new int[]{1, 3};
        int[] seriesCounts = new int[]{1, 3};
        int[] timeCounts = new int[]{1, 5};
        String[] compressions = new String[]{WriterUtilities.COMPRESSION_UNCOMPRESSED};
        return WriterUtilities.getData(tileSizes, channelCounts, seriesCounts, timeCounts, compressions, percentageOfSaveBytesTests);
    }

    @BeforeClass
    public void readProperty() throws Exception {
        percentageOfSaveBytesTests = WriterUtilities.getPropValue("testng.runWriterSaveBytesTests");
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.writer = new ICSWriter();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.writer.close();
    }

    @Test
    public void testGetPixelTypes() {
        Assert.assertArrayEquals((int[])WriterUtilities.pixelTypesICS, (int[])this.writer.getPixelTypes(WriterUtilities.COMPRESSION_UNCOMPRESSED));
    }

    @Test
    public void testIncompatiblePhysicalSizeUnit() throws DependencyException, ServiceException, FormatException, IOException {
        IMetadata metadata = WriterUtilities.createMetadata();
        Length physicalSizeX = FormatTools.getPhysicalSizeX((Double)10.0, (Unit)UNITS.PIXEL);
        metadata.setPixelsPhysicalSizeX(physicalSizeX, 0);
        Length physicalSizeY = FormatTools.getPhysicalSizeY((Double)10.0, (Unit)UNITS.PIXEL);
        metadata.setPixelsPhysicalSizeY(physicalSizeY, 0);
        Length physicalSizeZ = FormatTools.getPhysicalSizeZ((Double)10.0, (Unit)UNITS.PIXEL);
        metadata.setPixelsPhysicalSizeZ(physicalSizeZ, 0);
        this.writer.setMetadataRetrieve((MetadataRetrieve)metadata);
        File tmp = File.createTempFile("icsWriterTest", ".ics");
        tmp.deleteOnExit();
        this.writer.setId(tmp.getAbsolutePath());
    }

    public void testSaveBytes(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfSaveBytesTests == 0) {
            return;
        }
        File tmp = File.createTempFile("icsWriterTest", ".ics");
        tmp.deleteOnExit();
        String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
        this.writer.setMetadataRetrieve((MetadataRetrieve)WriterUtilities.createMetadata(pixelTypeString, rgbChannels, seriesCount, littleEndian, sizeT));
        this.writer.setCompression(compression);
        this.writer.setInterleaved(interleaved);
        if (tileSize != 0) {
            this.writer.setTileSizeX(tileSize);
            this.writer.setTileSizeY(tileSize);
        }
        this.writer.setId(tmp.getAbsolutePath());
        int bytes = FormatTools.getBytesPerPixel((int)pixelType);
        byte[] plane = WriterUtilities.getPlane(160, 160, bytes * rgbChannels);
        Plane originalPlane = new Plane(plane, littleEndian, !this.writer.isInterleaved(), rgbChannels, FormatTools.getPixelTypeString((int)pixelType));
        for (int s = 0; s < seriesCount; ++s) {
            this.writer.setSeries(s);
            for (int t = 0; t < sizeT; ++t) {
                this.writer.saveBytes(t, plane);
            }
        }
        ICSReader reader = new ICSReader();
        reader.setId(tmp.getAbsolutePath());
        for (int s = 0; s < reader.getSeriesCount(); ++s) {
            reader.setSeries(s);
            org.testng.Assert.assertEquals((int)reader.getSizeC(), (int)rgbChannels);
            int imageCount = reader.isRGB() ? seriesCount * sizeT : rgbChannels * sizeT * seriesCount;
            org.testng.Assert.assertEquals((int)reader.getImageCount(), (int)imageCount);
            for (int image = 0; image < reader.getImageCount(); ++image) {
                byte[] readPlane = reader.openBytes(image);
                Plane newPlane = new Plane(readPlane, reader.isLittleEndian(), !reader.isInterleaved(), reader.getRGBChannelCount(), FormatTools.getPixelTypeString((int)reader.getPixelType()));
                assert (originalPlane.equals(newPlane));
            }
        }
        tmp.delete();
        reader.close();
    }

    public void testSaveBytesInMemory(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfSaveBytesTests == 0) {
            return;
        }
        ByteArrayHandle handle = new ByteArrayHandle();
        String id = Math.random() + "-" + System.currentTimeMillis() + ".ics";
        Location.mapFile((String)id, (IRandomAccess)handle);
        String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
        this.writer.setMetadataRetrieve((MetadataRetrieve)WriterUtilities.createMetadata(pixelTypeString, rgbChannels, seriesCount, littleEndian, sizeT));
        this.writer.setCompression(compression);
        this.writer.setInterleaved(interleaved);
        if (tileSize != 0) {
            this.writer.setTileSizeX(tileSize);
            this.writer.setTileSizeY(tileSize);
        }
        this.writer.setId(id);
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        byte[] plane = WriterUtilities.getPlane(160, 160, bpp * rgbChannels);
        Plane originalPlane = new Plane(plane, littleEndian, !this.writer.isInterleaved(), rgbChannels, FormatTools.getPixelTypeString((int)pixelType));
        for (int s = 0; s < seriesCount; ++s) {
            this.writer.setSeries(s);
            for (int t = 0; t < sizeT; ++t) {
                this.writer.saveBytes(t, plane);
            }
        }
        ByteBuffer bytes = handle.getByteBuffer();
        byte[] file = new byte[(int)handle.length()];
        bytes.position(0);
        bytes.get(file);
        handle = new ByteArrayHandle(file);
        Location.mapFile((String)id, (IRandomAccess)handle);
        ICSReader reader = new ICSReader();
        reader.setId(id);
        for (int s = 0; s < reader.getSeriesCount(); ++s) {
            reader.setSeries(s);
            org.testng.Assert.assertEquals((int)reader.getSizeC(), (int)rgbChannels);
            int imageCount = reader.isRGB() ? seriesCount * sizeT : rgbChannels * sizeT * seriesCount;
            org.testng.Assert.assertEquals((int)reader.getImageCount(), (int)imageCount);
            for (int image = 0; image < reader.getImageCount(); ++image) {
                byte[] readPlane = reader.openBytes(image);
                Plane newPlane = new Plane(readPlane, reader.isLittleEndian(), !reader.isInterleaved(), reader.getRGBChannelCount(), FormatTools.getPixelTypeString((int)reader.getPixelType()));
                assert (originalPlane.equals(newPlane));
            }
        }
        reader.close();
        Location.mapFile((String)id, null);
    }
}

