/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.AxisGuesser;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.DimensionSwapper;
import loci.formats.FileInfo;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.ReaderWrapper;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStitcher
extends ReaderWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStitcher.class);
    private static final int MAX_READERS = 1000;
    private boolean patternIds = false;
    private boolean doNotChangePattern = false;
    private int[] sizeZ;
    private int[] sizeC;
    private int[] sizeT;
    private int[][] lenZ;
    private int[][] lenC;
    private int[][] lenT;
    private ArrayList<CoreMetadata> core = new ArrayList();
    private int coreIndex;
    private int series;
    private boolean noStitch;
    private boolean group = true;
    private MetadataStore store;
    private ExternalSeries[] externals;
    private ClassList<IFormatReader> classList;

    public FileStitcher() {
        this((IFormatReader)new ImageReader());
    }

    public FileStitcher(boolean patternIds) {
        this((IFormatReader)new ImageReader(), patternIds);
    }

    public FileStitcher(IFormatReader r) {
        this(r, false);
    }

    public FileStitcher(IFormatReader r, boolean patternIds) {
        super(r);
        if (r.getClass().getPackage().getName().equals("loci.formats.in")) {
            ClassList classes = new ClassList(IFormatReader.class);
            classes.addClass(r.getClass());
            this.setReaderClassList((ClassList<IFormatReader>)classes);
        } else {
            this.reader = DimensionSwapper.makeDimensionSwapper(r);
        }
        this.setUsingPatternIds(patternIds);
    }

    public void setReaderClassList(ClassList<IFormatReader> classList) {
        this.classList = classList;
        try {
            this.reader.close(true);
        }
        catch (IOException e) {
            LOGGER.debug("Close failed", (Throwable)e);
        }
        this.reader = DimensionSwapper.makeDimensionSwapper((IFormatReader)new ImageReader(classList));
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public void setUsingPatternIds(boolean patternIds) {
        this.patternIds = patternIds;
    }

    public boolean isUsingPatternIds() {
        return this.patternIds;
    }

    public void setCanChangePattern(boolean doChange) {
        this.doNotChangePattern = !doChange;
    }

    public boolean canChangePattern() {
        return !this.doNotChangePattern;
    }

    public IFormatReader getReader(int no) throws FormatException, IOException {
        if (this.noStitch) {
            return this.reader;
        }
        int[] q = this.computeIndices(no);
        int fno = q[0];
        return this.getReader(this.getCoreIndex(), fno);
    }

    public DimensionSwapper getReader(int series, int no) {
        if (this.noStitch) {
            return (DimensionSwapper)this.reader;
        }
        DimensionSwapper r = this.externals[this.getExternalSeries(series)].getReader(no);
        this.initReader(series, no);
        return r;
    }

    public int getAdjustedIndex(int no) throws FormatException, IOException {
        if (this.noStitch) {
            return no;
        }
        int[] q = this.computeIndices(no);
        int ino = q[1];
        return ino;
    }

    public int[] getAxisTypes() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.getAxisGuesser().getAxisTypes();
    }

    public void setAxisTypes(int[] axes) throws FormatException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        this.getAxisGuesser().setAxisTypes(axes);
        this.computeAxisLengths();
    }

    public FilePattern getFilePattern() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.findPattern(this.getCurrentFile()) : this.externals[this.getExternalSeries()].getFilePattern();
    }

    public AxisGuesser getAxisGuesser() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        if (this.externals == null) {
            return new AxisGuesser(this.getFilePattern(), this.reader.getDimensionOrder(), this.reader.getSizeZ(), this.reader.getSizeT(), this.reader.getEffectiveSizeC(), this.reader.isOrderCertain());
        }
        return this.externals[this.getExternalSeries()].getAxisGuesser();
    }

    public FilePattern findPattern(String id) {
        return new FilePattern(FilePattern.findPattern(id));
    }

    public String[] findPatterns(String id) {
        if (!this.patternIds) {
            HashMap<String, Object> map = Location.getIdMap();
            if (map.containsKey(id)) {
                String[] idList = new String[map.size()];
                map.keySet().toArray(idList);
                return FilePattern.findSeriesPatterns(id, null, idList);
            }
            return FilePattern.findSeriesPatterns(id);
        }
        if (this.doNotChangePattern) {
            return new String[]{id};
        }
        this.patternIds = false;
        String[] patterns = this.findPatterns(new FilePattern(id).getFiles()[0]);
        if (patterns.length == 0) {
            patterns = new String[]{id};
        } else {
            FilePattern test = new FilePattern(patterns[0]);
            if (test.getFiles().length == 0) {
                patterns = new String[]{id};
            }
        }
        this.patternIds = true;
        return patterns;
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return this.reader.getRequiredDirectories(files);
    }

    public int getImageCount() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getImageCount() : this.core.get((int)this.getCoreIndex()).imageCount;
    }

    public boolean isRGB() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isRGB() : this.core.get((int)this.getCoreIndex()).rgb;
    }

    public int getSizeX() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getSizeX() : this.core.get((int)this.getCoreIndex()).sizeX;
    }

    public int getSizeY() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getSizeY() : this.core.get((int)this.getCoreIndex()).sizeY;
    }

    public int getSizeZ() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getSizeZ() : this.core.get((int)this.getCoreIndex()).sizeZ;
    }

    public int getSizeC() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getSizeC() : this.core.get((int)this.getCoreIndex()).sizeC;
    }

    public int getSizeT() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getSizeT() : this.core.get((int)this.getCoreIndex()).sizeT;
    }

    public int getPixelType() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getPixelType() : this.core.get((int)this.getCoreIndex()).pixelType;
    }

    public int getBitsPerPixel() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getBitsPerPixel() : this.core.get((int)this.getCoreIndex()).bitsPerPixel;
    }

    public boolean isIndexed() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isIndexed() : this.core.get((int)this.getCoreIndex()).indexed;
    }

    public boolean isFalseColor() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isFalseColor() : this.core.get((int)this.getCoreIndex()).falseColor;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.get8BitLookupTable() : this.getReader(this.getCoreIndex(), 0).get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.get16BitLookupTable() : this.getReader(this.getCoreIndex(), 0).get16BitLookupTable();
    }

    public int getThumbSizeX() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getThumbSizeX() : this.getReader(this.getCoreIndex(), 0).getThumbSizeX();
    }

    public int getThumbSizeY() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getThumbSizeY() : this.getReader(this.getCoreIndex(), 0).getThumbSizeY();
    }

    public boolean isLittleEndian() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isLittleEndian() : this.getReader(this.getCoreIndex(), 0).isLittleEndian();
    }

    public String getDimensionOrder() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        if (this.noStitch) {
            return this.reader.getDimensionOrder();
        }
        return this.core.get((int)this.getCoreIndex()).dimensionOrder;
    }

    public boolean isOrderCertain() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isOrderCertain() : this.core.get((int)this.getCoreIndex()).orderCertain;
    }

    public boolean isThumbnailSeries() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isThumbnailSeries() : this.core.get((int)this.getCoreIndex()).thumbnail;
    }

    public boolean isInterleaved() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isInterleaved() : this.getReader(this.getCoreIndex(), 0).isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.isInterleaved(subC) : this.getReader(this.getCoreIndex(), 0).isInterleaved(subC);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int ch = this.getRGBChannelCount();
        byte[] buf = DataTools.allocate(w, h, ch, bpp);
        return this.openBytes(no, buf, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int[] pos = this.computeIndices(no);
        DimensionSwapper r = this.getReader(this.getCoreIndex(), pos[0]);
        int ino = pos[1];
        if (ino < r.getImageCount()) {
            byte[] b = r.openBytes(ino, buf, x, y, w, h);
            if (!this.noStitch && ino == r.getImageCount() - 1) {
                r.close();
            }
            return b;
        }
        Arrays.fill(buf, this.getFillColor());
        return buf;
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        IFormatReader r = this.getReader(no);
        int ino = this.getAdjustedIndex(no);
        if (ino < r.getImageCount()) {
            return r.openPlane(ino, x, y, w, h);
        }
        return null;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        IFormatReader r = this.getReader(no);
        int ino = this.getAdjustedIndex(no);
        if (ino < r.getImageCount()) {
            return r.openThumbBytes(ino);
        }
        return this.externals[this.getExternalSeries()].getBlankThumbBytes();
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.externals != null) {
            for (ExternalSeries s : this.externals) {
                if (s == null) continue;
                s.close(fileOnly);
            }
        }
        if (!fileOnly) {
            this.noStitch = false;
            this.externals = null;
            this.sizeT = null;
            this.sizeC = null;
            this.sizeZ = null;
            this.lenT = null;
            this.lenC = null;
            this.lenZ = null;
            this.core.clear();
            this.coreIndex = 0;
            this.series = 0;
            this.store = null;
        }
    }

    public int getSeriesCount() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        if (this.noStitch) {
            return this.reader.getSeriesCount();
        }
        if (this.hasFlattenedResolutions()) {
            return this.core.size();
        }
        return this.coreIndexToSeries(this.core.size() - 1) + 1;
    }

    public void setSeries(int no) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int n = this.reader.getCoreMetadataList().size();
        if (n > 1 || this.noStitch) {
            this.reader.setSeries(no);
        }
        this.setCoreIndex(this.seriesToCoreIndex(no));
        this.reader.setResolution(0);
    }

    public int getSeries() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.reader.getSeries() > 0 ? this.reader.getSeries() : this.series;
    }

    public void setResolution(int no) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        this.coreIndex = this.coreIndex - this.getResolution() + no;
        this.reader.setResolution(no);
        this.reader.setCoreIndex(this.coreIndex);
    }

    public int getResolution() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int n = this.reader.getCoreMetadataList().size();
        if (n > 1 || this.noStitch) {
            return this.reader.getResolution();
        }
        if (this.hasFlattenedResolutions()) {
            return 0;
        }
        return this.getCoreIndex() - this.coreIndexToSeries(this.getCoreIndex());
    }

    public int seriesToCoreIndex(int series) {
        int n = this.reader.getCoreMetadataList().size();
        if (n > 1 || this.noStitch) {
            return this.reader.seriesToCoreIndex(series);
        }
        return series;
    }

    public int coreIndexToSeries(int index) {
        int n = this.reader.getCoreMetadataList().size();
        if (n > 1 || this.noStitch) {
            return this.reader.coreIndexToSeries(index);
        }
        return index;
    }

    public void setCoreIndex(int no) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int n = this.reader.getCoreMetadataList().size();
        if (n > 1 || this.noStitch) {
            this.reader.setCoreIndex(no);
        } else {
            this.series = no;
        }
        this.coreIndex = no;
    }

    public int getCoreIndex() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.reader.getCoreIndex() > 0 ? this.reader.getCoreIndex() : this.coreIndex;
    }

    public void setFlattenedResolutions(boolean flatten) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)false, (int)2);
        if (this.externals == null) {
            this.reader.setFlattenedResolutions(flatten);
        } else {
            for (ExternalSeries s : this.externals) {
                for (DimensionSwapper r : s.getReaders()) {
                    r.setFlattenedResolutions(flatten);
                }
            }
        }
    }

    public void setGroupFiles(boolean group) {
        this.group = group;
    }

    public boolean isGroupFiles() {
        return this.group;
    }

    public void setMetadataOptions(MetadataOptions options) {
        super.setMetadataOptions(options);
        if (this.externals != null) {
            for (ExternalSeries s : this.externals) {
                for (DimensionSwapper r : s.getReaders()) {
                    r.setMetadataOptions(options);
                }
            }
        }
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)false, (int)2);
        if (this.externals == null) {
            this.reader.setNormalized(normalize);
        } else {
            for (ExternalSeries s : this.externals) {
                for (DimensionSwapper r : s.getReaders()) {
                    r.setNormalized(normalize);
                }
            }
        }
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)false, (int)1);
        if (this.externals == null) {
            this.reader.setOriginalMetadataPopulated(populate);
        } else {
            for (ExternalSeries s : this.externals) {
                for (DimensionSwapper r : s.getReaders()) {
                    r.setOriginalMetadataPopulated(populate);
                }
            }
        }
    }

    public String[] getUsedFiles() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        if (this.noStitch) {
            return this.reader.getUsedFiles();
        }
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        for (ExternalSeries s : this.externals) {
            String[] f;
            for (String file : f = s.getFiles()) {
                String path = new Location(file).getAbsolutePath();
                files.add(path);
            }
            DimensionSwapper[] readers = s.getReaders();
            for (int i = 0; i < readers.length; ++i) {
                try {
                    String[] used;
                    readers[i].setId(f[i]);
                    for (String file : used = readers[i].getUsedFiles()) {
                        String path = new Location(file).getAbsolutePath();
                        files.add(path);
                    }
                    readers[i].close();
                    continue;
                }
                catch (FormatException e) {
                    LOGGER.debug("", (Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    LOGGER.debug("", (Throwable)e);
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] getUsedFiles(boolean noPixels) {
        return noPixels && this.noStitch ? this.reader.getUsedFiles(noPixels) : this.getUsedFiles();
    }

    public String[] getSeriesUsedFiles() {
        return this.getUsedFiles();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        return this.getUsedFiles(noPixels);
    }

    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        if (this.noStitch) {
            return this.reader.getAdvancedUsedFiles(noPixels);
        }
        String[] files = this.getUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            try {
                infos[i].reader = ((DimensionSwapper)this.reader).unwrap().getClass();
            }
            catch (FormatException e) {
                LOGGER.debug("", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.debug("", (Throwable)e);
            }
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        if (this.noStitch) {
            return this.reader.getAdvancedSeriesUsedFiles(noPixels);
        }
        String[] files = this.getSeriesUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            try {
                infos[i].reader = ((DimensionSwapper)this.reader).unwrap().getClass();
            }
            catch (FormatException e) {
                LOGGER.debug("", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.debug("", (Throwable)e);
            }
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    public int getIndex(int z, int c, int t) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return FormatTools.getIndex((IFormatReader)this, (int)z, (int)c, (int)t);
    }

    public int getIndex(int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return FormatTools.getIndex((IFormatReader)this, (int)z, (int)c, (int)t, (int)moduloZ, (int)moduloC, (int)moduloT);
    }

    public int[] getZCTCoords(int index) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getZCTCoords(index) : FormatTools.getZCTCoords((String)this.core.get((int)this.getCoreIndex()).dimensionOrder, (int)this.getSizeZ(), (int)this.getEffectiveSizeC(), (int)this.getSizeT(), (int)this.getImageCount(), (int)index);
    }

    public int[] getZCTModuloCoords(int index) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getZCTModuloCoords(index) : FormatTools.getZCTCoords((String)this.core.get((int)this.getCoreIndex()).dimensionOrder, (int)this.getSizeZ(), (int)this.getEffectiveSizeC(), (int)this.getSizeT(), (int)this.getModuloZ().length(), (int)this.getModuloC().length(), (int)this.getModuloT().length(), (int)this.getImageCount(), (int)index);
    }

    public Hashtable<String, Object> getSeriesMetadata() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getSeriesMetadata() : this.core.get((int)this.getCoreIndex()).seriesMetadata;
    }

    public List<CoreMetadata> getCoreMetadataList() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getCoreMetadataList() : this.core;
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)false, (int)2);
        this.reader.setMetadataStore(store);
        this.store = store;
    }

    public MetadataStore getMetadataStore() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getMetadataStore() : this.store;
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.noStitch ? this.reader.getMetadataStoreRoot() : this.store.getRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        if (null == this.externals) {
            return super.getUnderlyingReaders();
        }
        ArrayList<DimensionSwapper> list = new ArrayList<DimensionSwapper>();
        for (ExternalSeries s : this.externals) {
            for (DimensionSwapper r : s.getReaders()) {
                list.add(r);
            }
        }
        return list.toArray(new IFormatReader[0]);
    }

    public void reopenFile() throws IOException {
        this.reader.reopenFile();
        if (this.externals != null) {
            for (ExternalSeries s : this.externals) {
                for (DimensionSwapper r : s.getReaders()) {
                    if (r.getCurrentFile() == null) continue;
                    r.reopenFile();
                }
            }
        }
    }

    public void setId(String id) throws FormatException, IOException {
        if (this.getCurrentFile() != null && new Location(id).getAbsolutePath().equals(this.getCurrentFile())) {
            return;
        }
        this.close();
        this.initFile(id);
    }

    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int[] pos = this.computeIndices(no);
        DimensionSwapper r = this.getReader(this.getCoreIndex(), pos[0]);
        int ino = pos[1];
        if (ino < r.getImageCount()) {
            return r.openCompressedBytes(ino, x, y);
        }
        throw new IOException("Compressed tile not available");
    }

    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int[] pos = this.computeIndices(no);
        DimensionSwapper r = this.getReader(this.getCoreIndex(), pos[0]);
        int ino = pos[1];
        if (ino < r.getImageCount()) {
            return r.openCompressedBytes(ino, x, y);
        }
        throw new IOException("Compressed tile not available");
    }

    public Codec getTileCodec(int no) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int[] pos = this.computeIndices(no);
        DimensionSwapper r = this.getReader(this.getCoreIndex(), pos[0]);
        int ino = pos[1];
        if (ino < r.getImageCount()) {
            return r.getTileCodec(ino);
        }
        throw new IOException("Compressed tile not available");
    }

    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        int[] pos = this.computeIndices(no);
        DimensionSwapper r = this.getReader(this.getCoreIndex(), pos[0]);
        int ino = pos[1];
        if (ino < r.getImageCount()) {
            return r.getTileCodecOptions(ino, x, y);
        }
        throw new IOException("Compressed tile not available");
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String[] patterns;
        LOGGER.debug("initFile: {}", (Object)id);
        FilePattern fp = new FilePattern(id);
        if (!this.patternIds) {
            this.patternIds = fp.isValid() && fp.getFiles().length > 1;
        } else if (this.canChangePattern() || !Location.getMappedId(id).equals(id)) {
            this.patternIds = !new Location(id).exists() && Location.getMappedId(id).equals(id);
        }
        boolean mustGroup = false;
        if (this.patternIds) {
            mustGroup = fp.isValid() && this.reader.fileGroupOption(fp.getFiles()[0]) == 0;
        } else {
            boolean bl = mustGroup = this.reader.fileGroupOption(id) == 0;
        }
        if (mustGroup || !this.group) {
            this.noStitch = true;
            this.reader.close();
            this.reader.setGroupFiles(this.group);
            if (this.patternIds && fp.isValid()) {
                this.reader.setId(fp.getFiles()[0]);
            } else {
                this.reader.setId(id);
            }
            LOGGER.info("File pattern ignored; {} groups files", (Object)this.reader.getFormat());
            return;
        }
        if (fp.isRegex()) {
            this.setCanChangePattern(false);
        }
        if ((patterns = this.findPatterns(id)).length == 0) {
            patterns = new String[]{id};
        }
        ArrayList<ExternalSeries[]> validExternals = new ArrayList<ExternalSeries[]>();
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            try {
                ExternalSeries[] e = new ExternalSeries(new FilePattern(patterns[i2]));
                validExternals.add(e);
                continue;
            }
            catch (FileNotFoundException e) {
                LOGGER.trace("Could not use pattern " + patterns[i2], (Throwable)e);
            }
        }
        if (validExternals.size() == 0) {
            patterns = new String[]{id};
            this.externals = new ExternalSeries[]{new ExternalSeries(new FilePattern(id))};
        } else {
            this.externals = validExternals.toArray(new ExternalSeries[validExternals.size()]);
        }
        fp = new FilePattern(patterns[0]);
        this.reader.close();
        this.reader.setGroupFiles(this.group);
        if (!fp.isValid()) {
            throw new FormatException("Invalid file pattern: " + fp.getPattern());
        }
        try {
            this.reader.setId(fp.getFiles()[0]);
        }
        catch (FileNotFoundException e) {
            LOGGER.trace("Could not use pattern " + patterns[0], (Throwable)e);
            patterns = new String[]{id};
            fp = new FilePattern(id);
            if (this.externals != null) {
                for (ExternalSeries ex : this.externals) {
                    ex.close();
                }
            }
            this.externals = new ExternalSeries[]{new ExternalSeries(fp)};
            this.reader.setId(fp.getFiles()[0]);
        }
        String msg = " Please rename your files or disable file stitching.";
        if (this.reader.getCoreMetadataList().size() > 1 && this.externals.length > 1) {
            throw new FormatException("Unsupported grouping: File pattern contains multiple files and each file contains multiple series." + msg);
        }
        int nPixelsFiles = this.reader.getUsedFiles().length - this.reader.getUsedFiles(true).length;
        if (nPixelsFiles > 1 || fp.getFiles().length == 1) {
            this.noStitch = true;
            for (ExternalSeries e : this.externals) {
                e.close();
            }
            return;
        }
        AxisGuesser guesser = new AxisGuesser(fp, this.reader.getDimensionOrder(), this.reader.getSizeZ(), this.reader.getSizeT(), this.reader.getEffectiveSizeC(), this.reader.isOrderCertain());
        ((DimensionSwapper)this.reader).swapDimensions(guesser.getAdjustedOrder());
        int seriesCount = this.externals.length;
        if (this.externals.length == 1) {
            seriesCount = this.reader.getCoreMetadataList().size();
        }
        if (!fp.isValid()) {
            throw new FormatException("Invalid " + (this.patternIds ? "file pattern" : "filename") + " (" + id + "): " + fp.getErrorMessage() + msg);
        }
        String[] files = fp.getFiles();
        if (files == null) {
            throw new FormatException("No files matching pattern (" + fp.getPattern() + "). " + msg);
        }
        for (int i3 = 0; i3 < files.length; ++i3) {
            String file = files[i3];
            if (file.toLowerCase().endsWith(".fake") || new Location(file).exists()) continue;
            throw new FormatException("File #" + i3 + " (" + file + ") does not exist.");
        }
        Class<?> readerClass = ((DimensionSwapper)this.reader).unwrap(files[0]).getClass();
        this.sizeZ = new int[seriesCount];
        this.sizeC = new int[seriesCount];
        this.sizeT = new int[seriesCount];
        boolean[] certain = new boolean[seriesCount];
        this.lenZ = new int[seriesCount][];
        this.lenC = new int[seriesCount][];
        this.lenT = new int[seriesCount][];
        this.core.clear();
        int oldSeries = this.getCoreIndex();
        for (i = 0; i < seriesCount; ++i) {
            DimensionSwapper rr = this.getReader(i, 0);
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            ms.sizeX = rr.getSizeX();
            ms.sizeY = rr.getSizeY();
            ms.pixelType = rr.getPixelType();
            ExternalSeries external = this.externals[this.getExternalSeries(i)];
            ms.imageCount = rr.getImageCount() * external.getFiles().length;
            ms.thumbSizeX = rr.getThumbSizeX();
            ms.thumbSizeY = rr.getThumbSizeY();
            ms.dimensionOrder = rr.getDimensionOrder();
            ms.rgb = rr.isRGB();
            ms.littleEndian = rr.isLittleEndian();
            ms.interleaved = rr.isInterleaved();
            ms.seriesMetadata = rr.getSeriesMetadata();
            ms.indexed = rr.isIndexed();
            ms.falseColor = rr.isFalseColor();
            ms.bitsPerPixel = rr.getBitsPerPixel();
            this.sizeZ[i] = rr.getSizeZ();
            this.sizeC[i] = rr.getSizeC();
            this.sizeT[i] = rr.getSizeT();
            certain[i] = rr.isOrderCertain();
        }
        for (i = 0; i < seriesCount; ++i) {
            this.setCoreIndex(i);
            AxisGuesser ag = this.externals[this.getExternalSeries()].getAxisGuesser();
            this.core.get((int)i).dimensionOrder = ag.getAdjustedOrder();
            this.core.get((int)i).orderCertain = ag.isCertain();
            this.computeAxisLengths();
        }
        this.setCoreIndex(oldSeries);
        this.store = this.reader.getMetadataStore();
        if (!this.noStitch) {
            MetadataTools.populatePixels((MetadataStore)this.store, (IFormatReader)this, (boolean)false, (boolean)false);
            if (this.reader.getCoreMetadataList().size() == 1 && this.getSeriesCount() > 1) {
                for (i = 0; i < this.getSeriesCount(); ++i) {
                    int index = this.getExternalSeries(i);
                    String pattern = this.externals[index].getFilePattern().getPattern();
                    pattern = pattern.substring(pattern.lastIndexOf(File.separator) + 1);
                    this.store.setImageName(pattern, i);
                }
            }
        }
    }

    private int getExternalSeries() {
        return this.getExternalSeries(this.getCoreIndex());
    }

    private int getExternalSeries(int currentSeries) {
        if (this.reader.getCoreMetadataList().size() > 1) {
            return 0;
        }
        return currentSeries;
    }

    protected void computeAxisLengths() throws FormatException {
        int sno = this.getCoreIndex();
        CoreMetadata ms = this.core.get(sno);
        ExternalSeries s = this.externals[this.getExternalSeries()];
        FilePattern p = s.getFilePattern();
        int[] count = p.getCount();
        this.initReader(sno, 0);
        AxisGuesser ag = s.getAxisGuesser();
        int[] axes = ag.getAxisTypes();
        int numZ = ag.getAxisCountZ();
        int numC = ag.getAxisCountC();
        int numT = ag.getAxisCountT();
        if (axes.length == 0 && s.getFiles().length > 1) {
            axes = new int[]{2};
            count = new int[]{s.getFiles().length};
            ++numT;
        }
        ms.sizeZ = this.sizeZ[sno];
        ms.sizeC = this.sizeC[sno];
        ms.sizeT = this.sizeT[sno];
        this.lenZ[sno] = new int[numZ + 1];
        this.lenC[sno] = new int[numC + 1];
        this.lenT[sno] = new int[numT + 1];
        this.lenZ[sno][0] = this.sizeZ[sno];
        this.lenC[sno][0] = this.sizeC[sno] / this.reader.getRGBChannelCount();
        this.lenT[sno][0] = this.sizeT[sno];
        int z = 1;
        int c = 1;
        int t = 1;
        block6: for (int i = 0; i < count.length; ++i) {
            switch (axes[i]) {
                case 1: {
                    ms.sizeZ *= count[i];
                    this.lenZ[sno][z++] = count[i];
                    continue block6;
                }
                case 3: {
                    ms.sizeC *= count[i];
                    this.lenC[sno][c++] = count[i];
                    continue block6;
                }
                case 2: {
                    ms.sizeT *= count[i];
                    this.lenT[sno][t++] = count[i];
                    continue block6;
                }
                case 4: {
                    continue block6;
                }
                default: {
                    throw new FormatException("Unknown axis type for axis #" + i + ": " + axes[i]);
                }
            }
        }
        ms.imageCount = ms.sizeZ * ms.sizeT;
        ms.imageCount *= ms.sizeC / this.reader.getRGBChannelCount();
        ms.moduloC = this.reader.getModuloC();
        ms.moduloZ = this.reader.getModuloZ();
        ms.moduloT = this.reader.getModuloT();
        if (ms.moduloC.length() % ms.sizeC != 0) {
            ms.moduloC.start = 0.0;
            ms.moduloC.step = 1.0;
            ms.moduloC.end = 0.0;
        }
        if (ms.moduloZ.length() % ms.sizeZ != 0) {
            ms.moduloZ.start = 0.0;
            ms.moduloZ.step = 1.0;
            ms.moduloZ.end = 0.0;
        }
        if (ms.moduloT.length() % ms.sizeT != 0) {
            ms.moduloT.start = 0.0;
            ms.moduloT.step = 1.0;
            ms.moduloT.end = 0.0;
        }
    }

    protected int[] computeIndices(int no) throws FormatException, IOException {
        int ino;
        if (this.noStitch) {
            return new int[]{0, no};
        }
        int sno = this.getCoreIndex();
        ExternalSeries s = this.externals[this.getExternalSeries()];
        int[] axes = s.getAxisGuesser().getAxisTypes();
        int[] count = s.getFilePattern().getCount();
        if (axes.length == 0) {
            axes = new int[]{2};
            count = new int[]{s.getFiles().length};
        }
        int[] zct = this.getZCTCoords(no);
        int[] posZ = FormatTools.rasterToPosition((int[])this.lenZ[sno], (int)zct[0]);
        int[] posC = FormatTools.rasterToPosition((int[])this.lenC[sno], (int)zct[1]);
        int[] posT = FormatTools.rasterToPosition((int[])this.lenT[sno], (int)zct[2]);
        int[] tmpZ = new int[posZ.length];
        System.arraycopy(posZ, 0, tmpZ, 0, tmpZ.length);
        int[] tmpC = new int[posC.length];
        System.arraycopy(posC, 0, tmpC, 0, tmpC.length);
        int[] tmpT = new int[posT.length];
        System.arraycopy(posT, 0, tmpT, 0, tmpT.length);
        int[] pos = new int[axes.length];
        int z = 1;
        int c = 1;
        int t = 1;
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i] == 1) {
                pos[i] = posZ[z++];
                continue;
            }
            if (axes[i] == 3) {
                pos[i] = posC[c++];
                continue;
            }
            if (axes[i] == 2) {
                pos[i] = posT[t++];
                continue;
            }
            if (axes[i] == 4) {
                pos[i] = 0;
                continue;
            }
            throw new FormatException("Unknown axis type for axis #" + i + ": " + axes[i]);
        }
        int fno = FormatTools.positionToRaster((int[])count, (int[])pos);
        DimensionSwapper r = this.getReader(sno, fno);
        if (posZ[0] < r.getSizeZ() && posC[0] < r.getSizeC() && posT[0] < r.getSizeT()) {
            if (r.isRGB() && posC[0] * r.getRGBChannelCount() >= this.lenC[sno][0]) {
                posC[0] = posC[0] / this.lenC[sno][0];
            }
            ino = FormatTools.getIndex((IFormatReader)r, (int)posZ[0], (int)posC[0], (int)posT[0]);
        } else {
            ino = Integer.MAX_VALUE;
        }
        return new int[]{fno, ino};
    }

    protected void initReader(int sno, int fno) {
        int external = this.getExternalSeries(sno);
        DimensionSwapper r = this.externals[external].getReader(fno);
        try {
            if (r.getCurrentFile() == null) {
                r.setGroupFiles(false);
            }
            r.setId(this.externals[external].getFiles()[fno]);
            r.setCoreIndex(this.reader.getCoreMetadataList().size() > 1 ? sno : 0);
            String newOrder = ((DimensionSwapper)this.reader).getInputOrder();
            if (!(this.externals[external].getFiles().length <= 1 && r.isOrderCertain() || r.getRGBChannelCount() != 1 && newOrder.indexOf(67) != r.getDimensionOrder().indexOf(67))) {
                r.swapDimensions(newOrder);
            }
            r.setOutputOrder(newOrder);
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("", (Throwable)e);
        }
    }

    class ExternalSeries {
        private DimensionSwapper[] readers;
        private String[] files;
        private FilePattern pattern;
        private byte[] blankThumbBytes;
        private String originalOrder;
        private AxisGuesser ag;
        private int imagesPerFile;

        public ExternalSeries(FilePattern pattern) throws FormatException, IOException {
            this.pattern = pattern;
            this.files = this.pattern.getFiles();
            int nReaders = this.files.length > 1000 ? 1 : this.files.length;
            this.readers = new DimensionSwapper[nReaders];
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i] = FileStitcher.this.classList != null ? new DimensionSwapper((IFormatReader)new ImageReader(FileStitcher.this.classList)) : new DimensionSwapper();
                this.readers[i].setMetadataOptions(FileStitcher.this.getMetadataOptions());
                this.readers[i].setGroupFiles(false);
            }
            this.readers[0].setId(this.files[0]);
            this.ag = new AxisGuesser(this.pattern, this.readers[0].getDimensionOrder(), this.readers[0].getSizeZ(), this.readers[0].getSizeT(), this.readers[0].getSizeC(), this.readers[0].isOrderCertain());
            this.blankThumbBytes = new byte[FormatTools.getPlaneSize((IFormatReader)this.readers[0], (int)this.readers[0].getThumbSizeX(), (int)this.readers[0].getThumbSizeY())];
            this.originalOrder = this.readers[0].getDimensionOrder();
            this.imagesPerFile = this.readers[0].getImageCount();
        }

        public DimensionSwapper getReader(int fno) {
            if (fno < this.readers.length) {
                return this.readers[fno];
            }
            return this.readers[0];
        }

        public DimensionSwapper[] getReaders() {
            return this.readers;
        }

        public FilePattern getFilePattern() {
            return this.pattern;
        }

        public String getOriginalOrder() {
            return this.originalOrder;
        }

        public AxisGuesser getAxisGuesser() {
            return this.ag;
        }

        public byte[] getBlankThumbBytes() {
            return this.blankThumbBytes;
        }

        public String[] getFiles() {
            return this.files;
        }

        public int getImagesPerFile() {
            return this.imagesPerFile;
        }

        public void close() {
            this.close(false);
        }

        public void close(boolean fileOnly) {
            if (this.getReaders() == null) {
                return;
            }
            for (DimensionSwapper r : this.getReaders()) {
                if (r == null) continue;
                try {
                    r.close(fileOnly);
                }
                catch (IOException e) {
                    LOGGER.debug("Close failed", (Throwable)e);
                }
            }
        }
    }
}

