/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdSelectivity
implements MetadataHandler<BuiltInMetadata.Selectivity> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdSelectivity(), BuiltInMetadata.Selectivity.Handler.class);

    protected RelMdSelectivity() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Selectivity> getDef() {
        return BuiltInMetadata.Selectivity.DEF;
    }

    public @Nullable Double getSelectivity(TableScan scan, RelMetadataQuery mq, RexNode predicate) {
        BuiltInMetadata.Selectivity.Handler handler = scan.getTable().unwrap(BuiltInMetadata.Selectivity.Handler.class);
        if (handler != null) {
            return handler.getSelectivity(scan, mq, predicate);
        }
        return this.getSelectivity((RelNode)scan, mq, predicate);
    }

    public @Nullable Double getSelectivity(Union rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        if (rel.getInputs().size() == 0 || predicate == null) {
            return 1.0;
        }
        double sumRows = 0.0;
        double sumSelectedRows = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            Double nRows = mq.getRowCount(input);
            if (nRows == null) {
                return null;
            }
            RexNode modifiedPred = predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments));
            Double sel = mq.getSelectivity(input, modifiedPred);
            if (sel == null) {
                return null;
            }
            sumRows += nRows.doubleValue();
            sumSelectedRows += nRows * sel;
        }
        if (sumRows < 1.0) {
            sumRows = 1.0;
        }
        return sumSelectedRows / sumRows;
    }

    public @Nullable Double getSelectivity(Sort rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        return mq.getSelectivity(rel.getInput(), predicate);
    }

    public @Nullable Double getSelectivity(TableModify rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        return mq.getSelectivity(rel.getInput(), predicate);
    }

    public @Nullable Double getSelectivity(Filter rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.getCondition());
    }

    public @Nullable Double getSelectivity(Calc rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        RexProgram rexProgram;
        RexLocalRef programCondition;
        if (predicate != null) {
            predicate = RelOptUtil.pushPastCalc(predicate, rel);
        }
        if ((programCondition = (rexProgram = rel.getProgram()).getCondition()) == null) {
            return mq.getSelectivity(rel.getInput(), predicate);
        }
        return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds(rel.getCluster().getRexBuilder(), predicate, rexProgram.expandLocalRef(programCondition)));
    }

    public @Nullable Double getSelectivity(Join rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        if (!rel.isSemiJoin()) {
            return this.getSelectivity((RelNode)rel, mq, predicate);
        }
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(mq, rel);
        if (predicate != null) {
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return mq.getSelectivity(rel.getLeft(), newPred);
    }

    public @Nullable Double getSelectivity(Aggregate rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        Double selectivity = mq.getSelectivity(rel.getInput(), childPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public @Nullable Double getSelectivity(Project rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushPastProject(childPred, rel);
        Double selectivity = mq.getSelectivity(rel.getInput(), modifiedPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(RelNode rel, RelMetadataQuery mq, @Nullable RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate);
    }
}

