/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractSaveBeforeAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class LoadAction
extends AbstractSaveBeforeAction {
    public static final String ID = "File.load";

    public LoadAction() {
        this.initActionProperties("File.open");
    }

    public void doIt(DocumentView documentView) {
        JFileChooser fileChooser = documentView.getOpenChooser();
        if (fileChooser.showOpenDialog(documentView.getComponent()) == 0) {
            this.openFile(documentView, fileChooser);
        } else {
            documentView.setEnabled(true);
        }
    }

    protected void openFile(final DocumentView documentView, JFileChooser fileChooser) {
        final File file = fileChooser.getSelectedFile();
        documentView.setEnabled(false);
        documentView.execute(new Worker(){

            public Object construct() {
                try {
                    documentView.read(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                LoadAction.this.fileOpened(documentView, file, value);
            }
        });
    }

    protected void fileOpened(final DocumentView documentView, File file, Object value) {
        if (value == null) {
            documentView.setFile(file);
            documentView.setEnabled(true);
            this.getApplication().addRecentFile(file);
        } else {
            JSheet.showMessageSheet(documentView.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    documentView.execute(new Worker(){

                        public Object construct() {
                            try {
                                documentView.clear();
                                return null;
                            }
                            catch (IOException ex) {
                                return ex;
                            }
                        }

                        public void finished(Object result) {
                            documentView.setEnabled(true);
                        }
                    });
                }
            });
        }
    }
}

