/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.StyledEditorKit;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.action.AlignAction;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.AttributeAction;
import org.jhotdraw.draw.action.AttributeToggler;
import org.jhotdraw.draw.action.ColorIcon;
import org.jhotdraw.draw.action.DefaultAttributeAction;
import org.jhotdraw.draw.action.EditorColorChooserAction;
import org.jhotdraw.draw.action.EditorColorIcon;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.LineDecorationIcon;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SelectionColorChooserAction;
import org.jhotdraw.draw.action.SelectionColorIcon;
import org.jhotdraw.draw.action.StrokeIcon;
import org.jhotdraw.draw.action.ToggleGridAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.draw.action.ZoomEditorAction;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonFactory {
    public static final Map<String, Color> DEFAULT_COLORS;

    private ButtonFactory() {
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new CutAction());
        a.add(new CopyAction());
        a.add(new PasteAction());
        a.add(new SelectAllAction());
        a.add(new SelectSameAction(editor));
        return a;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor));
        a.add(new UngroupAction(editor));
        a.add(null);
        a.add(new MoveToFrontAction(editor));
        a.add(new MoveToBackAction(editor));
        return a;
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor) {
        return ButtonFactory.addSelectionToolTo(tb, editor, ButtonFactory.createDrawingActions(editor), ButtonFactory.createSelectionActions(editor));
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor, Collection<Action> drawingActions, Collection<Action> selectionActions) {
        JToggleButton t;
        ButtonGroup group;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        if (tb.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            group = (ButtonGroup)tb.getClientProperty("toolButtonGroup");
        } else {
            group = new ButtonGroup();
            tb.putClientProperty("toolButtonGroup", group);
        }
        DelegationSelectionTool selectionTool = new DelegationSelectionTool(drawingActions, selectionActions);
        editor.setTool(selectionTool);
        final JToggleButton defaultToolButton = t = new JToggleButton();
        if (tb.getClientProperty("toolHandler") instanceof ToolListener) {
            ToolListener toolHandler = (ToolListener)tb.getClientProperty("toolHandler");
        } else {
            ToolListener toolHandler = new ToolListener(){

                public void toolStarted(ToolEvent event) {
                }

                public void toolDone(ToolEvent event) {
                    defaultToolButton.setSelected(true);
                }

                public void areaInvalidated(ToolEvent e) {
                }
            };
            tb.putClientProperty("toolHandler", toolHandler);
        }
        labels.configureToolBarButton(t, "selectionTool");
        t.setSelected(true);
        t.addItemListener(new ToolButtonListener(selectionTool, editor));
        t.setFocusable(false);
        group.add(t);
        tb.add(t);
        return t;
    }

    public static JToggleButton addToolTo(JToolBar tb, DrawingEditor editor, Tool tool, String labelKey, ResourceBundleUtil labels) {
        ButtonGroup group = (ButtonGroup)tb.getClientProperty("toolButtonGroup");
        ToolListener toolHandler = (ToolListener)tb.getClientProperty("toolHandler");
        JToggleButton t = new JToggleButton();
        labels.configureToolBarButton(t, labelKey);
        t.addItemListener(new ToolButtonListener(tool, editor));
        t.setFocusable(false);
        tool.addToolListener(toolHandler);
        group.add(t);
        tb.add(t);
        return t;
    }

    public static void addZoomButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createZoomButton(editor));
    }

    public static AbstractButton createZoomButton(final DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JPopupButton zoomPopupButton = new JPopupButton();
        labels.configureToolBarButton(zoomPopupButton, "viewZoom");
        zoomPopupButton.setFocusable(false);
        if (editor.getDrawingViews().size() == 0) {
            zoomPopupButton.setText("100 %");
        } else {
            zoomPopupButton.setText((int)(editor.getDrawingViews().iterator().next().getScaleFactor() * 100.0) + " %");
        }
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "activeView") {
                    if (evt.getNewValue() == null) {
                        zoomPopupButton.setText("100 %");
                    } else {
                        zoomPopupButton.setText((int)(editor.getActiveView().getScaleFactor() * 100.0) + " %");
                    }
                }
            }
        });
        double[] factors = new double[]{16.0, 8.0, 5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
        for (int i = 0; i < factors.length; ++i) {
            zoomPopupButton.add(new ZoomEditorAction(editor, factors[i], (AbstractButton)zoomPopupButton){

                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    zoomPopupButton.setText((int)(this.editor.getActiveView().getScaleFactor() * 100.0) + " %");
                }
            });
        }
        zoomPopupButton.setFocusable(false);
        return zoomPopupButton;
    }

    public static AbstractButton createZoomButton(DrawingView view) {
        return ButtonFactory.createZoomButton(view, new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1});
    }

    public static AbstractButton createZoomButton(final DrawingView view, double[] factors) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JPopupButton zoomPopupButton = new JPopupButton();
        labels.configureToolBarButton(zoomPopupButton, "viewZoom");
        zoomPopupButton.setFocusable(false);
        zoomPopupButton.setText((int)(view.getScaleFactor() * 100.0) + " %");
        view.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "scaleFactor") {
                    zoomPopupButton.setText((int)(view.getScaleFactor() * 100.0) + " %");
                }
            }
        });
        for (int i = 0; i < factors.length; ++i) {
            zoomPopupButton.add(new ZoomAction(view, factors[i], zoomPopupButton){

                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    zoomPopupButton.setText((int)(view.getScaleFactor() * 100.0) + " %");
                }
            });
        }
        zoomPopupButton.setFocusable(false);
        return zoomPopupButton;
    }

    public static void addAttributesButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JButton b = bar.add(new PickAttributesAction(editor));
        b.setFocusable(false);
        b = bar.add(new ApplyAttributesAction(editor));
        b.setFocusable(false);
        bar.addSeparator();
        ButtonFactory.addColorButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addStrokeButtonsTo(bar, editor);
        bar.addSeparator();
        ButtonFactory.addFontButtonsTo(bar, editor);
    }

    public static void addColorButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.STROKE_COLOR, DEFAULT_COLORS, 8, "attributeStrokeColor", labels, new HashMap<AttributeKey, Object>()));
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.FILL_COLOR, DEFAULT_COLORS, 8, "attributeFillColor", labels, new HashMap<AttributeKey, Object>()));
        bar.add(ButtonFactory.createEditorColorButton(editor, AttributeKeys.TEXT_COLOR, DEFAULT_COLORS, 8, "attributeTextColor", labels, new HashMap<AttributeKey, Object>()));
    }

    public static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey attributeKey, Map<String, Color> colorMap, int columnCount, String labelKey, ResourceBundleUtil labels) {
        return ButtonFactory.createEditorColorButton(editor, attributeKey, colorMap, columnCount, labelKey, labels, null);
    }

    public static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey attributeKey, Map<String, Color> colorMap, int columnCount, String labelKey, ResourceBundleUtil labels, Map<AttributeKey, Object> defaultAttributes) {
        return ButtonFactory.createEditorColorButton(editor, attributeKey, colorMap, columnCount, labelKey, labels, defaultAttributes, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey attributeKey, Map<String, Color> colorMap, int columnCount, String labelKey, ResourceBundleUtil labels, Map<AttributeKey, Object> defaultAttributes, Shape colorShape) {
        final JPopupButton popupButton = new JPopupButton();
        if (defaultAttributes == null) {
            defaultAttributes = new HashMap<AttributeKey, Object>();
        }
        popupButton.setAction(new DefaultAttributeAction(editor, attributeKey, defaultAttributes), new Rectangle(0, 0, 22, 22));
        popupButton.setColumnCount(columnCount, false);
        for (Map.Entry<String, Color> entry : colorMap.entrySet()) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            attributes.put(attributeKey, entry.getValue());
            AttributeAction a = new AttributeAction(editor, attributes, labels.getString(labelKey), (Icon)new ColorIcon(entry.getValue()));
            popupButton.add(a);
            a.putValue("ShortDescription", entry.getKey());
        }
        ImageIcon chooserIcon = new ImageIcon(ButtonFactory.class.getResource("/org/jhotdraw/draw/action/images/showColorChooser.png"));
        popupButton.add(new EditorColorChooserAction(editor, attributeKey, "color", chooserIcon, defaultAttributes));
        labels.configureToolBarButton(popupButton, labelKey);
        EditorColorIcon icon = new EditorColorIcon(editor, (AttributeKey<Color>)attributeKey, labels.getImageIcon(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                popupButton.repaint();
            }
        });
        return popupButton;
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey attributeKey, Map<String, Color> colorMap, int columnCount, String labelKey, ResourceBundleUtil labels) {
        return ButtonFactory.createSelectionColorButton(editor, attributeKey, colorMap, columnCount, labelKey, labels, null);
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey attributeKey, Map<String, Color> colorMap, int columnCount, String labelKey, ResourceBundleUtil labels, Map<AttributeKey, Object> defaultAttributes) {
        return ButtonFactory.createSelectionColorButton(editor, attributeKey, colorMap, columnCount, labelKey, labels, defaultAttributes, new Rectangle(1, 17, 20, 4));
    }

    public static JPopupButton createSelectionColorButton(DrawingEditor editor, AttributeKey attributeKey, Map<String, Color> colorMap, int columnCount, String labelKey, ResourceBundleUtil labels, Map<AttributeKey, Object> defaultAttributes, Shape colorShape) {
        final JPopupButton popupButton = new JPopupButton();
        if (defaultAttributes == null) {
            defaultAttributes = new HashMap<AttributeKey, Object>();
        }
        popupButton.setColumnCount(columnCount, false);
        for (Map.Entry<String, Color> entry : colorMap.entrySet()) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            attributes.put(attributeKey, entry.getValue());
            AttributeAction a = new AttributeAction(editor, attributes, labels.getString(labelKey), (Icon)new ColorIcon(entry.getValue()));
            popupButton.add(a);
            a.putValue("ShortDescription", entry.getKey());
        }
        ImageIcon chooserIcon = new ImageIcon(ButtonFactory.class.getResource("/org/jhotdraw/draw/action/images/showColorChooser.png"));
        popupButton.add(new SelectionColorChooserAction(editor, attributeKey, "color", chooserIcon, defaultAttributes));
        labels.configureToolBarButton(popupButton, labelKey);
        SelectionColorIcon icon = new SelectionColorIcon(editor, (AttributeKey<Color>)attributeKey, labels.getImageIcon(labelKey, ButtonFactory.class).getImage(), colorShape);
        popupButton.setIcon(icon);
        popupButton.setDisabledIcon(icon);
        popupButton.setFocusable(false);
        final FigureSelectionListener selectionHandler = new FigureSelectionListener(){

            public void selectionChanged(FigureSelectionEvent evt) {
                popupButton.repaint();
            }
        };
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "activeView") {
                    if (evt.getOldValue() != null) {
                        ((DrawingView)evt.getOldValue()).removeFigureSelectionListener(selectionHandler);
                    }
                    if (evt.getNewValue() != null) {
                        ((DrawingView)evt.getNewValue()).addFigureSelectionListener(selectionHandler);
                    }
                    popupButton.repaint();
                } else {
                    popupButton.repaint();
                }
            }
        });
        return popupButton;
    }

    public static void addStrokeButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createStrokeDecorationButton(editor));
        bar.add(ButtonFactory.createStrokeWidthButton(editor));
        bar.add(ButtonFactory.createStrokeDashesButton(editor));
        bar.add(ButtonFactory.createStrokeTypeButton(editor));
        bar.add(ButtonFactory.createStrokePlacementButton(editor));
        bar.add(ButtonFactory.createStrokeCapButton(editor));
        bar.add(ButtonFactory.createStrokeJoinButton(editor));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeWidthButton(editor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeWidthButton(editor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, labels);
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor, double[] widths) {
        return ButtonFactory.createStrokeWidthButton(editor, new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0}, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeWidthButton(DrawingEditor editor, double[] widths, ResourceBundleUtil labels) {
        JPopupButton strokeWidthPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeWidthPopupButton, "attributeStrokeWidth");
        strokeWidthPopupButton.setFocusable(false);
        NumberFormat formatter = NumberFormat.getInstance();
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).setMaximumFractionDigits(1);
            ((DecimalFormat)formatter).setMinimumFractionDigits(0);
        }
        for (int i = 0; i < widths.length; ++i) {
            String label = Double.toString(widths[i]);
            StrokeIcon icon = new StrokeIcon(new BasicStroke((float)widths[i], 0, 2));
            AttributeAction a = new AttributeAction(editor, AttributeKeys.STROKE_WIDTH, new Double(widths[i]), label, icon);
            a.putValue("undoPresentationName", labels.getString("attributeStrokeWidth"));
            AbstractButton btn = strokeWidthPopupButton.add(a);
            btn.setDisabledIcon(icon);
        }
        return strokeWidthPopupButton;
    }

    public static JPopupButton createStrokeDecorationButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton strokeDecorationPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeDecorationPopupButton, "attributeStrokeDecoration");
        strokeDecorationPopupButton.setFocusable(false);
        strokeDecorationPopupButton.setColumnCount(2, false);
        LineDecoration[] decorations = new LineDecoration[]{new ArrowTip(0.35, 12.0, 11.3), new ArrowTip(0.35, 13.0, 7.0), new ArrowTip(0.6283185307179586, 12.0, 9.8, true, true, false), new ArrowTip(0.5235987755982988, 12.0, 0.0, false, true, false), new ArrowTip(0.28559933214452665, 13.0, 0.0, false, true, true), new ArrowTip(0.5235987755982988, 10.0, 18.0, false, true, false), new ArrowTip(0.5235987755982988, 10.0, 18.0, true, true, true), null};
        for (int i = 0; i < decorations.length; ++i) {
            strokeDecorationPopupButton.add(new AttributeAction(editor, AttributeKeys.START_DECORATION, decorations[i], null, new LineDecorationIcon(decorations[i], true)));
            strokeDecorationPopupButton.add(new AttributeAction(editor, AttributeKeys.END_DECORATION, decorations[i], null, new LineDecorationIcon(decorations[i], false)));
        }
        return strokeDecorationPopupButton;
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeDashesButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, ResourceBundleUtil labels) {
        return ButtonFactory.createStrokeDashesButton(editor, new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}}, labels);
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, double[][] dashes) {
        return ButtonFactory.createStrokeDashesButton(editor, dashes, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeDashesButton(DrawingEditor editor, double[][] dashes, ResourceBundleUtil labels) {
        JPopupButton strokeDashesPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeDashesPopupButton, "attributeStrokeDashes");
        strokeDashesPopupButton.setFocusable(false);
        for (int i = 0; i < dashes.length; ++i) {
            float[] fdashes;
            if (dashes[i] == null) {
                fdashes = null;
            } else {
                fdashes = new float[dashes[i].length];
                for (int j = 0; j < dashes[i].length; ++j) {
                    fdashes[j] = (float)dashes[i][j];
                }
            }
            StrokeIcon icon = new StrokeIcon(new BasicStroke(2.0f, 0, 2, 10.0f, fdashes, 0.0f));
            AbstractButton btn = strokeDashesPopupButton.add(new AttributeAction(editor, AttributeKeys.STROKE_DASHES, dashes[i], null, icon));
            btn.setDisabledIcon(icon);
        }
        return strokeDashesPopupButton;
    }

    public static JPopupButton createStrokeTypeButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton strokeTypePopupButton = new JPopupButton();
        labels.configureToolBarButton(strokeTypePopupButton, "attributeStrokeType");
        strokeTypePopupButton.setFocusable(false);
        strokeTypePopupButton.add(new AttributeAction(editor, AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.BASIC, labels.getString("attributeStrokeTypeBasic"), new StrokeIcon(new BasicStroke(1.0f, 0, 2))));
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        attr.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 2.0);
        strokeTypePopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeTypeDouble"), (Icon)new StrokeIcon(new DoubleStroke(2.0f, 1.0f))));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        attr.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 3.0);
        strokeTypePopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeTypeDouble"), (Icon)new StrokeIcon(new DoubleStroke(3.0f, 1.0f))));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        attr.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 4.0);
        strokeTypePopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeTypeDouble"), (Icon)new StrokeIcon(new DoubleStroke(4.0f, 1.0f))));
        return strokeTypePopupButton;
    }

    public static JPopupButton createStrokePlacementButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton strokePlacementPopupButton = new JPopupButton();
        labels.configureToolBarButton(strokePlacementPopupButton, "attributeStrokePlacement");
        strokePlacementPopupButton.setFocusable(false);
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementCenter"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementInside"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementOutside"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementCenterFilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementInsideFilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementOutsideFilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementCenterUnfilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementInsideUnfilled"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        attr.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokePlacementOutsideUnfilled"), null));
        return strokePlacementPopupButton;
    }

    public static void addFontButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add(ButtonFactory.createFontButton(editor));
        bar.add(ButtonFactory.createFontStyleBoldButton(editor));
        bar.add(ButtonFactory.createFontStyleItalicButton(editor));
        bar.add(ButtonFactory.createFontStyleUnderlineButton(editor));
    }

    public static JPopupButton createFontButton(DrawingEditor editor) {
        return ButtonFactory.createFontButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createFontButton(DrawingEditor editor, ResourceBundleUtil labels) {
        JPopupButton fontPopupButton = new JPopupButton();
        labels.configureToolBarButton(fontPopupButton, "attributeFont");
        fontPopupButton.setFocusable(false);
        Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        HashSet<String> fontExclusionList = new HashSet<String>(Arrays.asList("#GungSeo", "#HeadLineA", "#PCMyungjo", "#PilGi", "Al Bayan", "Apple LiGothic", "Apple LiSung", "AppleMyungjo", "Arial Hebrew", "Ayuthaya", "Baghdad", "BiauKai", "Charcoal CY", "Corsiva Hebrew", "DecoType Naskh", "Devanagari MT", "Fang Song", "GB18030 Bitmap", "Geeza Pro", "Geezah", "Geneva CY", "Gujarati MT", "Gurmukhi MT", "Hei", "Helvetica CY", "Hiragino Kaku Gothic Std", "Hiragino Maru Gothic Pro", "Hiragino Mincho Pro", "Hiragino Kaku Gothic Pro", "InaiMathi", "Kai", "Krungthep", "KufiStandardGK", "LiHei Pro", "LiSong Pro", "Mshtakan", "Monaco CY", "Nadeem", "New Peninim MT", "Osaka", "Plantagenet Cherokee", "Raanana", "STFangsong", "STHeiti", "STKaiti", "STSong", "Sathu", "Silom", "Thonburi", "Times CY", "Arial Unicode MS", "Batang", "Estrangelo Edessa", "Gautami", "Kartika", "Latha", "Lucida Sans Unicode", "Mangal", "Marlett", "MS Mincho", "MS Outlook", "MV Boli", "OCR-B-10 BT", "Raavi", "Shruti", "SimSun", "Sylfaen", "Symbol", "Tunga", "Vrinda", "Wingdings", "Wingdings 2", "Wingdings 3", "ZWAdobeF"));
        LinkedList<Font> fontList = new LinkedList<Font>();
        for (int i = 0; i < allFonts.length; ++i) {
            if (fontExclusionList.contains(allFonts[i].getFamily())) continue;
            fontList.add(allFonts[i]);
        }
        allFonts = new Font[fontList.size()];
        allFonts = fontList.toArray(allFonts);
        Arrays.sort(allFonts, new Comparator<Font>(){

            @Override
            public int compare(Font f1, Font f2) {
                int result = f1.getFamily().compareTo(f2.getFamily());
                if (result == 0) {
                    result = f1.getFontName().compareTo(f2.getFontName());
                }
                return result;
            }
        });
        LinkedList<Font> fontFamilies = new LinkedList<Font>();
        JMenu submenu = null;
        for (int i = 0; i < allFonts.length; ++i) {
            if (submenu != null && !allFonts[i].getFamily().equals(allFonts[i - 1].getFamily())) {
                submenu = null;
            }
            if (submenu == null && i < allFonts.length - 2 && allFonts[i].getFamily().equals(allFonts[i + 1].getFamily())) {
                fontFamilies.add(allFonts[i]);
                submenu = new JMenu(allFonts[i].getFamily());
                fontPopupButton.add(submenu);
            }
            AttributeAction action = new AttributeAction(editor, AttributeKeys.FONT_FACE, allFonts[i], submenu == null ? allFonts[i].getFamily() : allFonts[i].getFontName(), null, new StyledEditorKit.FontFamilyAction(allFonts[i].getFontName(), allFonts[i].getFamily()));
            if (submenu == null) {
                fontFamilies.add(allFonts[i]);
                fontPopupButton.add(action);
                continue;
            }
            JMenuItem item = submenu.add(action);
        }
        fontPopupButton.setColumnCount(Math.max(1, fontFamilies.size() / 32), true);
        fontPopupButton.setFocusable(false);
        return fontPopupButton;
    }

    public static JButton createFontStyleBoldButton(DrawingEditor editor) {
        return ButtonFactory.createFontStyleBoldButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleBoldButton(DrawingEditor editor, ResourceBundleUtil labels) {
        JButton btn = new JButton();
        labels.configureToolBarButton(btn, "attributeFontBold");
        btn.setFocusable(false);
        AttributeToggler a = new AttributeToggler(editor, AttributeKeys.FONT_BOLD, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        a.putValue("undoPresentationName", labels.getString("attributeFontBold"));
        btn.addActionListener(a);
        return btn;
    }

    public static JButton createFontStyleItalicButton(DrawingEditor editor) {
        return ButtonFactory.createFontStyleItalicButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleItalicButton(DrawingEditor editor, ResourceBundleUtil labels) {
        JButton btn = new JButton();
        labels.configureToolBarButton(btn, "attributeFontItalic");
        btn.setFocusable(false);
        AttributeToggler a = new AttributeToggler(editor, AttributeKeys.FONT_ITALIC, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        a.putValue("undoPresentationName", labels.getString("attributeFontItalic"));
        btn.addActionListener(a);
        return btn;
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor editor) {
        return ButtonFactory.createFontStyleUnderlineButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JButton createFontStyleUnderlineButton(DrawingEditor editor, ResourceBundleUtil labels) {
        JButton btn = new JButton();
        labels.configureToolBarButton(btn, "attributeFontUnderline");
        btn.setFocusable(false);
        AttributeToggler a = new AttributeToggler(editor, AttributeKeys.FONT_UNDERLINE, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction());
        a.putValue("undoPresentationName", labels.getString("attributeFontUnderline"));
        btn.addActionListener(a);
        return btn;
    }

    public static void addAlignmentButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        bar.add(new AlignAction.West(editor)).setFocusable(false);
        bar.add(new AlignAction.East(editor)).setFocusable(false);
        bar.add(new AlignAction.Horizontal(editor)).setFocusable(false);
        bar.add(new AlignAction.North(editor)).setFocusable(false);
        bar.add(new AlignAction.South(editor)).setFocusable(false);
        bar.add(new AlignAction.Vertical(editor)).setFocusable(false);
        bar.addSeparator();
        bar.add(new MoveAction.West(editor)).setFocusable(false);
        bar.add(new MoveAction.East(editor)).setFocusable(false);
        bar.add(new MoveAction.North(editor)).setFocusable(false);
        bar.add(new MoveAction.South(editor)).setFocusable(false);
        bar.addSeparator();
        bar.add(new MoveToFrontAction(editor)).setFocusable(false);
        bar.add(new MoveToBackAction(editor)).setFocusable(false);
    }

    public static AbstractButton createToggleGridButton(DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JToggleButton toggleGridButton = new JToggleButton();
        toggleGridButton.setAction(new ToggleGridAction(editor));
        toggleGridButton.setFocusable(false);
        return toggleGridButton;
    }

    public static AbstractButton createToggleGridButton(final DrawingView view) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JToggleButton toggleButton = new JToggleButton();
        labels.configureToolBarButton(toggleButton, "alignGrid");
        toggleButton.setFocusable(false);
        toggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                GridConstrainer c = toggleButton.isSelected() ? new GridConstrainer(10.0, 10.0) : new GridConstrainer(1.0, 1.0);
                view.setConstrainer(c);
                view.getComponent().repaint();
            }
        });
        view.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "gridConstrainer") {
                    Constrainer c = (Constrainer)evt.getNewValue();
                    toggleButton.setSelected(c.isVisible());
                }
            }
        });
        return toggleButton;
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeCapButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeCapButton(DrawingEditor editor, ResourceBundleUtil labels) {
        JPopupButton popupButton = new JPopupButton();
        labels.configureToolBarButton(popupButton, "attributeStrokeCap");
        popupButton.setFocusable(false);
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_CAP, 0);
        popupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeCapButt"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_CAP, 1);
        popupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeCapRound"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_CAP, 2);
        popupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeCapSquare"), null));
        return popupButton;
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor editor) {
        return ButtonFactory.createStrokeJoinButton(editor, ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels"));
    }

    public static JPopupButton createStrokeJoinButton(DrawingEditor editor, ResourceBundleUtil labels) {
        JPopupButton popupButton = new JPopupButton();
        labels.configureToolBarButton(popupButton, "attributeStrokeJoin");
        popupButton.setFocusable(false);
        HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>();
        attr.put(AttributeKeys.STROKE_JOIN, 2);
        popupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeJoinBevel"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_JOIN, 1);
        popupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeJoinRound"), null));
        attr = new HashMap();
        attr.put(AttributeKeys.STROKE_JOIN, 0);
        popupButton.add(new AttributeAction(editor, attr, labels.getString("attributeStrokeJoinMiter"), null));
        return popupButton;
    }

    public static JButton createPickAttributesButton(DrawingEditor editor) {
        JButton btn = new JButton(new PickAttributesAction(editor));
        if (btn.getIcon() != null) {
            btn.putClientProperty("hideActionText", Boolean.TRUE);
        }
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(3);
        btn.setText(null);
        btn.setFocusable(false);
        return btn;
    }

    public static JButton createApplyAttributesButton(DrawingEditor editor) {
        JButton btn = new JButton(new ApplyAttributesAction(editor));
        if (btn.getIcon() != null) {
            btn.putClientProperty("hideActionText", Boolean.TRUE);
        }
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(3);
        btn.setText(null);
        btn.setFocusable(false);
        return btn;
    }

    static {
        LinkedHashMap<String, Color> m = new LinkedHashMap<String, Color>();
        m.put("Cayenne", new Color(128, 0, 0));
        m.put("Asparagus", new Color(128, 128, 0));
        m.put("Clover", new Color(0, 128, 0));
        m.put("Teal", new Color(0, 128, 128));
        m.put("Midnight", new Color(0, 0, 128));
        m.put("Plum", new Color(128, 0, 128));
        m.put("Tin", new Color(127, 127, 127));
        m.put("Nickel", new Color(128, 128, 128));
        m.put("Maraschino", new Color(255, 0, 0));
        m.put("Lemon", new Color(255, 255, 0));
        m.put("Spring", new Color(0, 255, 0));
        m.put("Turquoise", new Color(0, 255, 255));
        m.put("Blueberry", new Color(0, 0, 255));
        m.put("Magenta", new Color(255, 0, 255));
        m.put("Steel", new Color(102, 102, 102));
        m.put("Aluminium", new Color(153, 153, 153));
        m.put("Salmon", new Color(255, 102, 102));
        m.put("Banana", new Color(255, 255, 102));
        m.put("Flora", new Color(102, 255, 102));
        m.put("Ice", new Color(102, 255, 255));
        m.put("Orchid", new Color(102, 102, 255));
        m.put("Bubblegum", new Color(255, 102, 255));
        m.put("Iron", new Color(76, 76, 76));
        m.put("Magnesium", new Color(179, 179, 179));
        m.put("Mocha", new Color(128, 64, 0));
        m.put("Fern", new Color(64, 128, 0));
        m.put("Moss", new Color(0, 128, 64));
        m.put("Ocean", new Color(0, 64, 128));
        m.put("Eggplant", new Color(64, 0, 128));
        m.put("Maroon", new Color(128, 0, 64));
        m.put("Tungsten", new Color(51, 51, 51));
        m.put("Silver", new Color(204, 204, 204));
        m.put("Tangerine", new Color(255, 128, 0));
        m.put("Lime", new Color(128, 255, 0));
        m.put("Sea Foam", new Color(0, 255, 128));
        m.put("Aqua", new Color(0, 128, 255));
        m.put("Grape", new Color(128, 0, 255));
        m.put("Strawberry", new Color(255, 0, 128));
        m.put("Lead", new Color(25, 25, 25));
        m.put("Mercury", new Color(230, 230, 230));
        m.put("Cantaloupe", new Color(255, 204, 102));
        m.put("Honeydew", new Color(204, 255, 102));
        m.put("Spindrift", new Color(102, 255, 204));
        m.put("Sky", new Color(102, 204, 255));
        m.put("Lavender", new Color(204, 102, 255));
        m.put("Carnation", new Color(255, 111, 207));
        m.put("Licorice", new Color(0, 0, 0));
        m.put("Snow", new Color(255, 255, 255));
        m.put("Transparent", null);
        DEFAULT_COLORS = Collections.unmodifiableMap(m);
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                this.editor.setTool(this.tool);
            }
        }
    }
}

