/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveToFrontAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    public static String ID = "moveToFront";

    public MoveToFrontAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        final LinkedList<Figure> figures = new LinkedList<Figure>(view.getSelectedFigures());
        MoveToFrontAction.bringToFront(view, figures);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return MoveToFrontAction.this.labels.getString(ID);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                MoveToFrontAction.bringToFront(view, figures);
            }

            public void undo() throws CannotUndoException {
                super.undo();
                MoveToBackAction.sendToBack(view, figures);
            }
        });
    }

    public static void bringToFront(DrawingView view, Collection<Figure> figures) {
        Drawing drawing = view.getDrawing();
        for (Figure figure : drawing.sort(figures)) {
            drawing.bringToFront(figure);
        }
    }
}

