/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SVGAttributedFigure
extends AbstractAttributedFigure {
    @Override
    public void draw(Graphics2D g) {
        double opacity = SVGAttributeKeys.OPACITY.get(this);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage((int)((2.0 + drawingArea.width) * g.getTransform().getScaleX()), (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY()), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    this.drawFigure(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                this.drawFigure(g);
            }
        }
    }

    public void drawFigure(Graphics2D g) {
        Paint paint;
        AffineTransform savedTransform = null;
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            savedTransform = g.getTransform();
            g.transform(AttributeKeys.TRANSFORM.get(this));
        }
        if ((paint = SVGAttributeKeys.getFillPaint(this)) != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if ((paint = SVGAttributeKeys.getStrokePaint(this)) != null && AttributeKeys.STROKE_WIDTH.get(this) > 0.0) {
            g.setPaint(paint);
            g.setStroke(SVGAttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            g.setTransform(savedTransform);
        }
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        if (key == AttributeKeys.TRANSFORM) {
            this.invalidate();
        }
        super.setAttribute(key, newValue);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        LinkedList<Action> actions = new LinkedList<Action>();
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
            actions.add(new AbstractAction(labels.getString("removeTransform")){

                public void actionPerformed(ActionEvent evt) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
                    SVGAttributedFigure.this.willChange();
                    SVGAttributedFigure.this.fireUndoableEditHappened(AttributeKeys.TRANSFORM.setUndoable(SVGAttributedFigure.this, null, labels));
                    SVGAttributedFigure.this.changed();
                }
            });
        }
        return actions;
    }

    @Override
    public final void write(DOMOutput out) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput in) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableInput to read this Figure.");
    }
}

