/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import loci.common.Location;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.JPEGXRCodec;
import loci.formats.codec.PassthroughCodec;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.primitives.Color;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;

public class TissueFAXSReader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TissueFAXSReader.class);
    private static final int WAVE_MIN = 300;
    private static final int WAVE_MAX = 800;
    private List<String> pixelsFiles = new ArrayList<String>();
    private List<ScanRegion> regions = new ArrayList<ScanRegion>();

    public TissueFAXSReader() {
        super("TissueFAXS", new String[]{"aqproj", "tfcyto"});
        this.hasCompanionFiles = false;
        this.domains = new String[]{"Histology"};
        this.datasetDescription = "An .aqproj file with one or more .tfcyto database files";
        this.suffixSufficient = true;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsFiles.clear();
            this.regions.clear();
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            ScanRegion region = this.getRegion();
            return region.tileSizeX / (int)Math.pow(region.scaleFactor, this.getLevel());
        }
        catch (FormatException e) {
            LOGGER.warn("Could not get optimal tile width", (Throwable)e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            ScanRegion region = this.getRegion();
            return region.tileSizeY / (int)Math.pow(region.scaleFactor, this.getLevel());
        }
        catch (FormatException e) {
            LOGGER.warn("Could not get optimal tile height", (Throwable)e);
            return super.getOptimalTileHeight();
        }
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(new Location(this.getCurrentFile()).getAbsolutePath());
        if (!noPixels) {
            try {
                String regionFile = this.getRegion().file;
                if (!files.contains(regionFile)) {
                    files.add(regionFile);
                }
            }
            catch (FormatException e) {
                LOGGER.warn("Could not get file", (Throwable)e);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        Arrays.fill(buf, this.getFillColor());
        int[] zct = this.getZCTCoords(no);
        List<ScanRegion> planeRegions = this.getAllRegions(zct[2]);
        int level = this.getLevel();
        Region dest = new Region(x, y, w, h);
        for (ScanRegion region : planeRegions) {
            if (this.isCorrectionImage(region)) {
                this.copyCorrectionImageToBuffer(region, dest, zct, buf);
                continue;
            }
            this.copyRegionToBuffer(region, level, dest, zct, buf);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.findDBFiles();
        this.core.clear();
        for (int i = 0; i < this.pixelsFiles.size(); ++i) {
            String file = this.pixelsFiles.get(i);
            CoreMetadata m = new CoreMetadata();
            m.pixelType = 1;
            int startRegionIndex = this.regions.size();
            Connection conn = this.openConnection(file);
            try {
                PreparedStatement regionQuery = conn.prepareStatement("SELECT id, data, is_timelapse FROM region ORDER BY id");
                ResultSet regionData = regionQuery.executeQuery();
                while (regionData.next()) {
                    int regionID = regionData.getInt(1);
                    String json = regionData.getString(2);
                    boolean isTimelapse = regionData.getBoolean(3);
                    LOGGER.trace("{}", (Object)json);
                    ScanRegion region = new ScanRegion();
                    region.id = regionID;
                    region.file = file;
                    try {
                        json = json.trim();
                        json = json.replaceAll("\r\n", "_");
                        region.regionMetadata = new JSONObject(json);
                    }
                    catch (JSONException je) {
                        throw new FormatException("Could not read metadata for region in " + file, (Throwable)je);
                    }
                    region.parseJSON();
                    if (isTimelapse) {
                        region.timepoint = this.regions.size() - startRegionIndex;
                    } else if (this.regions.size() != startRegionIndex) {
                        region.resolutions.add(0);
                    }
                    this.regions.add(region);
                }
                int timepoints = this.regions.size() - startRegionIndex;
                for (int regionIndex = startRegionIndex; regionIndex < this.regions.size(); ++regionIndex) {
                    ScanRegion currentRegion = this.regions.get(regionIndex);
                    PreparedStatement fovQuery = conn.prepareStatement("SELECT row, column, stitch_rectangle_x, stitch_rectangle_y, stitch_rectangle_w, stitch_rectangle_h FROM fovs WHERE region_id=?");
                    fovQuery.setInt(1, this.regions.get((int)regionIndex).id);
                    ResultSet fovs = fovQuery.executeQuery();
                    while (fovs.next()) {
                        int row = fovs.getInt(1);
                        int col = fovs.getInt(2);
                        double x = fovs.getDouble(3);
                        double y = fovs.getDouble(4);
                        double w = fovs.getDouble(5);
                        double h = fovs.getDouble(6);
                        currentRegion.tileRangeY[0] = Math.min(currentRegion.tileRangeY[0], row);
                        currentRegion.tileRangeY[1] = Math.max(currentRegion.tileRangeY[1], row);
                        currentRegion.tileRangeX[0] = Math.min(currentRegion.tileRangeX[0], col);
                        currentRegion.tileRangeX[1] = Math.max(currentRegion.tileRangeX[1], col);
                        Region fov = new Region((int)x, (int)y, (int)w, (int)h);
                        currentRegion.fovs.put(row + "-" + col, fov);
                    }
                    PreparedStatement zQuery = conn.prepareStatement("SELECT DISTINCT is_zstack,z_position FROM images WHERE region=? ORDER BY is_zstack,z_position");
                    zQuery.setInt(1, currentRegion.id);
                    ResultSet zs = zQuery.executeQuery();
                    ArrayList<Integer> tmpZ = new ArrayList<Integer>();
                    while (zs.next()) {
                        boolean isZ = zs.getBoolean(1);
                        int zPos = zs.getInt(2);
                        tmpZ.add(zPos);
                    }
                    currentRegion.zSteps = tmpZ.toArray(new Integer[tmpZ.size()]);
                    currentRegion.fullResolutionCoreIndex = this.core.size();
                    if (currentRegion.resolutions.size() > 0) continue;
                    int xTiles = currentRegion.tileRangeX[1] - currentRegion.tileRangeX[0] + 1;
                    int yTiles = currentRegion.tileRangeY[1] - currentRegion.tileRangeY[0] + 1;
                    m.sizeX = xTiles * (currentRegion.tileSizeX - currentRegion.overlapX);
                    m.sizeY = yTiles * (currentRegion.tileSizeY - currentRegion.overlapY);
                    PreparedStatement maxLevelQuery = conn.prepareStatement("SELECT level FROM images WHERE region=? ORDER BY level DESC");
                    maxLevelQuery.setInt(1, currentRegion.id);
                    ResultSet maxLevel = maxLevelQuery.executeQuery();
                    int max = 0;
                    int min = Integer.MAX_VALUE;
                    while (maxLevel.next()) {
                        int level = maxLevel.getInt(1);
                        if (max == 0) {
                            max = level;
                        }
                        if (level >= m.resolutionCount) {
                            m.resolutionCount = level + 1;
                        }
                        min = level;
                    }
                    for (int r = min; r <= max; ++r) {
                        currentRegion.resolutions.add(r);
                    }
                    try {
                        int correctionID;
                        PreparedStatement correctionQuery = conn.prepareStatement("SELECT correction_images.id, channel_zstack.channel_id, channel_zstack.position FROM correction_images JOIN channel_zstack ON correction_images.id = channel_zstack.cor_img_id WHERE channel_zstack.region_id=?");
                        correctionQuery.setInt(1, currentRegion.id);
                        ResultSet correctionImgs = correctionQuery.executeQuery();
                        while (correctionImgs.next()) {
                            correctionID = correctionImgs.getInt(1);
                            int channel = correctionImgs.getInt(2);
                            int z = correctionImgs.getInt(3);
                            currentRegion.correctionImageCoreIndex = currentRegion.fullResolutionCoreIndex + m.resolutionCount;
                            currentRegion.correctionImageIDs.put(channel - 1 + "-" + (z - 1), correctionID);
                        }
                        correctionQuery = conn.prepareStatement("SELECT correction_images.id, channels.id FROM correction_images JOIN channels ON correction_images.id = channels.cor_img_id WHERE channels.region_id=?");
                        correctionQuery.setInt(1, currentRegion.id);
                        correctionImgs = correctionQuery.executeQuery();
                        while (correctionImgs.next()) {
                            correctionID = correctionImgs.getInt(1);
                            int channelID = correctionImgs.getInt(2);
                            currentRegion.correctionImageCoreIndex = currentRegion.fullResolutionCoreIndex + m.resolutionCount;
                            currentRegion.correctionImageIDs.put(channelID - 1 + "-0", correctionID);
                        }
                        continue;
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Failed to find correction image", (Throwable)e);
                    }
                }
                PreparedStatement channelQuery = conn.prepareStatement("SELECT DISTINCT id, name, color, save_16bit, excitation_wavelength, emission_wavelength FROM channels ORDER BY id");
                ResultSet channels = channelQuery.executeQuery();
                while (channels.next()) {
                    ++m.sizeC;
                    Channel ch = new Channel();
                    ch.id = channels.getInt(1);
                    ch.name = channels.getString(2);
                    ch.color = channels.getInt(3);
                    boolean save16 = channels.getBoolean(4);
                    if (save16) {
                        m.pixelType = 3;
                    }
                    ch.exWave = channels.getInt(5);
                    ch.emWave = channels.getInt(6);
                    this.regions.get((int)startRegionIndex).channels.add(ch);
                }
            }
            catch (SQLException e) {
                LOGGER.warn("Failed to initialize", (Throwable)e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.warn("Failed to close connection", (Throwable)e);
                }
            }
            m.sizeZ = this.regions.get((int)startRegionIndex).zSteps.length;
            for (int r = startRegionIndex; r < this.regions.size(); ++r) {
                m.sizeT = Math.max(m.sizeT, this.regions.get((int)r).timepoint + 1);
            }
            m.imageCount = m.sizeZ * m.sizeC * m.sizeT;
            if (m.sizeC == 1 && m.pixelType == 1) {
                m.sizeC = 3;
                m.rgb = true;
                m.interleaved = true;
            }
            m.dimensionOrder = "XYCZT";
            m.littleEndian = true;
            this.core.add(m);
            ScanRegion start = this.regions.get(startRegionIndex);
            for (int r = 1; r < m.resolutionCount; ++r) {
                CoreMetadata res = new CoreMetadata(m);
                int scale = (int)Math.pow(start.scaleFactor, r);
                res.sizeX /= scale;
                res.sizeY /= scale;
                res.resolutionCount = 1;
                this.core.add(res);
            }
            if (start.correctionImageCoreIndex == null) continue;
            CoreMetadata correction = new CoreMetadata(m);
            correction.sizeX = start.tileSizeX;
            correction.sizeY = start.tileSizeY;
            correction.pixelType = 6;
            correction.resolutionCount = 1;
            correction.littleEndian = true;
            this.core.add(correction);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrument, 0);
        ArrayList<Integer> populatedCoreIndexes = new ArrayList<Integer>();
        int nextImage = 0;
        int i = 0;
        int index = 0;
        while (i < this.regions.size()) {
            ScanRegion region = this.regions.get(i);
            if (populatedCoreIndexes.contains(region.fullResolutionCoreIndex)) {
                ++i;
                --index;
            } else {
                populatedCoreIndexes.add(region.fullResolutionCoreIndex);
                int imageIndex = this.hasFlattenedResolutions() ? region.fullResolutionCoreIndex : nextImage;
                ++nextImage;
                String objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, index});
                store.setObjectiveID(objectiveID, 0, index);
                Double lensNA = region.regionMetadata.getDouble("ObjectiveLensNA");
                store.setObjectiveLensNA(lensNA, 0, index);
                String immersion = region.regionMetadata.getString("ObjectiveImmersion");
                store.setObjectiveImmersion(this.getImmersion(immersion), 0, index);
                Double magnification = region.regionMetadata.getDouble("ObjectiveNominalMagnification");
                store.setObjectiveNominalMagnification(magnification, 0, index);
                String objectiveName = region.regionMetadata.getString("ObjectiveName");
                store.setObjectiveModel(objectiveName, 0, index);
                store.setImageName(region.regionMetadata.getString("Name"), imageIndex);
                store.setObjectiveSettingsID(objectiveID, imageIndex);
                Double physicalX = region.regionMetadata.getDouble("PhysicalSizeX");
                Double physicalY = region.regionMetadata.getDouble("PhysicalSizeY");
                store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX((Double)physicalX), imageIndex);
                store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY((Double)physicalY), imageIndex);
                String acquisitionMode = region.regionMetadata.getString("AcquisitionMode");
                AcquisitionMode mode = this.getAcquisitionMode(acquisitionMode);
                for (int c = 0; c < region.channels.size(); ++c) {
                    Channel ch = region.channels.get(c);
                    store.setChannelName(ch.name, imageIndex, c);
                    if (mode != null) {
                        store.setChannelAcquisitionMode(mode, imageIndex, c);
                    }
                    if (ch.emWave >= 300 && ch.emWave <= 800) {
                        store.setChannelEmissionWavelength(FormatTools.getWavelength((Double)Double.valueOf(ch.emWave)), imageIndex, c);
                    }
                    if (ch.exWave >= 300 && ch.exWave <= 800) {
                        store.setChannelExcitationWavelength(FormatTools.getWavelength((Double)Double.valueOf(ch.exWave)), imageIndex, c);
                    }
                    if (((CoreMetadata)this.core.get((int)region.fullResolutionCoreIndex)).rgb) continue;
                    store.setChannelColor(ch.getColor(), imageIndex, c);
                }
                if (region.correctionImageCoreIndex != null) {
                    int corrImage = this.hasFlattenedResolutions() ? region.correctionImageCoreIndex : nextImage;
                    ++nextImage;
                    store.setImageName(region.regionMetadata.getString("Name") + " Correction Image", corrImage);
                    store.setObjectiveSettingsID(objectiveID, corrImage);
                }
                i += ((CoreMetadata)this.core.get((int)region.fullResolutionCoreIndex)).sizeT;
            }
            ++index;
        }
    }

    private void findDBFiles() {
        if (TissueFAXSReader.checkSuffix((String)this.getCurrentFile(), (String)"tfcyto")) {
            this.pixelsFiles.add(new Location(this.getCurrentFile()).getAbsolutePath());
            return;
        }
        Location dir = new Location(this.getCurrentFile()).getAbsoluteFile().getParentFile();
        Object[] list = dir.list(true);
        Arrays.sort(list);
        for (Object f : list) {
            Location slide = new Location(dir, (String)f);
            if (!((String)f).startsWith("Slide ") || !slide.isDirectory()) continue;
            Object[] dbFiles = slide.list(true);
            Arrays.sort(dbFiles);
            for (Object db : dbFiles) {
                if (!TissueFAXSReader.checkSuffix((String)db, (String)"tfcyto")) continue;
                this.pixelsFiles.add(new Location(slide, (String)db).getAbsolutePath());
            }
        }
    }

    private List<ScanRegion> getAllRegions(int t) throws FormatException {
        ArrayList<ScanRegion> planeRegions = new ArrayList<ScanRegion>();
        int index = this.getCoreIndex();
        for (int i = this.regions.size() - 1; i >= 0; --i) {
            int res;
            ScanRegion r = this.regions.get(i);
            if (r.timepoint == t && r.correctionImageCoreIndex != null && r.correctionImageCoreIndex == index) {
                planeRegions.add(r);
                continue;
            }
            if (r.timepoint != t || r.fullResolutionCoreIndex > index || !r.resolutions.contains(res = index - r.fullResolutionCoreIndex)) continue;
            planeRegions.add(r);
        }
        return planeRegions;
    }

    private ScanRegion getRegion() throws FormatException {
        return this.getRegion(0);
    }

    private ScanRegion getRegion(int t) throws FormatException {
        int index = this.getCoreIndex();
        for (int i = this.regions.size() - 1; i >= 0; --i) {
            int res;
            ScanRegion r = this.regions.get(i);
            if (r.timepoint == t && r.correctionImageCoreIndex != null && r.correctionImageCoreIndex == index) {
                return r;
            }
            if (r.timepoint != t || r.fullResolutionCoreIndex > index || !r.resolutions.contains(res = index - r.fullResolutionCoreIndex)) continue;
            return r;
        }
        throw new FormatException("Could not find ScanRegion (core index " + index + ", t=" + t + ")");
    }

    private boolean isCorrectionImage(ScanRegion r) {
        if (r.correctionImageCoreIndex == null) {
            return false;
        }
        return this.getCoreIndex() == r.correctionImageCoreIndex.intValue();
    }

    private int getLevel() throws FormatException {
        if (this.hasFlattenedResolutions()) {
            ScanRegion region = this.getRegion();
            return this.getCoreIndex() - region.fullResolutionCoreIndex;
        }
        return this.getResolution();
    }

    private Codec getCodec(int compression) throws UnsupportedCompressionException {
        switch (compression) {
            case 0: 
            case 1: {
                return new PassthroughCodec();
            }
            case 6: {
                return new JPEGXRCodec();
            }
            case 7: {
                return new JPEGCodec();
            }
        }
        throw new UnsupportedCompressionException("Unsupported compression: " + compression);
    }

    private CodecOptions getCodecOptions(ScanRegion region) {
        CodecOptions options = new CodecOptions();
        options.bitsPerSample = FormatTools.getBytesPerPixel((int)this.getPixelType()) * 8;
        options.width = region.tileSizeX;
        options.height = region.tileSizeY;
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        return options;
    }

    private byte[][] splitFOVs(ScanRegion region, byte[] tile, int scale) {
        byte[][] fovs = new byte[scale * scale][];
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int channels = this.getRGBChannelCount();
        int pixel = bpp * channels;
        int srcWidth = region.tileSizeX * pixel;
        int destWidth = region.tileSizeX / scale * pixel;
        int srcHeight = region.tileSizeY;
        int destHeight = region.tileSizeY / scale;
        for (int fov = 0; fov < fovs.length; ++fov) {
            int fovRow = fov / scale;
            int fovCol = fov % scale;
            fovs[fov] = new byte[destWidth * destHeight * pixel];
            for (int row = 0; row < destHeight; ++row) {
                int srcOffset = (fovRow * destHeight + row) * srcWidth + fovCol * destWidth;
                int destOffset = row * destWidth;
                System.arraycopy(tile, srcOffset, fovs[fov], destOffset, destWidth);
            }
        }
        return fovs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRegionToBuffer(ScanRegion region, int level, Region dest, int[] zct, byte[] buf) throws FormatException, IOException {
        int scale = (int)Math.pow(region.scaleFactor, level);
        int scaledOverlapX = region.overlapX / scale;
        int scaledOverlapY = region.overlapY / scale;
        Connection conn = this.openConnection(region.file);
        try {
            PreparedStatement tiles = conn.prepareStatement("SELECT row, column FROM images WHERE region=? AND level=? AND channel=? AND is_zstack=? AND z_position=? ORDER BY row,column");
            tiles.setInt(1, region.id);
            tiles.setInt(2, level);
            tiles.setInt(3, zct[1] + 1);
            tiles.setInt(4, zct[0] > 0 ? 1 : 0);
            tiles.setInt(5, region.zSteps[zct[0]]);
            CodecOptions options = this.getCodecOptions(region);
            ResultSet subsetTiles = tiles.executeQuery();
            while (subsetTiles.next()) {
                int row = subsetTiles.getInt(1);
                int column = subsetTiles.getInt(2);
                int regionRow = row;
                int regionColumn = column;
                if (region.tmaX != null) {
                    regionColumn += region.tmaX * region.scaleFactor;
                }
                if (region.tmaY != null) {
                    regionRow += region.tmaY * region.scaleFactor;
                }
                int relativeColumn = regionColumn - (int)Math.floor((double)region.tileRangeX[0] / (double)scale);
                int relativeRow = regionRow - (int)Math.floor((double)region.tileRangeY[0] / (double)scale);
                int pixelColumn = relativeColumn * options.width;
                int pixelRow = relativeRow * options.height;
                Region[] fovPositions = new Region[scale * scale];
                if (level == 0) {
                    Region fov = region.fovs.get(row + "-" + column);
                    pixelRow -= fov.y;
                    pixelColumn -= fov.x;
                    if (region.tmaX == null || region.tmaY == null) {
                        pixelRow -= relativeRow * region.overlapY;
                        pixelColumn -= relativeColumn * region.overlapX;
                    } else {
                        pixelRow -= regionRow * region.overlapY;
                        pixelColumn -= regionColumn * region.overlapX;
                    }
                    fovPositions[0] = new Region(pixelColumn, pixelRow, options.width, options.height);
                } else {
                    for (int f = 0; f < fovPositions.length; ++f) {
                        int fovRow = row * scale + f / scale;
                        int fovColumn = column * scale + f % scale;
                        Region fov = region.fovs.get(fovRow + "-" + fovColumn);
                        if (fov == null) continue;
                        int relativeFOVRow = fovRow - region.tileRangeY[0];
                        int relativeFOVColumn = fovColumn - region.tileRangeX[0];
                        int xx = relativeFOVColumn * options.width / scale - fov.x / scale - relativeFOVColumn * scaledOverlapX;
                        int yy = relativeFOVRow * options.height / scale - fov.y / scale - relativeFOVRow * scaledOverlapY;
                        fovPositions[f] = new Region(xx, yy, options.width / scale, options.height / scale);
                    }
                }
                Object fovs = null;
                for (int f = 0; f < fovPositions.length; ++f) {
                    if (fovPositions[f] == null) continue;
                    Region intersection = fovPositions[f].intersection(dest);
                    if (intersection.width <= 0 || intersection.height <= 0) continue;
                    if (fovs == null) {
                        PreparedStatement readTile = conn.prepareStatement("SELECT data, compression FROM images WHERE region=? AND level=? AND channel=? AND is_zstack=? AND z_position=? AND row=? AND column=?");
                        readTile.setInt(1, region.id);
                        readTile.setInt(2, level);
                        readTile.setInt(3, zct[1] + 1);
                        readTile.setInt(4, zct[0] > 0 ? 1 : 0);
                        readTile.setInt(5, region.zSteps[zct[0]]);
                        readTile.setInt(6, row);
                        readTile.setInt(7, column);
                        ResultSet resultTile = readTile.executeQuery();
                        if (resultTile.next()) {
                            byte[] data = resultTile.getBytes(1);
                            int compression = resultTile.getInt(2);
                            Codec codec = this.getCodec(compression);
                            byte[] tile = codec.decompress(data, options);
                            tile = this.applyTransformation(tile, region.id, level, zct[1] + 1, region.zSteps[0], row, column);
                            fovs = level == 0 ? new byte[][]{tile} : (Object)this.splitFOVs(region, tile, scale);
                        } else {
                            throw new FormatException("Could not get tile for row=" + row + ", column=" + column);
                        }
                    }
                    this.copyRegion(fovPositions[f], (byte[])fovs[f], dest, buf, region.tileSizeX / scale);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to query tiles", (Throwable)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.warn("Failed to close connection", (Throwable)e);
            }
        }
    }

    private void copyRegion(Region srcRegion, byte[] src, Region destRegion, byte[] dest, int tileWidth) {
        Region intersection = srcRegion.intersection(destRegion);
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        int outputRowLen = destRegion.width * pixel;
        int intersectionX = Math.max(0, destRegion.x - srcRegion.x);
        int rowLen = pixel * Math.min(intersection.width, srcRegion.width);
        int outputRow = intersection.y - destRegion.y;
        int outputCol = intersection.x - destRegion.x;
        int outputOffset = outputRow * outputRowLen + outputCol * pixel;
        for (int copyRow = 0; copyRow < intersection.height; ++copyRow) {
            int realRow = copyRow + intersection.y - srcRegion.y;
            int inputOffset = pixel * (realRow * tileWidth + intersectionX);
            System.arraycopy(src, inputOffset, dest, outputOffset + copyRow * outputRowLen, rowLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCorrectionImageToBuffer(ScanRegion region, Region dest, int[] zct, byte[] buf) throws FormatException, IOException {
        if (region.timepoint != zct[2]) {
            return;
        }
        Connection conn = this.openConnection(region.file);
        try {
            PreparedStatement correctionQuery = conn.prepareStatement("SELECT compression, data FROM correction_images WHERE id=?");
            Integer correctionID = region.correctionImageIDs.get(zct[1] + "-" + zct[0]);
            if (correctionID == null) {
                correctionID = region.correctionImageIDs.get(zct[1] + "-0");
            }
            if (correctionID == null) {
                return;
            }
            correctionQuery.setInt(1, correctionID);
            ResultSet correctionImgs = correctionQuery.executeQuery();
            if (correctionImgs.next()) {
                int bpp;
                int compression = correctionImgs.getInt(1);
                byte[] data = correctionImgs.getBytes(2);
                CodecOptions options = this.getCodecOptions(region);
                data = this.getCodec(compression).decompress(data, options);
                if (data.length == options.width * options.height * (bpp = FormatTools.getBytesPerPixel((int)this.getPixelType())) * 4) {
                    int srcStride = bpp * 4;
                    int destStride = bpp * this.getRGBChannelCount();
                    byte[] tmp = new byte[options.width * options.height * destStride];
                    if (this.isInterleaved()) {
                        for (int pix = 0; pix < options.width * options.height; ++pix) {
                            System.arraycopy(data, pix * srcStride, tmp, pix * destStride, destStride);
                        }
                    } else {
                        System.arraycopy(data, 0, tmp, 0, tmp.length);
                    }
                    data = tmp;
                }
                Region correction = new Region(0, 0, options.width, options.height);
                this.copyRegion(correction, data, dest, buf, options.width);
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to query tiles", (Throwable)e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.warn("Failed to close connection", (Throwable)e);
            }
        }
    }

    private Connection openConnection(String file) throws IOException {
        Connection conn = null;
        try {
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            conn = config.createConnection("jdbc:sqlite:" + new Location(file).getAbsolutePath());
        }
        catch (SQLException e) {
            LOGGER.warn("Could not read from database");
            throw new IOException(e);
        }
        return conn;
    }

    public byte[] applyTransformation(byte[] tile, int regionID, int level, int channel, int zIndex, int fovRow, int fovColumn) {
        return tile;
    }

    class ScanRegion {
        public String file;
        public JSONObject regionMetadata;
        public int id;
        public int fullResolutionCoreIndex;
        public Integer correctionImageCoreIndex = null;
        public List<Integer> resolutions = new ArrayList<Integer>();
        public int tileSizeX;
        public int tileSizeY;
        public int overlapX;
        public int overlapY;
        public int scaleFactor;
        public int[] tileRangeX = new int[]{Integer.MAX_VALUE, 0};
        public int[] tileRangeY = new int[]{Integer.MAX_VALUE, 0};
        public Integer[] zSteps;
        public int timepoint;
        public List<Channel> channels = new ArrayList<Channel>();
        public HashMap<String, Region> fovs = new HashMap();
        public HashMap<String, Integer> correctionImageIDs = new HashMap();
        public Integer tmaX;
        public Integer tmaY;

        ScanRegion() {
        }

        public void parseJSON() {
            this.tileSizeX = this.regionMetadata.getInt("ImageWidth");
            this.tileSizeY = this.regionMetadata.getInt("ImageHeight");
            this.overlapX = this.regionMetadata.getInt("OverlapWidth");
            this.overlapY = this.regionMetadata.getInt("OverlapHeight");
            this.scaleFactor = this.regionMetadata.getInt("CacheStep");
            if (this.regionMetadata.has("LocationOnTMABlockX")) {
                this.tmaX = this.regionMetadata.getInt("LocationOnTMABlockX");
            }
            if (this.regionMetadata.has("LocationOnTMABlockY")) {
                this.tmaY = this.regionMetadata.getInt("LocationOnTMABlockY");
            }
        }
    }

    class Channel {
        public int id;
        public String name;
        public int color;
        public int exWave;
        public int emWave;

        Channel() {
        }

        public Color getColor() {
            int alpha = this.color >> 24 & 0xFF;
            int red = this.color >> 16 & 0xFF;
            int green = this.color >> 8 & 0xFF;
            int blue = this.color & 0xFF;
            return new Color(red, green, blue, alpha);
        }
    }
}

