/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import ome.xml.model.Arc;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.GenericExcitationSource;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightSource;
import ome.xml.model.Objective;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ArcConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DetectorConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DichroicConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.FilamentConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.FilterConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.GenericExcitationSourceConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.LEDConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.LaserConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.ObjectiveConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.TagNames;

public class MDEParser {
    public static DefaultMutableTreeNode getOMEContent(File file, ModuleController controller) {
        return null;
    }

    public static HashMap<String, ModuleContent> readContentSpec(File file) {
        return null;
    }

    public static List<ModuleContent> parseObjectiveList(List<Objective> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (Objective o : list) {
            ModuleContent content = new ModuleContent(new ObjectiveConverter().convertData(o, null), "OME:Objective", TagNames.getParents("OME:Objective"));
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseDetectorList(List<Detector> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (Detector o : list) {
            ModuleContent content = new ModuleContent(new DetectorConverter().convertData(o, null), "OME:Detector", TagNames.getParents("OME:Detector"));
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseLightSourceLaser(List<LightSource> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (LightSource o : list) {
            ModuleContent content = null;
            if (o instanceof Laser) {
                content = new ModuleContent(new LaserConverter().convertData((Laser)o, null), "OME:Laser", TagNames.getParents("OME:Laser"));
            }
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseLightSourceArc(List<LightSource> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (LightSource o : list) {
            ModuleContent content = null;
            if (o instanceof Arc) {
                content = new ModuleContent(new ArcConverter().convertData((Arc)o, null), "OME:Arc", TagNames.getParents("OME:Arc"));
            }
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseLightSourceFilament(List<LightSource> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (LightSource o : list) {
            ModuleContent content = null;
            if (o instanceof Filament) {
                content = new ModuleContent(new FilamentConverter().convertData((Filament)o, null), "OME:Filament", TagNames.getParents("OME:Filament"));
            }
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseLightSourceLED(List<LightSource> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (LightSource o : list) {
            ModuleContent content = null;
            if (o instanceof LightEmittingDiode) {
                content = new ModuleContent(new LEDConverter().convertData((LightEmittingDiode)o, null), "OME:LightEmittingDiode", TagNames.getParents("OME:LightEmittingDiode"));
            }
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseLightSourceGES(List<LightSource> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (LightSource o : list) {
            ModuleContent content = null;
            if (o instanceof GenericExcitationSource) {
                content = new ModuleContent(new GenericExcitationSourceConverter().convertData((GenericExcitationSource)o, null), "OME:Generic_Excitation_Src", TagNames.getParents("OME:Generic_Excitation_Src"));
            }
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseFilterList(List<Filter> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (Filter o : list) {
            ModuleContent content = new ModuleContent(new FilterConverter().convertData(o), "OME:Filter", TagNames.getParents("OME:Filter"));
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }

    public static List<ModuleContent> parseDichroicList(List<Dichroic> list, ModuleController c) {
        if (list == null) {
            return null;
        }
        ArrayList<ModuleContent> resultList = new ArrayList<ModuleContent>();
        for (Dichroic o : list) {
            ModuleContent content = new ModuleContent(new DichroicConverter().convertData(o), "OME:Dichroic", TagNames.getParents("OME:Dichroic"));
            if (content == null) continue;
            resultList.add(content);
        }
        return resultList;
    }
}

