/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public class HistogramLoader
extends DSCallAdapter {
    private MetadataHandlerView view;
    protected final MetadataViewer viewer;
    private CallHandle handle;
    private SecurityContext ctx;
    private ImageData img;
    private int[] channels;
    private int z;
    private int t;

    public HistogramLoader(MetadataViewer viewer, SecurityContext ctx, ImageData img, int[] channels, int z, int t) {
        this.viewer = viewer;
        this.ctx = ctx;
        this.img = img;
        this.channels = channels;
        this.z = z;
        this.t = t;
        Registry registry = MetadataViewerAgent.getRegistry();
        this.view = (MetadataHandlerView)registry.getDataServicesView(MetadataHandlerView.class);
    }

    public void load() {
        this.handle = this.view.loadHistogram(this.ctx, this.img, this.channels, this.z, this.t, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        Map data = (Map)result;
        for (int ch : this.channels) {
            this.viewer.setHistogramData(ch, (int[])data.get(ch));
        }
    }
}

