/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import omero.gateway.model.ChannelData;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.actions.RndAction;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.RndSettingsPasted;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManageRndSettingsAction
extends RndAction {
    public static final int MIN_MAX = 0;
    public static final int RESET = 1;
    public static final int UNDO = 2;
    public static final int APPLY_TO_ALL = 3;
    public static final int ABSOLUTE_MIN_MAX = 5;
    public static final int SAVE = 6;
    public static final int REDO = 7;
    public static final int COPY = 8;
    public static final int PASTE = 9;
    public static final String NAME_SAVE = "Save";
    private static final String NAME_APPLY_TO_ALL = "Save to All";
    private static final String NAME_ABSOLUTE_MIN_MAX = "Full Range";
    private static final String NAME_MIN_MAX = "Min/Max";
    private static final String NAME_UNDO = "Undo";
    private static final String NAME_REDO = "Redo";
    private static final String NAME_RESET = "Imported";
    private static final String NAME_COPY = "Copy";
    private static final String NAME_PASTE = "Paste";
    private static final String DESCRIPTION_MIN_MAX = "Set the Pixels Intensity interval to min/max for all channels.";
    private static final String DESCRIPTION_ABSOLUTE_MIN_MAX = "Set the Pixels Intensity interval to the full range for all channels.";
    private static final String DESCRIPTION_UNDO = "Undo the last change.";
    private static final String DESCRIPTION_REDO = "Redo the last change.";
    private static final String DESCRIPTION_RESET = "Reset the rendering settings created while importing.";
    private static final String DESCRIPTION_APPLY_TO_ALL = "Apply and save the rendering settings to all images.";
    private static final String DESCRIPTION_COPY = "Copy the current settings";
    private static final String DESCRIPTION_PASTE = "Paste rendering settings";
    private static final String DESCRIPTION_SAVE = "Save the current settings.";
    private int index;

    private void checkIndex(int value) {
        IconManager icons = IconManager.getInstance();
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_MIN_MAX);
                this.setEnabled(this.model.getPixelsDimensionsC() < 100);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_MIN_MAX));
                this.putValue("SmallIcon", icons.getIcon(103));
                break;
            }
            case 5: {
                this.putValue("Name", NAME_ABSOLUTE_MIN_MAX);
                this.setEnabled(this.model.getPixelsDimensionsC() < 100);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ABSOLUTE_MIN_MAX));
                this.putValue("SmallIcon", icons.getIcon(103));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_RESET);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", icons.getIcon(95));
                break;
            }
            case 2: {
                this.setEnabled(false);
                this.putValue("Name", NAME_UNDO);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_UNDO));
                this.putValue("SmallIcon", icons.getIcon(105));
                break;
            }
            case 7: {
                this.setEnabled(false);
                this.putValue("Name", NAME_REDO);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_REDO));
                this.putValue("SmallIcon", icons.getIcon(102));
                break;
            }
            case 3: {
                this.setEnabled(this.model.canAnnotate());
                this.putValue("Name", NAME_APPLY_TO_ALL);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_APPLY_TO_ALL));
                this.putValue("SmallIcon", icons.getIcon(106));
                break;
            }
            case 6: {
                this.setEnabled(this.model.canAnnotate());
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SAVE));
                this.putValue("SmallIcon", icons.getIcon(37));
                break;
            }
            case 8: {
                this.putValue("Name", NAME_COPY);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", icons.getIcon(125));
                break;
            }
            case 9: {
                this.putValue("Name", NAME_PASTE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", icons.getIcon(126));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not valid.");
            }
        }
    }

    public ManageRndSettingsAction(Renderer model, int index) {
        super(model);
        this.setEnabled(true);
        this.checkIndex(index);
        this.index = index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                boolean range = false;
                if (this.index == 0) {
                    List<ChannelData> channels = this.model.getChannelData();
                    for (ChannelData c : channels) {
                        if (c.hasStats()) continue;
                        range = true;
                        break;
                    }
                }
                this.model.setRangeAllChannels(range);
                break;
            }
            case 5: {
                this.model.setRangeAllChannels(true);
                break;
            }
            case 1: {
                this.model.resetSettings();
                break;
            }
            case 2: {
                this.model.historyBack();
                break;
            }
            case 7: {
                this.model.historyForward();
                break;
            }
            case 3: {
                this.model.applyToAll();
                break;
            }
            case 6: {
                this.saveRndSettings();
                break;
            }
            case 8: {
                this.copyRndSettings();
                break;
            }
            case 9: {
                this.pasteRndSettings();
            }
        }
    }

    private void saveRndSettings() {
        this.model.saveSettings();
    }

    private void copyRndSettings() {
        CopyRndSettings evt = this.model.isModified() ? new CopyRndSettings(this.model.getRefImage(), this.model.getRndSettingsCopy()) : new CopyRndSettings(this.model.getRefImage());
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(evt);
    }

    private void pasteRndSettings() {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new RndSettingsPasted(this.model.getRefImage().getId()));
    }
}

