/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor.maptable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import omero.gateway.model.MapAnnotationData;
import omero.model.NamedValue;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTable;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapUtils;
import org.openmicroscopy.shoola.util.ui.table.Reorderable;

public class MapTableModel
extends DefaultTableModel
implements Reorderable {
    private MapTable table;
    private MapAnnotationData map;
    private List<NamedValue> data;
    private List<NamedValue> originalData;

    public MapTableModel(MapTable table) {
        this.table = table;
    }

    public NamedValue getRow(int index) {
        if (index >= 0 && index < this.data.size()) {
            return this.data.get(index);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.table == null) {
            return 0;
        }
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Key";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.data.size()) {
            NamedValue d = this.data.get(row);
            switch (column) {
                case 0: {
                    return d.name;
                }
                case 1: {
                    return d.value;
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        String value = (String)aValue;
        if (row < this.data.size()) {
            NamedValue d = this.data.get(row);
            switch (column) {
                case 0: {
                    d.name = value;
                    break;
                }
                case 1: {
                    d.value = value;
                    if (row != this.data.size() - 1 || MapUtils.isEmpty(d)) break;
                    this.addEntry("", "");
                }
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    void addEntry(String name, String value) {
        this.addEntries(Arrays.asList(new NamedValue(name, value)), -1);
    }

    public void addEntries(List<NamedValue> entries, int index) {
        if (index < 0 || index > this.data.size()) {
            index = this.data.size();
        }
        this.data.addAll(index, entries);
        this.syncBackToMap();
    }

    public void deleteEntry(int index) {
        if (index >= 0 && index < this.data.size()) {
            this.data.remove(index);
            this.syncBackToMap();
        }
    }

    public void deleteEntries(int[] indices) {
        ArrayList<NamedValue> toRemove = new ArrayList<NamedValue>();
        for (int index : indices) {
            toRemove.add(this.getRow(index));
        }
        this.data.removeAll(toRemove);
        this.syncBackToMap();
    }

    public void setData(MapAnnotationData map) {
        this.map = map;
        this.data = (List)map.getContent();
        if (this.data == null) {
            this.data = new ArrayList<NamedValue>();
            this.originalData = new ArrayList<NamedValue>();
        } else {
            this.originalData = new ArrayList<NamedValue>(this.data.size());
            for (NamedValue tmp : this.data) {
                this.originalData.add(new NamedValue(tmp.name, tmp.value));
            }
        }
        if (this.data.size() == 0 && this.table.canEdit()) {
            this.addEntry("Add Key", "Add Value");
        }
    }

    private List<NamedValue> getTrimmedData() {
        ArrayList<NamedValue> result = new ArrayList<NamedValue>();
        for (NamedValue nv : this.data) {
            if (MapUtils.isEmpty(nv)) continue;
            result.add(nv);
        }
        return result;
    }

    private void syncBackToMap() {
        this.map.setContent(this.getTrimmedData());
        this.table.revalidate();
        this.fireTableDataChanged();
    }

    public boolean isDirty() {
        List<NamedValue> data = this.getTrimmedData();
        if (data.size() != this.originalData.size()) {
            return true;
        }
        for (int i = 0; i < data.size(); ++i) {
            NamedValue nv1 = data.get(i);
            NamedValue nv2 = this.originalData.get(i);
            if (nv1.name.equals(nv2.name) && nv1.value.equals(nv2.value)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public MapAnnotationData getMap() {
        if (this.isDirty()) {
            this.map.setContent(this.getTrimmedData());
        }
        return this.map;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 2) {
            return false;
        }
        return this.table.canEdit();
    }

    @Override
    public int reorder(int[] fromIndices, int toIndex) {
        ArrayList<NamedValue> values = new ArrayList<NamedValue>();
        int offset = 0;
        for (int fromIndex : fromIndices) {
            if (toIndex < 0) {
                toIndex = 0;
            }
            if (toIndex > this.data.size()) {
                toIndex = this.data.size();
            }
            if (fromIndex < 0 || fromIndex >= this.data.size()) continue;
            values.add(this.data.get(fromIndex));
            if (fromIndex > toIndex) continue;
            --offset;
        }
        int newIndex = toIndex + offset;
        if (!values.isEmpty()) {
            this.data.removeAll(values);
            this.data.addAll(newIndex, values);
        }
        this.syncBackToMap();
        return newIndex;
    }
}

