/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import omero.model.Pixels;
import org.openmicroscopy.shoola.env.rnd.roi.AbstractROIShapeStats;
import org.openmicroscopy.shoola.env.rnd.roi.PointIteratorObserver;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStats;

public class ROIStats
implements PointIteratorObserver {
    private Pixels dims;
    private Map<Integer, ROIShapeStats> arrayMap;

    private Integer linearize(int z, int w, int t) {
        int sizeZ = this.dims.getSizeZ().getValue();
        int sizeC = this.dims.getSizeC().getValue();
        if (z < 0 || sizeZ <= z) {
            throw new IllegalArgumentException("z out of range [0, " + sizeZ + "): " + z + ".");
        }
        if (w < 0 || sizeC <= w) {
            throw new IllegalArgumentException("w out of range [0, " + sizeC + "): " + w + ".");
        }
        if (t < 0 || this.dims.getSizeT().getValue() <= t) {
            throw new IllegalArgumentException("t out of range [0, " + this.dims.getSizeT() + "): " + t + ".");
        }
        return sizeZ * sizeC * t + sizeZ * w + z;
    }

    public ROIStats(Pixels dims) {
        if (dims == null) {
            throw new NullPointerException("No dims.");
        }
        this.dims = dims;
    }

    public AbstractROIShapeStats getPlaneStats(int z, int w, int t) {
        Integer index = this.linearize(z, w, t);
        return this.arrayMap.get(index);
    }

    @Override
    public void iterationStarted() {
        this.arrayMap = new HashMap<Integer, ROIShapeStats>();
    }

    @Override
    public void onStartPlane(int z, int w, int t, int pointsCount) {
        ROIShapeStats planeStats = new ROIShapeStats();
        Integer index = this.linearize(z, w, t);
        this.arrayMap.put(index, planeStats);
    }

    @Override
    public void update(double pixelValue, int z, int w, int t, Point loc) {
        Integer index = this.linearize(z, w, t);
        AbstractROIShapeStats planeStats = this.arrayMap.get(index);
        if (pixelValue < planeStats.getMin()) {
            planeStats.setMin(pixelValue);
        }
        if (planeStats.getMax() < pixelValue) {
            planeStats.setMax(pixelValue);
        }
        planeStats.addToSum(pixelValue);
        planeStats.addToSumOfSquares(pixelValue);
    }

    @Override
    public void onEndPlane(int z, int w, int t, int pointsCount) {
        Integer index = this.linearize(z, w, t);
        AbstractROIShapeStats ps = this.arrayMap.get(index);
        if (0 < pointsCount) {
            double sigmaSquare;
            ps.setMean(ps.getSum() / (double)pointsCount);
            ps.setPointsCount(pointsCount);
            if (0 < pointsCount - 1 && (sigmaSquare = (ps.getSumOfSquares() - ps.getSum() * ps.getSum() / (double)pointsCount) / (double)(pointsCount - 1)) > 0.0) {
                ps.setStandardDeviation(Math.sqrt(sigmaSquare));
            }
        }
    }

    @Override
    public void iterationFinished() {
    }
}

