/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import omero.gateway.SecurityContext;
import omero.gateway.model.ExperimenterData;
import omero.log.LogMessage;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.DownloadsDialog;
import org.openmicroscopy.shoola.env.ui.ExportActivity;
import org.openmicroscopy.shoola.env.ui.FileUploader;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;
import org.openmicroscopy.shoola.util.ui.MessengerDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class UserNotifierManager
implements PropertyChangeListener {
    private static final String MESSAGE_START = "Sorry, but due to an error we were not able to automatically \n";
    private static final String MESSAGE_END = "\n\nYou can still send us the error message by clicking on the \nerror message tab, copying the error message to the clipboard, \nand sending it to ";
    private static final String ERROR_MSG = "send your debug information.";
    private static final String COMMENT_MSG = "send your comment.";
    private static final String COMMENT_REPLY = "Thanks, your comments have been successfully posted.";
    private static final String ERROR_REPLY = "Thanks, the error message has been successfully posted.";
    private static final String DEFAULT_COMMENT_TITLE = "Comment";
    private Container container;
    private UserNotifier component;
    private Map<String, UserNotifierLoader> loaders;
    private MessengerDialog commentDialog;
    private DownloadsDialog activityDialog;
    private List<ActivityComponent> activities;

    private String getInvoker(boolean comment) {
        Registry reg = this.container.getRegistry();
        String master = (String)reg.lookup("master");
        if (comment) {
            if ("OMERO.importer".equals(master)) {
                return "importer_comments";
            }
            return "insight_comments";
        }
        if ("OMERO.importer".equals(master)) {
            return "importer_bugs";
        }
        return "insight_bugs";
    }

    private void handleSendMessage(MessengerDialog source, MessengerDetails details) {
        Registry reg = this.container.getRegistry();
        if (details.getObjectToSubmit() != null) {
            ExperimenterData exp = (ExperimenterData)reg.lookup("/current_user/details");
            SecurityContext ctx = new SecurityContext(exp.getDefaultGroup().getId());
            FileUploader loader = new FileUploader(this.component, this.container.getRegistry(), ctx, source, details);
            loader.load();
            return;
        }
        boolean bug = true;
        String error = details.getError();
        if (CommonsLangUtils.isBlank(error)) {
            bug = false;
        }
        String url = (String)reg.lookup("/services/DEBUGGER/hostnameToken");
        String appName = bug ? (String)reg.lookup("/services/DEBUGGER/applicationNameBug") : (String)reg.lookup("/services/DEBUGGER/applicationNameComment");
        CommunicatorDescriptor desc = new CommunicatorDescriptor(1, url, -1);
        Object version = reg.lookup("Version");
        String v = "";
        if (version != null && version instanceof String) {
            v = (String)version;
        }
        try {
            Communicator c = SvcRegistry.getCommunicator(desc);
            StringBuilder builder = new StringBuilder();
            String reply = "";
            String invoker = this.getInvoker(bug);
            if (!bug) {
                c.submitComment(invoker, details.getEmail(), details.getComment(), details.getExtra(), appName, v, builder);
            } else {
                c.submitError(invoker, details.getEmail(), details.getComment(), details.getExtra(), error, appName, v, builder);
            }
            reply = !bug ? COMMENT_REPLY : ERROR_REPLY;
            JOptionPane.showMessageDialog(source, reply);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.println("Failed to send message.");
            msg.println("Reason: " + e.getMessage());
            Logger logger = this.container.getRegistry().getLogger();
            logger.error((Object)this, msg);
            Object s = MESSAGE_START;
            s = source.getDialogType() == 0 ? (String)s + ERROR_MSG : (String)s + COMMENT_MSG;
            String address = (String)this.container.getRegistry().lookup("/services/DEBUGGER/emailAddress");
            if (address != null && address.trim().length() > 0) {
                s = (String)s + MESSAGE_END;
                s = (String)s + address;
                s = (String)s + ".";
            }
            JOptionPane.showMessageDialog(source, s);
        }
        source.setVisible(false);
        source.dispose();
    }

    private void createActivity() {
        if (this.activityDialog != null) {
            return;
        }
        Registry reg = this.getRegistry();
        JFrame f = reg.getTaskBar().getFrame();
        this.activityDialog = new DownloadsDialog(f, IconManager.getInstance(reg), 2);
    }

    UserNotifierManager(UserNotifier component, Container c) {
        this.container = c;
        this.component = component;
        this.loaders = new HashMap<String, UserNotifierLoader>();
        JFrame f = this.getRegistry().getTaskBar().getFrame();
        if (f != null) {
            f.addPropertyChangeListener("activities", this);
        }
    }

    ExperimenterData getExperimenter() {
        Object exp = this.container.getRegistry().lookup("/current_user/details");
        if (exp == null) {
            return null;
        }
        return (ExperimenterData)exp;
    }

    void registerActivity(ActivityComponent activity, boolean uiRegister) {
        if (activity == null) {
            return;
        }
        if (uiRegister) {
            this.createActivity();
            this.activityDialog.addActivityEntry(activity);
            this.showActivity();
        }
        if (this.activities == null) {
            this.activities = new ArrayList<ActivityComponent>();
        }
        activity.addPropertyChangeListener(this);
        this.activities.add(activity);
    }

    String getServerVersion() {
        if (this.container == null) {
            return "";
        }
        String name = this.container.getRegistry().getAdminService().getServerName();
        if (name == null) {
            name = "";
        }
        String version = this.container.getRegistry().getAdminService().getServerVersion();
        if (name == null || name.trim().length() == 0) {
            return "";
        }
        if (version == null || version.trim().length() == 0) {
            version = "not available";
        }
        return "Server name: " + name + ", version: " + version;
    }

    Registry getRegistry() {
        return this.container.getRegistry();
    }

    MessengerDialog getCommentDialog(JFrame frame, String email) {
        if (this.commentDialog != null) {
            return this.commentDialog;
        }
        this.commentDialog = new MessengerDialog(frame, DEFAULT_COMMENT_TITLE, email);
        this.commentDialog.setServerVersion(this.getServerVersion());
        this.commentDialog.addPropertyChangeListener(this);
        this.commentDialog.setModal(false);
        this.commentDialog.setAlwaysOnTop(false);
        return this.commentDialog;
    }

    void showActivity() {
        if (this.activityDialog == null) {
            this.createActivity();
        }
        if (!this.activityDialog.isVisible()) {
            UIUtilities.centerAndShow(this.activityDialog);
        }
        this.activityDialog.requestFocusInWindow();
        this.activityDialog.toFront();
    }

    int getRunningActivitiesCount() {
        if (this.activities == null) {
            return 0;
        }
        return this.activities.size();
    }

    void clearActivities() {
        if (this.activities != null) {
            this.activities.clear();
        }
        if (this.activityDialog != null) {
            this.activityDialog.setVisible(false);
            this.activityDialog = null;
        }
    }

    void startActivity(boolean start, ActivityComponent comp) {
        if (comp == null) {
            return;
        }
        if (start) {
            comp.startActivity();
        }
        EventBus bus = this.getRegistry().getEventBus();
        bus.post(new ActivityProcessEvent(comp, false));
        UserNotifierLoader loader = comp.createLoader();
        if (loader != null) {
            loader.load();
        }
    }

    boolean hasRunningActivityOfType(Class type) {
        if (type == null || this.getRunningActivitiesCount() == 0) {
            return false;
        }
        if (ExportActivity.class.equals((Object)type)) {
            for (ActivityComponent ac : this.activities) {
                if (!ExportActivity.class.equals(ac.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        block5: {
            String name;
            block7: {
                block6: {
                    block4: {
                        name = pce.getPropertyName();
                        if (!"send".equals(name)) break block4;
                        MessengerDialog source = (MessengerDialog)pce.getSource();
                        this.handleSendMessage(source, (MessengerDetails)pce.getNewValue());
                        break block5;
                    }
                    if (!"closeMessenger".equals(name)) break block6;
                    this.commentDialog = null;
                    break block5;
                }
                if ("saveToDisk".equals(name)) break block5;
                if (!"cancelLoading".equals(name)) break block7;
                String fileName = (String)pce.getNewValue();
                UserNotifierLoader loader = this.loaders.get(fileName);
                if (loader == null) break block5;
                loader.cancel();
                break block5;
            }
            if ("unregisterActivity".equals(name)) {
                ActivityComponent c = (ActivityComponent)pce.getNewValue();
                if (c != null) {
                    this.activities.remove(c);
                }
                if (c instanceof ExportActivity) {
                    for (ActivityComponent ac : this.activities) {
                        if (!ExportActivity.class.equals(ac.getClass())) continue;
                        this.startActivity(true, ac);
                        break;
                    }
                }
            }
        }
    }
}

