/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.PartialLineBorder;

public class ServerEditor
extends JPanel {
    public static final String REMOVE_MESSAGE_PROPERTY = "removeMessage";
    public static final String ADD_MESSAGE_PROPERTY = "addMessage";
    static final String EDIT_PROPERTY = "edit";
    static final String REMOVE_PROPERTY = "remove";
    static final String APPLY_SERVER_PROPERTY = "applyServer";
    static final String SERVER_NAME_SEPARATOR = ",";
    static final int DEFAULT_PORT = 4064;
    private static final String EXAMPLE = "<html><i>my.server.name</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(default case)<br><i>my.server.name:port</i>&nbsp;&nbsp;(for non-default ports)<br><i>127.0.0.1:1234</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(if you have an IP address)<br><i>wss://my.server.name</i>&nbsp;(connecting via websocket)<br><br></html>";
    private static final String HEADER = "Server Address Examples";
    private static final String OMERO_SERVER = "omeroServer";
    private static final Font FONT = new Font("Monospaced", 0, 10);
    private JButton removeButton;
    private JButton addButton;
    private JButton editButton;
    private DefaultListModel servers;
    private JList<String> table;
    private JPanel emptyMessagePanel;
    private IconManager icons = IconManager.getInstance();
    private boolean warning;
    private String activeServer = "";

    private void initComponents(List<String> servers) {
        this.servers = new DefaultListModel(){

            public void insertElementAt(Object var1, int var2) {
                if (!this.contains(var1)) {
                    super.insertElementAt(var1, var2);
                }
            }

            public void addElement(Object var1) {
                if (!this.contains(var1)) {
                    super.addElement(var1);
                }
            }
        };
        servers.stream().forEach(s -> this.servers.addElement(s));
        this.table = new JList(this.servers);
        this.table.setSelectionMode(0);
        this.table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ServerEditor.this.fireEditProperty(true);
                ServerEditor.this.editButton.setEnabled(ServerEditor.this.table.getSelectedIndex() >= 0);
            }
        });
        this.removeButton = new JButton(this.icons.getIcon(24));
        this.removeButton.setName("remove server button");
        UIUtilities.unifiedButtonLookAndFeel(this.removeButton);
        this.removeButton.setToolTipText("Remove the selected server from the list of servers.");
        this.addButton = new JButton(this.icons.getIcon(28));
        this.addButton.setName("add server button");
        this.addButton.setToolTipText("Add a new server to the list of servers.");
        this.addButton.setBorder(new TitledBorder(""));
        UIUtilities.unifiedButtonLookAndFeel(this.addButton);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ServerEditor.this.table.getSelectedIndex();
                if (row > -1) {
                    int sel = row - 1;
                    if (sel < 0) {
                        sel = 0;
                    }
                    ServerEditor.this.servers.remove(row);
                    ServerEditor.this.table.setSelectedIndex(sel);
                }
            }
        });
        this.removeButton.setEnabled(!this.servers.isEmpty());
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String add = JOptionPane.showInputDialog(ServerEditor.this, "Enter server address:", "Add new server", -1);
                if (add != null) {
                    add = add.trim();
                    if ((add = add.replace(":4064", "")).toLowerCase().startsWith("http://") || add.toLowerCase().startsWith("https://")) {
                        add = add.substring(add.indexOf(47) + 2, add.length());
                    }
                    if (add.length() > 0) {
                        ServerEditor.this.servers.addElement(add);
                        ServerEditor.this.table.setSelectedValue(add, true);
                        ServerEditor.this.removeButton.setEnabled(true);
                    }
                }
            }
        });
        this.editButton = new JButton(this.icons.getIcon(116));
        this.editButton.setName("edit server button");
        UIUtilities.unifiedButtonLookAndFeel(this.editButton);
        this.editButton.setToolTipText("Edit an existing server.");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ServerEditor.this.table.getSelectedIndex();
                String edited = (String)JOptionPane.showInputDialog(ServerEditor.this, "", "Edit server", -1, null, null, ServerEditor.this.table.getSelectedValue());
                if (edited != null) {
                    edited = edited.replace(":4064", "");
                    ServerEditor.this.servers.remove(row);
                    ServerEditor.this.servers.add(row, edited);
                    ServerEditor.this.table.setSelectedValue(edited, true);
                }
            }
        });
        this.editButton.setEnabled(!servers.isEmpty());
    }

    private void buildGUI() {
        JPanel labels = new JPanel();
        labels.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        JLabel label = UIUtilities.setTextFont(HEADER);
        labels.add((Component)label, c);
        label = new JLabel(EXAMPLE);
        label.setFont(FONT);
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        labels.add((Component)label, c);
        if (this.activeServer != null) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            label = UIUtilities.setTextFont("Connecting to ");
            labels.add((Component)label, c);
            c.gridwidth = 0;
            c.weightx = 1.0;
            label = new JLabel(this.activeServer);
            labels.add((Component)label, c);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JScrollPane pane = new JScrollPane(this.table);
        Dimension d = pane.getPreferredSize();
        pane.setPreferredSize(new Dimension(d.width, 150));
        p.add(pane);
        p.add(this.buildControls());
        this.setLayout(new BoxLayout(this, 1));
        JPanel content = UIUtilities.buildComponentPanel(labels);
        this.add(content);
        this.add(p);
    }

    private JPanel buildControls() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.addButton);
        bar.add(this.removeButton);
        bar.add(this.editButton);
        return UIUtilities.buildComponentPanel(bar);
    }

    private void setButtonsEnabled(boolean b) {
        this.removeButton.setEnabled(b);
        this.editButton.setEnabled(b);
    }

    private void fireEditProperty(boolean b) {
        this.firePropertyChange(EDIT_PROPERTY, (Object)(!b ? 1 : 0), (Object)b);
    }

    private void buildEmptyPanel() {
        if (this.emptyMessagePanel != null) {
            return;
        }
        this.emptyMessagePanel = new JPanel();
        this.emptyMessagePanel.setOpaque(false);
        this.emptyMessagePanel.setBorder(new PartialLineBorder(Color.BLACK));
        this.emptyMessagePanel.setLayout(new BoxLayout(this.emptyMessagePanel, 0));
    }

    ServerEditor() {
        this((String)null);
    }

    ServerEditor(String activeServer) {
        this.activeServer = activeServer == null ? "" : activeServer;
        List<String> servers = this.getServers();
        this.initComponents(servers);
        this.buildGUI();
    }

    void showMessagePanel(boolean warning) {
        this.warning = warning;
        this.fireEditProperty(!warning);
        this.setButtonsEnabled(!warning);
        if (warning) {
            if (this.emptyMessagePanel != null) {
                return;
            }
            this.buildEmptyPanel();
            this.firePropertyChange(ADD_MESSAGE_PROPERTY, null, this.emptyMessagePanel);
        } else {
            if (this.emptyMessagePanel == null) {
                return;
            }
            this.firePropertyChange(REMOVE_MESSAGE_PROPERTY, null, this.emptyMessagePanel);
            this.emptyMessagePanel = null;
        }
    }

    String getSelectedServer() {
        return this.table.getSelectedValue();
    }

    boolean isOriginalSelected() {
        return this.getSelectedServer() == null ? false : this.getSelectedServer().equals(this.activeServer);
    }

    void addRow(String server) {
        this.servers.addElement(server);
        this.table.setSelectedValue(server, true);
    }

    List<String> getServers() {
        Preferences prefs = Preferences.userNodeForPackage(ServerEditor.class);
        List<String> servers = this.getServersFromPrefs(prefs);
        Preferences oldPrefs = Preferences.userNodeForPackage(org.openmicroscopy.shoola.util.ui.login.ServerEditor.class);
        for (String s : this.getServersFromPrefs(oldPrefs)) {
            if (servers.contains(s)) continue;
            servers.add(0, s);
        }
        return servers;
    }

    private List<String> getServersFromPrefs(Preferences prefs) {
        String servers = prefs.get(OMERO_SERVER, null);
        if (servers == null || servers.length() == 0) {
            return new ArrayList<String>();
        }
        String[] l = servers.split(SERVER_NAME_SEPARATOR, 0);
        for (int i = 0; i < l.length; ++i) {
            l[i] = l[i].replace(":4064", "");
        }
        if (l == null) {
            return new ArrayList<String>();
        }
        return Stream.of(l).collect(Collectors.toList());
    }

    void handleServers(String serverName) {
        serverName = serverName == null ? "" : serverName.trim();
        Preferences prefs = Preferences.userNodeForPackage(ServerEditor.class);
        ArrayList l = new ArrayList();
        Stream.of(this.servers.toArray()).forEach(s -> l.add((String)s));
        if (l.isEmpty()) {
            prefs.put(OMERO_SERVER, "");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (String s2 : l) {
            if ((s2 = s2.trim()).equals(serverName)) continue;
            buffer.append(s2);
            buffer.append(SERVER_NAME_SEPARATOR);
        }
        if (serverName.length() > 0) {
            buffer.append(serverName);
        }
        prefs.put(OMERO_SERVER, buffer.toString());
    }

    void setFocus(String server) {
        this.table.setSelectedValue(server, true);
    }

    int getRowCount() {
        return this.servers.getSize();
    }
}

