/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur;

import org.openmicroscopy.shoola.util.concur.BufferWriteException;
import org.openmicroscopy.shoola.util.concur.ByteBufferFiller;
import org.openmicroscopy.shoola.util.concur.ProducerLoop;
import org.openmicroscopy.shoola.util.concur.tasks.AsyncProcessor;
import org.openmicroscopy.shoola.util.concur.tasks.CmdProcessor;
import org.openmicroscopy.shoola.util.concur.tasks.ExecException;
import org.openmicroscopy.shoola.util.concur.tasks.ExecMonitor;
import org.openmicroscopy.shoola.util.concur.tasks.Future;
import org.openmicroscopy.shoola.util.concur.tasks.MultiStepTask;
import org.openmicroscopy.shoola.util.mem.ReadOnlyByteArray;

public class AsyncByteBuffer {
    private final byte[] buffer;
    private final int BLOCK_SIZE;
    private final CmdProcessor cmdProcessor;
    private ProducerLoop producer;
    private Future producerHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadOnlyByteArray doRead(int offset, int length, long timeout) throws BufferWriteException, InterruptedException {
        ProducerLoop currentProducer;
        ReadOnlyByteArray roba = null;
        AsyncByteBuffer asyncByteBuffer = this;
        synchronized (asyncByteBuffer) {
            currentProducer = this.producer;
        }
        if (currentProducer != null) {
            boolean available = false;
            available = timeout < 0L ? currentProducer.waitForData(offset, length) : currentProducer.waitForData(offset, length, timeout);
            if (available) {
                roba = this.readFromBuffer(offset, length);
            }
        }
        return roba;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadOnlyByteArray readFromBuffer(int offset, int length) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new ReadOnlyByteArray(this.buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeToBuffer(ByteBufferFiller producer, int offset) throws BufferWriteException {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return producer.write(this.buffer, offset, this.BLOCK_SIZE);
        }
    }

    public AsyncByteBuffer(int size, int blockSize) {
        if (size < 1) {
            throw new IllegalArgumentException("Non-positive size: " + size + ".");
        }
        if (blockSize < 1 || size < blockSize) {
            throw new IllegalArgumentException("Invalid blockSize: " + blockSize + ".");
        }
        this.buffer = new byte[size];
        this.BLOCK_SIZE = blockSize;
        this.cmdProcessor = new AsyncProcessor();
    }

    public AsyncByteBuffer(int size, int blockSize, CmdProcessor cp) {
        if (size < 1) {
            throw new IllegalArgumentException("Non-positive size: " + size + ".");
        }
        if (blockSize < 1 || size < blockSize) {
            throw new IllegalArgumentException("Invalid blockSize: " + blockSize + ".");
        }
        if (cp == null) {
            throw new NullPointerException("No command processor.");
        }
        this.buffer = new byte[size];
        this.BLOCK_SIZE = blockSize;
        this.cmdProcessor = cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(ByteBufferFiller p) throws InterruptedException {
        AsyncByteBuffer asyncByteBuffer = this;
        synchronized (asyncByteBuffer) {
            if (this.producer != null) {
                this.producerHandle.cancelExecution();
                try {
                    this.producerHandle.getResult();
                }
                catch (ExecException execException) {
                    // empty catch block
                }
                this.producer = null;
            }
            if (p == null) {
                return;
            }
            this.producer = new ProducerLoop(this, p);
            this.producerHandle = this.cmdProcessor.exec((MultiStepTask)this.producer, (ExecMonitor)this.producer);
        }
    }

    public ReadOnlyByteArray read(int offset, int length) throws BufferWriteException, InterruptedException {
        return this.doRead(offset, length, -1L);
    }

    public ReadOnlyByteArray read(int offset, int length, long timeout) throws BufferWriteException, InterruptedException {
        if (timeout <= 0L) {
            timeout = 0L;
        }
        return this.doRead(offset, length, timeout);
    }

    public int getSize() {
        return this.buffer.length;
    }
}

