/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

public class RuntimeConfigParser {
    public static void read(InputStream is, StringBuilder errlog) throws IOException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        try {
            doc = saxBuilder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        RuntimeConfigParser.read(doc.getRootElement(), errlog);
    }

    public static void read(Element root, StringBuilder errlog) {
        List children = root.getChildren();
        for (Object child : children) {
            Element elem = (Element)child;
            switch (elem.getName()) {
                case "ioServiceProvider": {
                    String className = elem.getAttributeValue("class");
                    errlog.append(String.format("Registering IOSP from NJ22CONFIG: class = '%s' \n", className));
                    try {
                        NetcdfFile.registerIOProvider(className);
                        NetcdfFiles.registerIOProvider(className);
                    }
                    catch (ClassNotFoundException e) {
                        errlog.append("IOServiceProvider class not found= " + className + "; check your classpath\n");
                    }
                    catch (Exception e) {
                        errlog.append("IOServiceProvider " + className + " failed= " + e.getMessage() + "\n");
                    }
                    break;
                }
                case "coordSysBuilder": {
                    String conventionName = elem.getAttributeValue("convention");
                    String className = elem.getAttributeValue("class");
                    try {
                        CoordSysBuilder.registerConvention(conventionName, className);
                    }
                    catch (ClassNotFoundException e) {
                        errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                    }
                    catch (Exception e) {
                        errlog.append("CoordSysBuilder " + className + " failed= " + e.getMessage() + "\n");
                    }
                    break;
                }
                case "coordTransBuilder": {
                    String transformName = elem.getAttributeValue("name");
                    String className = elem.getAttributeValue("class");
                    try {
                        CoordTransBuilder.registerTransform(transformName, className);
                    }
                    catch (ClassNotFoundException e) {
                        errlog.append("CoordTransBuilder class not found= " + className + "; check your classpath\n");
                    }
                    catch (Exception e) {
                        errlog.append("CoordTransBuilder " + className + " failed= " + e.getMessage() + "\n");
                    }
                    break;
                }
                case "featureDatasetFactory": {
                    String typeName = elem.getAttributeValue("featureType");
                    String className = elem.getAttributeValue("class");
                    FeatureType featureType = FeatureType.valueOf(typeName.toUpperCase());
                    if (null == featureType) {
                        errlog.append("FeatureDatasetFactory " + className + " unknown datatype= " + typeName + "\n");
                        break;
                    }
                    try {
                        boolean ok = FeatureDatasetFactoryManager.registerFactory(featureType, className);
                        if (ok) break;
                        errlog.append("FeatureDatasetFactory " + className + " failed\n");
                    }
                    catch (Exception e) {
                        errlog.append("FeatureDatasetFactory " + className + " failed= " + e.getMessage() + "\n");
                    }
                    break;
                }
                case "gribParameterTable": {
                    String editionS = elem.getAttributeValue("edition");
                    String centerS = elem.getAttributeValue("center");
                    String subcenterS = elem.getAttributeValue("subcenter");
                    String versionS = elem.getAttributeValue("version");
                    String filename = elem.getText();
                    if (centerS == null || versionS == null || filename == null) {
                        errlog.append("table element must center, version and filename attributes\n");
                        break;
                    }
                    try {
                        int center = Integer.parseInt(centerS);
                        int subcenter = subcenterS == null ? -1 : Integer.parseInt(subcenterS);
                        int version = Integer.parseInt(versionS);
                        Class<?> c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.grib.grib1.tables.Grib1ParamTables");
                        Method m = c.getMethod("addParameterTable", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
                        m.invoke(null, center, subcenter, version, filename);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String strictS = elem.getAttributeValue("strict");
                    if (strictS == null) break;
                    boolean notStrict = strictS.equalsIgnoreCase("false");
                    try {
                        Class<?> c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.tables.Grib1ParamTables");
                        Method m = c.getMethod("setStrict", Boolean.TYPE);
                        m.invoke(null, !notStrict);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "gribParameterTableLookup": {
                    Class<?> c;
                    String editionS = elem.getAttributeValue("edition");
                    String filename = elem.getText();
                    try {
                        c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.grib.grib1.tables.Grib1ParamTables");
                        Method m = c.getMethod("addParameterTableLookup", String.class);
                        m.invoke(null, filename);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "table": {
                    Class<?> c;
                    String type = elem.getAttributeValue("type");
                    String filename = elem.getAttributeValue("filename");
                    if (type == null || filename == null) {
                        errlog.append("table element must have both type and filename attributes\n");
                        break;
                    }
                    try {
                        if (type.equalsIgnoreCase("GRIB1")) {
                            try {
                                c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.GribPDSParamTable");
                                Method m = c.getMethod("addParameterUserLookup", String.class);
                                m.invoke(null, filename);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        if (type.equalsIgnoreCase("GRIB2")) {
                            try {
                                c = RuntimeConfigParser.class.getClassLoader().loadClass(" ucar.grib.grib2.ParameterTable");
                                Method m = c.getMethod("addParametersUser", String.class);
                                m.invoke(null, filename);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        errlog.append("Unknown table type " + type + "\n");
                    }
                    catch (Exception e) {
                        errlog.append("table read failed on  " + filename + " = " + e.getMessage() + "\n");
                    }
                    break;
                }
                case "bufrtable": {
                    String filename = elem.getAttributeValue("filename");
                    if (filename == null) {
                        errlog.append("bufrtable must have filename attribute\n");
                        break;
                    }
                    try {
                        Class<?> bufrTablesClass = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.iosp.bufr.tables.BufrTables");
                        Class[] params = new Class[]{String.class};
                        Method method = bufrTablesClass.getMethod("addLookupFile", params);
                        Object[] args = new Object[]{filename};
                        method.invoke(null, args);
                    }
                    catch (Throwable e) {
                        if (e instanceof FileNotFoundException) {
                            errlog.append("bufrtable read failed on  " + filename + " = " + e.getMessage() + "\n");
                            break;
                        }
                        errlog.append("bufr.jar is not on classpath\n");
                    }
                    break;
                }
                case "Netcdf4Clibrary": {
                    String nc4IospClassName = "ucar.nc2.jni.netcdf.Nc4Iosp";
                    String netcdfClibraryClassName = "ucar.nc2.ffi.netcdf.NetcdfClibrary";
                    String path = elem.getChildText("libraryPath");
                    String name = elem.getChildText("libraryName");
                    errlog.append(String.format("Netcdf4Clibrary from NJ22CONFIG: libraryPath = '%s', libraryName = '%s' \n", path, name));
                    if (path != null && name != null) {
                        try {
                            Class<?> netcdfClibraryClass = RuntimeConfigParser.class.getClassLoader().loadClass(netcdfClibraryClassName);
                            Method method = netcdfClibraryClass.getMethod("setLibraryAndPath", String.class, String.class);
                            method.invoke(null, path, name);
                        }
                        catch (Throwable e) {
                            errlog.append(netcdfClibraryClassName + " is not on classpath\n");
                        }
                    }
                    boolean useForReading = Boolean.parseBoolean(elem.getChildText("useForReading"));
                    errlog.append(String.format("    useForReading = '%s' \n", useForReading));
                    if (!useForReading) break;
                    try {
                        NetcdfFile.registerIOProvider(nc4IospClassName);
                        NetcdfFiles.registerIOProvider(nc4IospClassName);
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        errlog.append(String.format("Could not register IOSP '%s': %s%n", nc4IospClassName, e.getMessage()));
                    }
                }
            }
        }
    }
}

