/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Filter;
import ome.xml.model.FilterRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LightPath
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPath.class);
    private List<Filter> excitationFilterLinks = new ReferenceList<Filter>();
    private Dichroic dichroic;
    private List<Filter> emissionFilterLinks = new ReferenceList<Filter>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();

    public LightPath() {
    }

    public LightPath(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public LightPath(LightPath orig) {
        this.excitationFilterLinks = orig.excitationFilterLinks;
        this.dichroic = orig.dichroic;
        this.emissionFilterLinks = orig.emissionFilterLinks;
        this.annotationLinks = orig.annotationLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        List<Element> ExcitationFilterRef_nodeList = LightPath.getChildrenByTagName(element, "ExcitationFilterRef");
        for (Element element2 : ExcitationFilterRef_nodeList) {
            ExcitationFilterRef excitationFilterRef = new ExcitationFilterRef();
            excitationFilterRef.setID(element2.getAttribute("ID"));
            model.addReference(this, excitationFilterRef);
        }
        List<Element> DichroicRef_nodeList = LightPath.getChildrenByTagName(element, "DichroicRef");
        for (Element element3 : DichroicRef_nodeList) {
            DichroicRef dichroic_reference = new DichroicRef();
            dichroic_reference.setID(element3.getAttribute("ID"));
            model.addReference(this, dichroic_reference);
        }
        List<Element> list = LightPath.getChildrenByTagName(element, "EmissionFilterRef");
        for (Element EmissionFilterRef_element : list) {
            EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
            emissionFilterLinks_reference.setID(EmissionFilterRef_element.getAttribute("ID"));
            model.addReference(this, emissionFilterLinks_reference);
        }
        List<Element> list2 = LightPath.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list2) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof ExcitationFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkLightPathExcitationFilter(this);
            this.excitationFilterLinks.add(o_casted);
            return true;
        }
        if (reference instanceof DichroicRef) {
            Dichroic o_casted = (Dichroic)o;
            o_casted.linkLightPath(this);
            this.dichroic = o_casted;
            return true;
        }
        if (reference instanceof EmissionFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkLightPathEmissionFilter(this);
            this.emissionFilterLinks.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkLightPath(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public int sizeOfLinkedExcitationFilterList() {
        return this.excitationFilterLinks.size();
    }

    public List<Filter> copyLinkedExcitationFilterList() {
        return new ArrayList<Filter>(this.excitationFilterLinks);
    }

    public Filter getLinkedExcitationFilter(int index) {
        return this.excitationFilterLinks.get(index);
    }

    public Filter setLinkedExcitationFilter(int index, Filter o) {
        return this.excitationFilterLinks.set(index, o);
    }

    public boolean linkExcitationFilter(Filter o) {
        o.linkLightPathExcitationFilter(this);
        return this.excitationFilterLinks.add(o);
    }

    public boolean unlinkExcitationFilter(Filter o) {
        o.unlinkLightPathExcitationFilter(this);
        return this.excitationFilterLinks.remove(o);
    }

    public Dichroic getLinkedDichroic() {
        return this.dichroic;
    }

    public void linkDichroic(Dichroic o) {
        this.dichroic = o;
    }

    public void unlinkDichroic(Dichroic o) {
        if (this.dichroic == o) {
            this.dichroic = null;
        }
    }

    public int sizeOfLinkedEmissionFilterList() {
        return this.emissionFilterLinks.size();
    }

    public List<Filter> copyLinkedEmissionFilterList() {
        return new ArrayList<Filter>(this.emissionFilterLinks);
    }

    public Filter getLinkedEmissionFilter(int index) {
        return this.emissionFilterLinks.get(index);
    }

    public Filter setLinkedEmissionFilter(int index, Filter o) {
        return this.emissionFilterLinks.set(index, o);
    }

    public boolean linkEmissionFilter(Filter o) {
        o.linkLightPathEmissionFilter(this);
        return this.emissionFilterLinks.add(o);
    }

    public boolean unlinkEmissionFilter(Filter o) {
        o.unlinkLightPathEmissionFilter(this);
        return this.emissionFilterLinks.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkLightPath(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkLightPath(this);
        return this.annotationLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element LightPath_element) {
        Element child;
        Reference o;
        if (LightPath_element == null) {
            LightPath_element = document.createElementNS(NAMESPACE, "LightPath");
        }
        super.asXMLElement(document, LightPath_element);
        if (this.excitationFilterLinks != null) {
            for (Filter excitationFilterLinks_value : this.excitationFilterLinks) {
                o = new ExcitationFilterRef();
                ((FilterRef)o).setID(excitationFilterLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "ExcitationFilterRef");
                ((ExcitationFilterRef)o).asXMLElement(document, child);
                LightPath_element.appendChild(child);
            }
        }
        if (this.dichroic != null) {
            DichroicRef o2 = new DichroicRef();
            o2.setID(this.dichroic.getID());
            Element child2 = document.createElementNS(NAMESPACE, "DichroicRef");
            o2.asXMLElement(document, child2);
            LightPath_element.appendChild(child2);
        }
        if (this.emissionFilterLinks != null) {
            for (Filter emissionFilterLinks_value : this.emissionFilterLinks) {
                o = new EmissionFilterRef();
                ((FilterRef)o).setID(emissionFilterLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "EmissionFilterRef");
                ((EmissionFilterRef)o).asXMLElement(document, child);
                LightPath_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "AnnotationRef");
                ((AnnotationRef)o).asXMLElement(document, child);
                LightPath_element.appendChild(child);
            }
        }
        return LightPath_element;
    }
}

