/*
 * Decompiled with CFR 0.152.
 */
package ome.services.procs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ome.model.IObject;
import ome.model.jobs.Job;
import ome.model.jobs.JobStatus;
import ome.parameters.Parameters;
import ome.security.SecureAction;
import ome.security.SecuritySystem;
import ome.services.procs.IProcessManager;
import ome.services.procs.Process;
import ome.services.procs.Processor;
import ome.services.sessions.SessionManager;
import ome.services.util.ExecutionThread;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManager
extends ExecutionThread
implements IProcessManager {
    private static Logger log = LoggerFactory.getLogger(ProcessManager.class);
    private static Principal PRINCIPAL = new Principal("root", "user", "Processing");

    public ProcessManager(SessionManager manager, SecuritySystem sec, Executor executor, Processor ... procs) {
        super(manager, executor, new Work(sec, procs), PRINCIPAL);
    }

    @Override
    public void doRun() {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug("Starting processing...");
            }
            try {
                this.executor.execute(this.getPrincipal(), this.work);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error("Error while processing", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished processing...");
        }
    }

    @Override
    public Process runningProcess(long jobId) {
        Process p = ((Work)this.work).procMap.get(jobId);
        return p;
    }

    public static class Work
    implements Executor.Work {
        protected final List<Processor> processors;
        protected final SecuritySystem sec;
        protected Map<Long, Process> procMap = Collections.synchronizedMap(new HashMap());

        public Work(SecuritySystem sec, Processor ... procs) {
            this.sec = sec;
            this.processors = procs == null ? new ArrayList<Processor>() : Arrays.asList(procs);
        }

        public String description() {
            return "ProcessManager";
        }

        public List<Job> doWork(Session session, ServiceFactory sf) {
            List jobs = sf.getQueryService().findAllByQuery("select j from Job j where status.id = :id", new Parameters().addId(this.getSubmittedStatus(sf).getId()));
            for (Job job : jobs) {
                this.startProcess(sf, job.getId());
            }
            return null;
        }

        public void startProcess(final ServiceFactory sf, long jobId) {
            Processor proc;
            Process p = null;
            Iterator<Processor> iterator = this.processors.iterator();
            while (iterator.hasNext() && (p = (proc = iterator.next()).process(jobId)) == null) {
            }
            if (p == null) {
                if (log.isWarnEnabled()) {
                    log.warn("No processor found for job:" + jobId);
                }
                Job job = this.job(sf, jobId);
                job.setStatus(this.getWaitingStatus(sf));
                job.setMessage("No processor found for job.");
                this.sec.doAction(new SecureAction(){

                    @Override
                    public <T extends IObject> T updateObject(T ... objs) {
                        return (T)sf.getUpdateService().saveAndReturnObject(objs[0]);
                    }
                }, (IObject[])new Job[]{job});
            } else {
                this.procMap.put(jobId, p);
            }
        }

        protected Job job(ServiceFactory sf, long id) {
            Job job = (Job)sf.getQueryService().find(Job.class, id);
            return job;
        }

        private JobStatus getStatus(ServiceFactory sf, String status) {
            JobStatus statusObj = (JobStatus)sf.getTypesService().getEnumeration(JobStatus.class, status);
            return statusObj;
        }

        private JobStatus getSubmittedStatus(ServiceFactory sf) {
            return this.getStatus(sf, "Submitted");
        }

        private JobStatus getWaitingStatus(ServiceFactory sf) {
            return this.getStatus(sf, "Waiting");
        }
    }
}

