/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.internal.Primitive;
import ome.util.ContextFilter;
import ome.util.Filterable;
import org.hibernate.Hibernate;

public class UpdateFilter
extends ContextFilter {
    public void unloadReplacedObjects() {
        for (Object obj : this._cache.keySet()) {
            if (!this.hasReplacement(obj)) continue;
            ((IObject)obj).unload();
        }
    }

    public Object filter(String fieldId, Object o) {
        Object result;
        if (this.alreadySeen(o)) {
            return this.returnSeen(o);
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Enum) {
            result = o;
        } else if (o instanceof Primitive) {
            result = o;
        } else if (o instanceof Filterable) {
            result = this.filter(fieldId, (Filterable)o);
        } else if (o instanceof Collection) {
            result = this.filter(fieldId, (Collection)o);
        } else if (o instanceof Map) {
            result = this.filter(fieldId, (Map)o);
        } else if (o instanceof Number || o instanceof String || o instanceof Date || o instanceof Boolean || o instanceof Permissions || o instanceof byte[] || o instanceof String[] || o instanceof String[][]) {
            result = o;
        } else {
            throw new RuntimeException("Update Filter cannot allow unknown types to be saved." + o.getClass().getName() + " is not in {IObject,Collection,Map}");
        }
        return result;
    }

    public Filterable filter(String fieldId, Filterable f) {
        if (this.alreadySeen(f)) {
            return (Filterable)this.returnSeen(f);
        }
        return super.filter(fieldId, f);
    }

    public Collection filter(String fieldId, Collection c) {
        if (this.alreadySeen(c)) {
            return (Collection)this.returnSeen(c);
        }
        return super.filter(fieldId, c);
    }

    public Map filter(String fieldId, Map m) {
        if (fieldId != null && fieldId.endsWith("CountPerOwner")) {
            this.beforeFilter(fieldId, m);
            this.afterFilter(fieldId, m);
            return m;
        }
        return super.filter(fieldId, m);
    }

    protected boolean hasReplacement(Object o) {
        IObject obj;
        return o instanceof IObject && (obj = (IObject)o).getGraphHolder().getReplacement() != null;
    }

    protected boolean alreadySeen(Object o) {
        if (o == null) {
            return false;
        }
        if (!Hibernate.isInitialized((Object)o)) {
            return true;
        }
        return this.hasReplacement(o) ? true : this._cache.containsKey(o);
    }

    protected Object returnSeen(Object o) {
        if (o == null) {
            return null;
        }
        if (!Hibernate.isInitialized((Object)o)) {
            return o;
        }
        if (this.hasReplacement(o)) {
            IObject obj = (IObject)o;
            IObject replacement = obj.getGraphHolder().getReplacement();
            obj.unload();
            return replacement;
        }
        return o;
    }
}

