/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.File;
import java.util.List;
import ome.conditions.ResourceError;
import ome.io.nio.AbstractFileSystemService;
import ome.io.nio.FileBuffer;
import ome.model.core.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalFilesService
extends AbstractFileSystemService {
    private static transient Logger log = LoggerFactory.getLogger(OriginalFilesService.class);

    @Deprecated
    public OriginalFilesService(String path) {
        super(path);
    }

    public OriginalFilesService(String path, boolean isReadOnlyRepo) {
        super(path, isReadOnlyRepo);
    }

    public FileBuffer getFileBuffer(OriginalFile file, String mode) {
        String path = this.getFilesPath(file.getId());
        this.createSubpath(path);
        return new FileBuffer(path, mode);
    }

    public void removeFiles(List<Long> fileIds) {
        boolean success = false;
        for (Long id : fileIds) {
            String filePath = this.getFilesPath(id);
            File file = new File(filePath);
            if (!file.exists()) continue;
            success = file.delete();
            if (!success) {
                throw new ResourceError("File " + file.getName() + " deletion failed");
            }
            if (!log.isInfoEnabled()) continue;
            log.info("INFO: File " + file.getName() + " deleted.");
        }
    }

    public boolean exists(OriginalFile file) {
        String path = this.getFilesPath(file.getId());
        return new File(path).exists();
    }
}

