/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.view.AdvancedResultSearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultTable;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchSelectionEvent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class SearchResultView
extends JPanel {
    public static final String CONTEXT_MENU_PROPERTY = "showPopup";
    public static final String SELECTION_PROPERTY = "selected";
    private List<DataObject> objs = new ArrayList<DataObject>();
    private AdvancedResultSearchModel browserModel = null;
    private SearchResultTable objsTable;
    private Component contentPanel;

    private void initComponents(ImageDisplay root) {
        Collection<ImageDisplay> nodes = root.getChildrenDisplay();
        for (ImageDisplay node : nodes) {
            DataObject obj = (DataObject)node.getHierarchyObject();
            this.objs.add(obj);
        }
        if (this.objs.isEmpty()) {
            this.contentPanel = new JPanel();
            ((JPanel)this.contentPanel).add(new JLabel("No results found"));
        } else {
            this.objsTable = new SearchResultTable(this, this.objs, this.browserModel);
            this.contentPanel = this.objsTable;
        }
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.contentPanel), "Center");
    }

    void firePopupEvent(Point location) {
    }

    void fireSelectionEvent(List<DataObject> nodes) {
        this.firePropertyChange(SELECTION_PROPERTY, null, this.createDisplays(nodes));
        TreeViewerAgent.getRegistry().getEventBus().post(new SearchSelectionEvent(nodes));
    }

    SearchResultView(ImageDisplay root, AdvancedResultSearchModel browserModel) {
        this.browserModel = browserModel;
        this.initComponents(root);
        this.buildGUI();
    }

    void refreshTable() {
        if (this.objsTable != null) {
            this.objsTable.refreshTable();
        }
    }

    private List<ImageDisplay> createDisplays(Collection<DataObject> dataObjs) {
        ArrayList<ImageDisplay> result = new ArrayList<ImageDisplay>();
        for (DataObject dataObj : dataObjs) {
            ImageDisplay d = null;
            if (dataObj instanceof ImageData) {
                d = new ImageNode("", dataObj, null);
            } else if (dataObj instanceof ProjectData || dataObj instanceof DatasetData || dataObj instanceof ScreenData || dataObj instanceof PlateData) {
                d = new ImageSet("", dataObj);
            }
            if (d == null) continue;
            result.add(d);
        }
        return result;
    }
}

