/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import omero.log.LogMessage;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.redesign.ObjectTable;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ContentViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ModuleContentGUI
extends JPanel {
    Color color = new Color(240, 240, 240);
    private ModuleController controller;
    private LinkedHashMap<String, ObjectTable> hardwareTables;

    public ModuleContentGUI() {
        this(null, null, false);
    }

    public ModuleContentGUI(DefaultMutableTreeNode root, LinkedHashMap<String, ObjectTable> hardwareTables, boolean filterRequired) {
        this.setLayout(new BorderLayout());
        this.controller = ModuleController.getInstance();
        this.hardwareTables = hardwareTables;
        if (root != null) {
            JXTaskPaneContainer panel = new JXTaskPaneContainer();
            panel.setBackground(UIUtilities.BACKGROUND);
            if (panel.getLayout() instanceof VerticalLayout) {
                VerticalLayout vl = (VerticalLayout)panel.getLayout();
                vl.setGap(2);
            }
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (!filterRequired) {
                this.addContent(panel, root);
            } else {
                this.addFilteredContent(panel, root);
            }
            this.add((Component)panel, "Center");
        } else {
            this.add((Component)new JLabel("NO Content"), "Center");
        }
    }

    private void addFilteredContent(JXTaskPaneContainer parent, DefaultMutableTreeNode node) {
        String typec = ((ModuleTreeElement)node.getUserObject()).getType();
        if (this.controller.configurationExists(typec) && ((ModuleTreeElement)node.getUserObject()).hasRequiredData()) {
            if (node.getChildCount() > 0) {
                JXTaskPaneContainer nodeContent = new JXTaskPaneContainer();
                nodeContent.setBackground(UIUtilities.BACKGROUND);
                if (nodeContent.getLayout() instanceof VerticalLayout) {
                    VerticalLayout vl = (VerticalLayout)nodeContent.getLayout();
                    vl.setGap(2);
                }
                nodeContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                try {
                    ContentViewer taskPane = new ContentViewer(node.getUserObject().toString(), this.getHardwareTable(((ModuleTreeElement)node.getUserObject()).getType()), ((ModuleTreeElement)node.getUserObject()).getData());
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        String type = ((ModuleTreeElement)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject()).getType();
                        if (!this.controller.configurationExists(type)) continue;
                        this.addFilteredContent(nodeContent, (DefaultMutableTreeNode)node.getChildAt(i));
                    }
                    taskPane.add((Component)nodeContent);
                    parent.add((JXTaskPane)taskPane);
                }
                catch (Exception e) {
                    String s = "[MDE] can't load content of " + node.getUserObject().toString();
                    LogMessage msg = new LogMessage();
                    msg.print(s);
                    msg.print((Throwable)e);
                    ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                }
            } else {
                this.addLeafContent(parent, node);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                String type = ((ModuleTreeElement)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject()).getType();
                if (!this.controller.configurationExists(type)) continue;
                this.addFilteredContent(parent, (DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
    }

    private void addContent(JXTaskPaneContainer parent, DefaultMutableTreeNode node) {
        String typec = ((ModuleTreeElement)node.getUserObject()).getType();
        if (this.controller.configurationExists(typec)) {
            if (node.getChildCount() > 0) {
                JXTaskPaneContainer nodeContent = new JXTaskPaneContainer();
                nodeContent.setBackground(UIUtilities.BACKGROUND);
                if (nodeContent.getLayout() instanceof VerticalLayout) {
                    VerticalLayout vl = (VerticalLayout)nodeContent.getLayout();
                    vl.setGap(2);
                }
                nodeContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                try {
                    ContentViewer taskPane = new ContentViewer(node.getUserObject().toString(), this.getHardwareTable(((ModuleTreeElement)node.getUserObject()).getType()), ((ModuleTreeElement)node.getUserObject()).getData());
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        String type = ((ModuleTreeElement)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject()).getType();
                        if (!this.controller.configurationExists(type)) continue;
                        this.addContent(nodeContent, (DefaultMutableTreeNode)node.getChildAt(i));
                    }
                    taskPane.add((Component)nodeContent);
                    parent.add((JXTaskPane)taskPane);
                }
                catch (Exception e) {
                    String s = "[MDE] can't load content of " + node.getUserObject().toString();
                    LogMessage msg = new LogMessage();
                    msg.print(s);
                    msg.print((Throwable)e);
                    ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                }
            } else {
                this.addLeafContent(parent, node);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                String type = ((ModuleTreeElement)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject()).getType();
                if (!this.controller.configurationExists(type)) continue;
                this.addContent(parent, (DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
    }

    private void addLeafContent(JXTaskPaneContainer parent, DefaultMutableTreeNode node) {
        ModuleContent content = ((ModuleTreeElement)node.getUserObject()).getData();
        if (this.controller != null && content != null) {
            try {
                ContentViewer taskPane = new ContentViewer(node.getUserObject().toString(), this.getHardwareTable(((ModuleTreeElement)node.getUserObject()).getType()), content);
                parent.add((JXTaskPane)taskPane);
            }
            catch (Exception e) {
                String s = "[MDE] can't load content of " + node.getUserObject().toString();
                LogMessage msg = new LogMessage();
                msg.print(s);
                msg.print((Throwable)e);
                ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
            }
        } else {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] content of node " + node.getUserObject().toString() + " is empty [ModuleContentGUI::addLeafContent]");
        }
    }

    private ObjectTable getHardwareTable(String key) {
        if (this.hardwareTables == null) {
            return null;
        }
        if (this.hardwareTables.get(key) == null) {
            return null;
        }
        return new ObjectTable(this.hardwareTables.get(key));
    }
}

