/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.FolderData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.XMLAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class EditorDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final int CREATE_TYPE = 0;
    public static final int EDIT_TYPE = 1;
    public static final int VIEW_TYPE = 2;
    public static final String CREATE_PROPERTY = "create";
    public static final String CREATE_NO_PARENT_PROPERTY = "createNoParent";
    public static final String CLOSE_EDITOR_DIALOG_PROPERTY = "closeEditorDialog";
    private static final Dimension WIN_DIM = new Dimension(600, 300);
    private static final String TITLE = "Create";
    private static final String TITLE_EDIT = "Edit";
    private static final String TITLE_VIEW = "View";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private JTextComponent nameArea;
    private JTextArea descriptionArea;
    private JComboBox checkBox;
    private JButton cancelButton;
    private JButton saveButton;
    private Object data;
    private JRadioButton publicBox;
    private JRadioButton groupBox;
    private JRadioButton privateBox;
    private String typeName;
    private String originalText;
    private String originalDescription;
    private boolean withParent;
    private int type;

    private JPanel buildPermissions() {
        JPanel content = new JPanel();
        content.add(this.privateBox);
        content.add(this.groupBox);
        content.add(this.publicBox);
        return content;
    }

    private void initComponents() {
        this.publicBox = new JRadioButton("Public");
        this.publicBox.setEnabled(false);
        this.groupBox = new JRadioButton("Collaborative");
        this.groupBox.setEnabled(false);
        this.privateBox = new JRadioButton("Private");
        this.privateBox.setSelected(true);
        this.privateBox.setEnabled(false);
        if (this.data instanceof XMLAnnotationData || this.data instanceof String) {
            this.nameArea = new MultilineLabel();
            this.nameArea.setEditable(true);
        } else {
            this.nameArea = new JTextField();
            this.nameArea.setBorder(BorderFactory.createEtchedBorder());
        }
        this.nameArea.setName("name field");
        this.descriptionArea = new MultilineLabel();
        this.descriptionArea.setEditable(true);
        this.originalText = "";
        this.originalDescription = "";
        if (this.type == 1 || this.type == 2) {
            this.originalText = this.getDataName();
            this.originalDescription = this.getDataDescription();
            this.nameArea.setText(this.originalText);
            this.descriptionArea.setText(this.originalDescription);
            if (this.type == 1) {
                this.descriptionArea.getDocument().addDocumentListener(this);
            }
        }
        this.nameArea.getDocument().addDocumentListener(this);
        if (this.data instanceof BooleanAnnotationData) {
            this.checkBox = new JComboBox();
            this.checkBox.addItem(Boolean.TRUE.toString());
            this.checkBox.addItem(Boolean.FALSE.toString());
            this.checkBox.setSelectedItem(((BooleanAnnotationData)this.data).getValue().toString());
            this.checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditorDialog.this.enableSave();
                }
            });
        }
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setName("cancel button");
        this.cancelButton.setToolTipText("Close the dialog.");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.saveButton = new JButton(TITLE);
        this.saveButton.setName("create button");
        this.saveButton.setToolTipText("Create a new object.");
        switch (this.type) {
            case 1: {
                this.saveButton.setText("Save");
                this.saveButton.setToolTipText("Edit the object.");
                break;
            }
            case 2: {
                this.cancelButton.setText("Close");
                this.saveButton.setVisible(false);
            }
        }
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("1");
        this.saveButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                EditorDialog.this.nameArea.requestFocus();
            }
        });
    }

    private JPanel buildContentPanel() {
        JPanel content = new JPanel();
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, 5.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])tl);
        content.setLayout((LayoutManager)layout);
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        String value = ", LEFT, TOP";
        if (this.data instanceof XMLAnnotationData || this.data instanceof DoubleAnnotationData || this.data instanceof LongAnnotationData) {
            content.add((Component)UIUtilities.setTextFont("Content"), "0, 2" + value);
            content.add((Component)new JScrollPane(this.nameArea), "1, 2");
        } else if (this.data instanceof BooleanAnnotationData) {
            content.add((Component)this.checkBox, "1, 2");
        } else if (this.data instanceof String) {
            content.add((Component)new JScrollPane(this.nameArea), "1, 2");
        } else {
            content.add((Component)UIUtilities.setTextFont("Name"), "0, 0" + value);
            content.add((Component)this.nameArea, "1, 0");
            content.add((Component)UIUtilities.setTextFont("Description"), "0, 2" + value);
            content.add((Component)new JScrollPane(this.descriptionArea), "1, 2");
        }
        return content;
    }

    public JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.saveButton);
        bar.add(Box.createHorizontalStrut(10));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private TitlePanel buildTitlePanel() {
        IconManager im = IconManager.getInstance();
        TitlePanel tp = null;
        ImageIcon icon = im.getIcon(115);
        if (this.data instanceof ProjectData) {
            this.typeName = "Project";
            icon = im.getIcon(111);
        } else if (this.data instanceof DatasetData) {
            this.typeName = "Dataset";
            icon = im.getIcon(112);
        } else if (this.data instanceof ScreenData) {
            this.typeName = "Screen";
            icon = im.getIcon(114);
        } else if (this.data instanceof TagAnnotationData) {
            this.typeName = "Tag";
            icon = im.getIcon(66);
            String ns = ((TagAnnotationData)this.data).getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                this.typeName = "Tag Set";
                icon = im.getIcon(113);
            }
        } else if (this.data instanceof TermAnnotationData) {
            this.typeName = "Term";
        } else if (this.data instanceof XMLAnnotationData) {
            this.typeName = "XML";
        } else if (this.data instanceof String) {
            this.typeName = "Error";
        } else if (this.data instanceof FolderData) {
            this.typeName = "Folder";
            icon = im.getIcon(159);
        }
        switch (this.type) {
            case 0: {
                tp = new TitlePanel("Create " + this.typeName, "Create a new " + this.typeName + ".", icon);
                break;
            }
            case 1: {
                if (CommonsLangUtils.isEmpty(this.typeName)) {
                    tp = new TitlePanel("Edit value", "", icon);
                    break;
                }
                tp = new TitlePanel("Edit " + this.typeName, "Edit the " + this.typeName + ".", icon);
                break;
            }
            case 2: {
                tp = new TitlePanel("View " + this.typeName, "View the " + this.typeName + ".", icon);
            }
        }
        return tp;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)((Object)this.buildTitlePanel()), "North");
        c.add((Component)this.buildContentPanel(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void close() {
        this.firePropertyChange(CLOSE_EDITOR_DIALOG_PROPERTY, (Object)false, (Object)true);
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        String name = this.nameArea.getText();
        if (name == null) {
            return;
        }
        if ((name = name.trim()).length() == 0 && !(this.data instanceof BooleanAnnotationData)) {
            return;
        }
        if (this.data instanceof ProjectData) {
            ProjectData p = (ProjectData)this.data;
            p.setName(name);
            p.setDescription(this.descriptionArea.getText().trim());
            this.data = p;
        } else if (this.data instanceof DatasetData) {
            DatasetData d = (DatasetData)this.data;
            d.setName(name);
            d.setDescription(this.descriptionArea.getText().trim());
            this.data = d;
        } else if (this.data instanceof ScreenData) {
            ScreenData d = (ScreenData)this.data;
            d.setName(name);
            d.setDescription(this.descriptionArea.getText().trim());
            this.data = d;
        } else if (this.data instanceof TagAnnotationData) {
            TagAnnotationData d = (TagAnnotationData)this.data;
            d.setContent(name);
            String text = this.descriptionArea.getText().trim();
            if (text.length() > 0) {
                d.setTagDescription(text);
            }
            this.data = d;
        } else if (this.data instanceof XMLAnnotationData) {
            XMLAnnotationData d = (XMLAnnotationData)this.data;
            d.setContent(name);
            String text = this.descriptionArea.getText().trim();
            if (text.length() > 0) {
                d.setDescription(text);
            }
            this.data = d;
        } else if (this.data instanceof TermAnnotationData) {
            TermAnnotationData d = (TermAnnotationData)this.data;
            d.setContent(name);
            String text = this.descriptionArea.getText().trim();
            if (text.length() > 0) {
                d.setTermDescription(text);
            }
            this.data = d;
        } else if (this.data instanceof DoubleAnnotationData) {
            DoubleAnnotationData d = (DoubleAnnotationData)this.data;
            try {
                d.setDataValue(Double.parseDouble(name));
            }
            catch (NumberFormatException e) {
                MetadataViewerAgent.getRegistry().getUserNotifier().notifyError("Invalid input", "'" + name + "' is not a floating point number.");
                return;
            }
            this.data = d;
        } else if (this.data instanceof LongAnnotationData) {
            LongAnnotationData d = (LongAnnotationData)this.data;
            try {
                d.setDataValue(Long.parseLong(name));
            }
            catch (NumberFormatException e) {
                MetadataViewerAgent.getRegistry().getUserNotifier().notifyError("Invalid input", "'" + name + "' is not an integer value.");
                return;
            }
            this.data = d;
        } else if (this.data instanceof BooleanAnnotationData) {
            BooleanAnnotationData d = (BooleanAnnotationData)this.data;
            d.setValue(Boolean.parseBoolean(this.checkBox.getSelectedItem().toString()));
            this.data = d;
        } else if (this.data instanceof FolderData) {
            FolderData d = (FolderData)this.data;
            d.setName(name);
            String text = this.descriptionArea.getText().trim();
            if (text.length() > 0) {
                d.setDescription(text);
            }
            this.data = d;
        }
        if (this.withParent) {
            this.firePropertyChange(CREATE_PROPERTY, null, this.data);
        } else {
            this.firePropertyChange(CREATE_NO_PARENT_PROPERTY, null, this.data);
        }
        this.close();
    }

    private void checkData(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to create.");
        }
        if (object instanceof ProjectData || object instanceof DatasetData || object instanceof ScreenData || object instanceof TagAnnotationData || object instanceof TermAnnotationData || object instanceof XMLAnnotationData || object instanceof String || object instanceof DoubleAnnotationData || object instanceof LongAnnotationData || object instanceof BooleanAnnotationData || object instanceof FolderData) {
            return;
        }
        throw new IllegalArgumentException("Object not supported.");
    }

    private String getDataName() {
        if (this.data instanceof ProjectData) {
            return ((ProjectData)this.data).getName();
        }
        if (this.data instanceof DatasetData) {
            return ((DatasetData)this.data).getName();
        }
        if (this.data instanceof ScreenData) {
            return ((ScreenData)this.data).getName();
        }
        if (this.data instanceof TagAnnotationData || this.data instanceof TermAnnotationData || this.data instanceof XMLAnnotationData) {
            return ((AnnotationData)this.data).getContentAsString();
        }
        if (this.data instanceof DoubleAnnotationData) {
            return "" + ((DoubleAnnotationData)this.data).getDataValue();
        }
        if (this.data instanceof LongAnnotationData) {
            return "" + ((LongAnnotationData)this.data).getDataValue();
        }
        if (this.data instanceof String) {
            return this.data.toString();
        }
        if (this.data instanceof FolderData) {
            return ((FolderData)this.data).getName();
        }
        return "";
    }

    private String getDataDescription() {
        if (this.data instanceof ProjectData) {
            return ((ProjectData)this.data).getDescription();
        }
        if (this.data instanceof DatasetData) {
            return ((DatasetData)this.data).getDescription();
        }
        if (this.data instanceof ScreenData) {
            return ((ScreenData)this.data).getDescription();
        }
        if (this.data instanceof TagAnnotationData) {
            return ((TagAnnotationData)this.data).getTagDescription();
        }
        if (this.data instanceof TermAnnotationData) {
            return ((TermAnnotationData)this.data).getTermDescription();
        }
        if (this.data instanceof XMLAnnotationData) {
            return ((XMLAnnotationData)this.data).getDescription();
        }
        if (this.data instanceof String) {
            return this.data.toString();
        }
        if (this.data instanceof FolderData) {
            return ((FolderData)this.data).getDescription();
        }
        return "";
    }

    private void enableSave() {
        String name = this.nameArea.getText();
        String desc = this.descriptionArea.getText();
        if (this.type == 0) {
            if (name == null) {
                this.saveButton.setEnabled(false);
            } else {
                int l = (name = name.trim()).length();
                this.saveButton.setEnabled(l > 0);
            }
        } else if (this.type == 1) {
            if (this.data instanceof BooleanAnnotationData) {
                this.saveButton.setEnabled(!this.checkBox.getSelectedItem().toString().equals(((BooleanAnnotationData)this.data).getValue().toString()));
            } else if (!this.originalText.equals(name)) {
                int l = (name = name.trim()).length();
                this.saveButton.setEnabled(l > 0);
            } else {
                this.saveButton.setEnabled(!this.originalDescription.equals(desc = desc.trim()));
            }
        }
    }

    private void init(Object data, boolean withParent, int type) {
        switch (type) {
            case 1: {
                this.type = type;
                this.setTitle(TITLE_EDIT);
                break;
            }
            case 2: {
                this.type = type;
                this.setTitle(TITLE_VIEW);
                break;
            }
            default: {
                this.type = 0;
                this.setTitle(TITLE);
            }
        }
        this.checkData(data);
        this.data = data;
        this.withParent = withParent;
        this.initComponents();
        this.buildGUI();
        this.setName("editor dialog");
        this.setSize(WIN_DIM);
    }

    public EditorDialog(JFrame owner, DataObject data, boolean withParent, int type) {
        super(owner);
        this.init(data, withParent, type);
    }

    public EditorDialog(JFrame owner, String data, int type) {
        super(owner);
        this.init(data, this.withParent, type);
    }

    public EditorDialog(JFrame owner, DataObject data, boolean withParent) {
        this(owner, data, withParent, 0);
    }

    public EditorDialog(JDialog owner, DataObject data, boolean withParent) {
        super(owner);
        this.init(data, withParent, 0);
    }

    public void setOriginalDescription(String description) {
        if (description == null) {
            return;
        }
        this.originalDescription = description;
        this.descriptionArea.getDocument().removeDocumentListener(this);
        this.descriptionArea.setText(description);
        this.descriptionArea.getDocument().addDocumentListener(this);
    }

    public void allowEdit(boolean edit) {
        this.nameArea.setEditable(edit);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.enableSave();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.enableSave();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

