/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ThumbnailSetLoader
extends BatchCallTree {
    public static final int IMAGE = 0;
    public static final int EXPERIMENTER = 1;
    public static final int FS_FILE = 2;
    private static final int FETCH_SIZE = 10;
    private static final double FETCH_LOW_SPEED = 0.25;
    private static final double FETCH_MEDIUM_SPEED = 0.5;
    private OmeroImageService service;
    private int maxLength;
    private List<List> toHandle;
    private Map<Long, DataObject> input;
    private List notValid;
    private Object currentThumbs;
    private int fetchSize;
    private Class type;
    private SecurityContext ctx;

    private BufferedImage createDefaultImage(PixelsData pxd) {
        if (pxd == null) {
            return Factory.createDefaultImageThumbnail(-1);
        }
        Dimension d = Factory.computeThumbnailSize(this.maxLength, this.maxLength, pxd.getSizeX(), pxd.getSizeY());
        return Factory.createDefaultImageThumbnail(d.width, d.height);
    }

    private void computeFetchSize() {
        int value = -1;
        Object fSize = this.context.lookup("/services/Thumbnailing/fetchSz");
        if (fSize != null && fSize instanceof Integer) {
            value = (Integer)fSize;
        } else {
            this.context.getLogger().warn((Object)this, "Thumbnail fetching size not set");
        }
        if (value <= 0) {
            value = 10;
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        double f = 0.0;
        Object fSpeed = null;
        switch (uc.getSpeedLevel()) {
            case 1: {
                fSpeed = this.context.lookup("/services/Thumbnailing/fetchMediumSpeed");
                if (fSpeed != null && fSpeed instanceof Double) {
                    f = (Double)fSpeed;
                } else {
                    this.context.getLogger().warn((Object)this, "Thumbnail fetching factor not set");
                }
                if (f <= 0.0 || f > 1.0) {
                    f = 0.5;
                }
                this.fetchSize = (int)((double)value * f);
                break;
            }
            case 2: {
                fSpeed = this.context.lookup("/services/Thumbnailing/fetchLowSz");
                if (fSpeed != null && fSpeed instanceof Double) {
                    f = (Double)fSpeed;
                } else {
                    this.context.getLogger().warn((Object)this, "Thumbnail fetching factor not set");
                }
                if (f <= 0.0 || f > 1.0) {
                    f = 0.25;
                }
                this.fetchSize = (int)((double)value * f);
                break;
            }
            default: {
                this.fetchSize = value;
            }
        }
    }

    private void loadFSThumbnails(List files) {
        ArrayList<ThumbnailData> result = new ArrayList<ThumbnailData>();
        try {
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            long id = exp.getId();
            Map<DataObject, BufferedImage> m = this.service.getFSThumbnailSet(this.ctx, files, this.maxLength, id);
            Iterator<Map.Entry<DataObject, BufferedImage>> i = m.entrySet().iterator();
            boolean valid = true;
            while (i.hasNext()) {
                Map.Entry<DataObject, BufferedImage> entry = i.next();
                DataObject obj = entry.getKey();
                BufferedImage thumb = entry.getValue();
                if (thumb == null) {
                    thumb = Factory.createDefaultImageThumbnail(83);
                }
                if (obj.getId() > 0L) {
                    result.add(new ThumbnailData(obj.getId(), (Image)thumb, valid));
                    continue;
                }
                result.add(new ThumbnailData(obj, (Image)thumb, valid));
            }
            this.currentThumbs = result;
        }
        catch (Exception e) {
            this.currentThumbs = result;
            this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getMessage());
        }
    }

    private void loadExperimenterThumbnails(List experimenters) {
        try {
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            Map<DataObject, BufferedImage> m = this.service.getExperimenterThumbnailSet(this.ctx, experimenters, this.maxLength);
            ArrayList<ThumbnailData> result = new ArrayList<ThumbnailData>();
            Iterator<Map.Entry<DataObject, BufferedImage>> i = m.entrySet().iterator();
            boolean valid = true;
            while (i.hasNext()) {
                Map.Entry<DataObject, BufferedImage> entry = i.next();
                DataObject obj = entry.getKey();
                BufferedImage thumb = entry.getValue();
                if (thumb == null) {
                    thumb = Factory.createDefaultImageThumbnail(140);
                }
                if (obj.getId() > 0L) {
                    result.add(new ThumbnailData(obj.getId(), (Image)thumb, valid));
                    continue;
                }
                result.add(new ThumbnailData(obj, (Image)thumb, valid));
            }
            this.currentThumbs = result;
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getMessage());
        }
    }

    private void loadThumbnails(List ids) {
        try {
            Map<Long, BufferedImage> m = this.service.getThumbnailSet(this.ctx, ids, this.maxLength);
            ArrayList<ThumbnailData> result = new ArrayList<ThumbnailData>();
            Iterator<Long> i = m.keySet().iterator();
            boolean valid = true;
            long imageID = -1L;
            PixelsData pxd = null;
            while (i.hasNext()) {
                long pixelsID = i.next();
                DataObject obj = this.input.get(pixelsID);
                if (obj instanceof ImageData) {
                    imageID = ((ImageData)obj).getId();
                    pxd = ((ImageData)obj).getDefaultPixels();
                } else if (obj instanceof PixelsData) {
                    pxd = (PixelsData)obj;
                    imageID = pxd.getImage().getId();
                }
                if (pxd == null) continue;
                BufferedImage thumbPix = m.get(pixelsID);
                if (thumbPix == null) {
                    thumbPix = this.createDefaultImage(pxd);
                }
                result.add(new ThumbnailData(imageID, (Image)thumbPix, valid));
            }
            this.currentThumbs = result;
        }
        catch (RenderingServiceException e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getExtendedMessage());
        }
    }

    @Override
    protected void buildTree() {
        Iterator<List> i = this.toHandle.iterator();
        String description = "Loading collection of thumbnails";
        while (i.hasNext()) {
            List l;
            final List ids = l = i.next();
            this.add(new BatchCall(description){

                @Override
                public void doCall() {
                    if (ImageData.class.equals((Object)ThumbnailSetLoader.this.type)) {
                        ThumbnailSetLoader.this.loadThumbnails(ids);
                    } else if (FileData.class.equals((Object)ThumbnailSetLoader.this.type)) {
                        ThumbnailSetLoader.this.loadFSThumbnails(ids);
                    } else if (ExperimenterData.class.equals((Object)ThumbnailSetLoader.this.type)) {
                        ThumbnailSetLoader.this.loadExperimenterThumbnails(ids);
                    }
                }
            });
        }
        this.currentThumbs = this.notValid;
    }

    @Override
    protected Object getPartialResult() {
        return this.currentThumbs;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ThumbnailSetLoader(SecurityContext ctx, Collection<DataObject> images, int maxLength, int nodeType) {
        if (images == null) {
            throw new NullPointerException("No images.");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Non-positive height: " + maxLength + ".");
        }
        this.computeFetchSize();
        this.ctx = ctx;
        this.maxLength = maxLength;
        this.service = this.context.getImageService();
        this.toHandle = new ArrayList<List>();
        this.input = new HashMap<Long, DataObject>();
        this.notValid = new ArrayList();
        Iterator<DataObject> i = images.iterator();
        int index = 0;
        ArrayList<Object> l = null;
        PixelsData pxd = null;
        while (i.hasNext()) {
            DataObject object = i.next();
            if (object instanceof ImageData) {
                if (nodeType == 2) {
                    this.input.put(object.getId(), object);
                    this.type = FileData.class;
                    if (index == 0) {
                        l = new ArrayList<Object>();
                    }
                    if (index >= this.fetchSize) continue;
                    l.add(object);
                    if (++index != this.fetchSize) continue;
                    this.toHandle.add(l);
                    index = 0;
                    l = null;
                    continue;
                }
                ImageData img = (ImageData)object;
                this.type = ImageData.class;
                try {
                    pxd = img.getDefaultPixels();
                    this.input.put(pxd.getId(), img);
                    if (index == 0) {
                        l = new ArrayList();
                    }
                    if (index >= this.fetchSize) continue;
                    l.add(pxd.getId());
                    if (++index != this.fetchSize) continue;
                    this.toHandle.add(l);
                    index = 0;
                    l = null;
                }
                catch (Exception e) {
                    this.notValid.add(new ThumbnailData(img.getId(), (Image)this.createDefaultImage(pxd), false));
                }
                continue;
            }
            if (object instanceof FileData) {
                this.input.put(object.getId(), object);
                this.type = FileData.class;
                if (index == 0) {
                    l = new ArrayList();
                }
                if (index >= this.fetchSize) continue;
                l.add(object);
                if (++index != this.fetchSize) continue;
                this.toHandle.add(l);
                index = 0;
                l = null;
                continue;
            }
            if (object instanceof ExperimenterData) {
                this.input.put(object.getId(), object);
                this.type = ExperimenterData.class;
                if (index == 0) {
                    l = new ArrayList();
                }
                if (index >= this.fetchSize) continue;
                l.add(object);
                if (++index != this.fetchSize) continue;
                this.toHandle.add(l);
                index = 0;
                l = null;
                continue;
            }
            if (!(object instanceof PixelsData)) continue;
            pxd = (PixelsData)object;
            this.type = ImageData.class;
            this.input.put(pxd.getId(), pxd);
            if (index == 0) {
                l = new ArrayList();
            }
            if (index >= this.fetchSize) continue;
            l.add(pxd.getId());
            if (++index != this.fetchSize) continue;
            this.toHandle.add(l);
            index = 0;
            l = null;
        }
        if (l != null && l.size() > 0) {
            this.toHandle.add(l);
        }
    }
}

