/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class NotificationDialog
extends JDialog {
    public static final String HYPERLINK_OPEN_PROPERTY = "hyperlinkOpen";
    public static final String CLOSE_NOTIFICATION_PROPERTY = "closeNotification";
    public static final String CANCEL_NOTIFICATION_PROPERTY = "cancelNotification";
    protected static final Dimension MSG_AREA_SIZE = new Dimension(300, 50);
    protected static final Dimension H_SPACER_SIZE = new Dimension(20, 1);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    protected JXHeader contentPanel;
    protected JPanel messagePanel;
    protected JPanel controlsPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    private JPanel mainPanel;
    protected String message;
    protected WindowAdapter windowAdapter;

    private void createComponents() {
        this.mainPanel = new JPanel();
        this.contentPanel = new JXHeader();
        this.contentPanel.setBackgroundPainter((Painter)new RectanglePainter(this.getBackground(), null));
        this.messagePanel = new JPanel();
        this.messagePanel.setOpaque(true);
        this.controlsPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setVisible(false);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void attachListeners() {
        this.windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                NotificationDialog.this.close();
            }
        };
        this.addWindowListener(this.windowAdapter);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationDialog.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationDialog.this.cancel();
            }
        });
    }

    protected void cancel() {
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange(CANCEL_NOTIFICATION_PROPERTY, (Object)false, (Object)true);
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange(CLOSE_NOTIFICATION_PROPERTY, (Object)false, (Object)true);
    }

    private JPanel buildCommentPanel(String msg, Icon icon) {
        this.contentPanel.setDescription(msg);
        this.contentPanel.setOpaque(false);
        if (icon != null) {
            this.contentPanel.setIcon(icon);
            this.contentPanel.setIconPosition(JXHeader.IconPosition.LEFT);
        }
        return this.contentPanel;
    }

    private JPanel buildControlPanel() {
        this.controlsPanel.setBorder(null);
        this.controlsPanel.add(this.cancelButton);
        this.controlsPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.controlsPanel.add(this.okButton);
        this.controlsPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(this.controlsPanel);
    }

    private JEditorPane buildHTMLPane(String message) {
        JEditorPane htmlPane = UIUtilities.buildTextEditorPane(message);
        htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
                    NotificationDialog.this.firePropertyChange(NotificationDialog.HYPERLINK_OPEN_PROPERTY, null, url);
                }
            }
        });
        return htmlPane;
    }

    private void buildGUI(String message, Icon messageIcon, boolean html) {
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridy = 0;
        if (html) {
            this.mainPanel.add((Component)this.buildHTMLPane(message), c);
        } else {
            this.mainPanel.add((Component)this.buildCommentPanel(message, messageIcon), c);
        }
        ++c.gridy;
        this.mainPanel.add(Box.createVerticalStrut(5), c);
        ++c.gridy;
        this.mainPanel.add((Component)this.buildControlPanel(), c);
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void initiliaze(String message, Icon messageIcon, boolean html) {
        this.message = message;
        this.createComponents();
        this.attachListeners();
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.buildGUI(message, messageIcon, html);
        this.pack();
    }

    public NotificationDialog(JFrame owner, String title, String message, Icon messageIcon) {
        super((Frame)owner, title);
        this.initiliaze(message, messageIcon, false);
    }

    public NotificationDialog(JDialog owner, String title, String message, Icon messageIcon) {
        super((Dialog)owner, title);
        this.initiliaze(message, messageIcon, false);
    }

    public NotificationDialog(String title, String message, Icon messageIcon) {
        this.setTitle(title);
        this.initiliaze(message, messageIcon, false);
    }

    public NotificationDialog(JDialog owner, String title, String message, boolean html) {
        super((Dialog)owner, title);
        this.initiliaze(message, null, html);
    }

    public NotificationDialog(JFrame owner, String title, String message, boolean html) {
        super((Frame)owner, title);
        this.initiliaze(message, null, html);
    }
}

