/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.PopupHint;

public class NumericalTextField
extends JTextField
implements DocumentListener,
FocusListener {
    public static final String TEXT_UPDATED_PROPERTY = "textUpdated";
    public static final int VALIDATION_MODE_BLOCK = 0;
    public static final int VALIDATION_MODE_CORRECT = 1;
    private static final String NUMERIC = "0123456789";
    private static final String FLOAT = "0123456789.";
    private Color editedColor;
    private Color defaultForeground;
    private NumericalPlainDocument document;
    private String originalText;
    private Class<?> numberType;
    private boolean negativeAccepted;
    private String accepted;
    private boolean showWarning = false;

    private String checkValue() {
        String str = this.getText();
        Object result = str;
        try {
            if (Integer.class.equals(this.numberType)) {
                int val;
                int min = (int)this.getMinimum();
                int max = (int)this.getMaximum();
                if (CommonsLangUtils.isBlank(str)) {
                    result = "" + min;
                }
                if ((val = Integer.parseInt(str)) < min) {
                    result = "" + min;
                }
                if (val > max) {
                    result = "" + max;
                }
            } else if (Double.class.equals(this.numberType)) {
                Double min = this.getMinimum();
                Double max = this.getMaximum();
                if (CommonsLangUtils.isBlank(str)) {
                    return "" + min;
                }
                double val = Double.parseDouble(str);
                if (val < min) {
                    result = "" + min;
                }
                if (val > max) {
                    result = "" + max;
                }
            } else if (Long.class.equals(this.numberType)) {
                long val;
                Long min = new Long((long)this.getMinimum());
                Long max = new Long((long)this.getMaximum());
                if (CommonsLangUtils.isBlank(str)) {
                    result = "" + min;
                }
                if ((val = Long.parseLong(str)) < min) {
                    result = "" + min;
                }
                if (val > max) {
                    result = "" + max;
                }
            } else if (Float.class.equals(this.numberType)) {
                float val;
                Float min = new Float(this.getMinimum());
                Float max = new Float(this.getMaximum());
                if (CommonsLangUtils.isBlank(str)) {
                    result = "" + min;
                }
                if ((val = Float.parseFloat(str)) < min.floatValue()) {
                    result = "" + min;
                }
                if (val > max.floatValue()) {
                    result = "" + max;
                }
            }
        }
        catch (NumberFormatException nfe) {
            String msg = "The value you entered is not a valid number";
            PopupHint hint = new PopupHint(this, msg, 8000);
            hint.show();
            return "";
        }
        if (!((String)result).equals(str) && this.showWarning) {
            String msg = "<html>The value you entered is outside of the allowed range,<br>therefore it is reset to the minimal/maximal allowed value.</hmtl>";
            PopupHint hint = new PopupHint(this, msg, 8000);
            hint.show();
        }
        return result;
    }

    private void updateForeGround() {
        String text = this.getText();
        if (this.editedColor != null && this.originalText != null) {
            if (this.originalText.equals(text)) {
                this.setForeground(this.defaultForeground);
            } else {
                this.setForeground(this.editedColor);
            }
        }
        if (this.originalText == null) {
            this.originalText = text;
            this.defaultForeground = this.getForeground();
        }
        this.firePropertyChange(TEXT_UPDATED_PROPERTY, (Object)false, (Object)true);
    }

    public NumericalTextField() {
        this(0.0, 2.147483647E9);
    }

    public NumericalTextField(double min, double max) {
        this(min, max, Integer.class);
    }

    public NumericalTextField(double min, double max, Class<?> type) {
        this(min, max, type, 1);
    }

    public NumericalTextField(double min, double max, Class<?> type, int validationMode) {
        boolean blockInput = validationMode == 0;
        this.document = new NumericalPlainDocument(min, max, blockInput);
        this.setHorizontalAlignment(4);
        this.setDocument(this.document);
        this.originalText = null;
        this.editedColor = null;
        this.document.addDocumentListener(this);
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String s = NumericalTextField.this.getText();
                    String v = NumericalTextField.this.checkValue();
                    if (v != null && !v.equals(s)) {
                        NumericalTextField.this.setText(v);
                    }
                }
            }
        });
        this.numberType = type;
        this.accepted = Integer.class.equals(type) || Long.class.equals(type) ? NUMERIC : FLOAT;
        this.setNegativeAccepted(min < 0.0);
    }

    public void setNegativeAccepted(boolean negativeAccepted) {
        this.negativeAccepted = negativeAccepted;
        if (negativeAccepted) {
            this.accepted = this.accepted + "-";
            double min = this.document.getMinimum();
            if (min >= 0.0) {
                min = this.numberType == null || Integer.class.equals(this.numberType) ? -2.147483648E9 : (Long.class.equals(this.numberType) ? -9.223372036854776E18 : (Float.class.equals(this.numberType) ? (double)1.4E-45f : Double.MIN_VALUE));
                this.document.setMinimum(min);
            }
        }
    }

    public boolean isNegativeAccepted() {
        return this.negativeAccepted;
    }

    public void setNumberType(Class<?> numberType) {
        if (numberType == null) {
            numberType = Integer.class;
        }
        this.numberType = numberType;
        this.accepted = numberType.equals(Integer.class) || numberType.equals(Long.class) ? NUMERIC : FLOAT;
        this.setNegativeAccepted(this.negativeAccepted);
        if (numberType.equals(Double.class)) {
            this.setMinimum(0.0);
            this.setMaximum(Double.MAX_VALUE);
        } else if (numberType.equals(Float.class)) {
            this.setMinimum(0.0);
            this.setMaximum(3.4028234663852886E38);
        } else if (numberType.equals(Long.class)) {
            this.setMinimum(0.0);
            this.setMaximum(9.223372036854776E18);
        }
    }

    public void setMinimum(double min) {
        this.document.setMinimum(min);
        if (min < 0.0) {
            this.setNegativeAccepted(true);
        }
    }

    public void setMaximum(double max) {
        this.document.setMaximum(max);
    }

    public double getMaximum() {
        return this.document.getMaximum();
    }

    public double getMinimum() {
        return this.document.getMinimum();
    }

    public void setEditedColor(Color editedColor) {
        this.editedColor = editedColor;
    }

    public Number getValueAsNumber() {
        String str = this.getText();
        if (CommonsLangUtils.isBlank(str)) {
            return null;
        }
        str = this.checkValue();
        if (Integer.class.equals(this.numberType)) {
            return Integer.parseInt(str);
        }
        if (Double.class.equals(this.numberType)) {
            return Double.parseDouble(str);
        }
        if (Float.class.equals(this.numberType)) {
            return Float.valueOf(Float.parseFloat(str));
        }
        if (Long.class.equals(this.numberType)) {
            return Long.parseLong(str);
        }
        return null;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateForeGround();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateForeGround();
    }

    @Override
    public void focusLost(FocusEvent e) {
        String v;
        Object s = this.getText();
        if (s != null && ((String)s).endsWith(".")) {
            s = (String)s + "0";
            this.setText((String)s);
        }
        if ((v = this.checkValue()) != null && !v.equals(s)) {
            this.setText(v);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    class NumericalPlainDocument
    extends PlainDocument {
        private double min;
        private double max;
        private boolean blockOutOfRangeInput;

        private boolean isInRange(String str) {
            try {
                if (Integer.class.equals(NumericalTextField.this.numberType)) {
                    int val = Integer.parseInt(str);
                    int mx = (int)this.max;
                    int mi = (int)this.min;
                    return val >= mi && val <= mx;
                }
                if (Double.class.equals(NumericalTextField.this.numberType)) {
                    double val = Double.parseDouble(str);
                    return val >= this.min && val <= this.max;
                }
                if (Long.class.equals(NumericalTextField.this.numberType)) {
                    long val = Long.parseLong(str);
                    long mx = (long)this.max;
                    long mi = (long)this.min;
                    return val >= mi && val <= mx;
                }
                if (Float.class.equals(NumericalTextField.this.numberType)) {
                    float val = Float.parseFloat(str);
                    return (double)val >= this.min && (double)val <= this.max;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return false;
        }

        NumericalPlainDocument(double min, double max, boolean blockOutOfRangeInput) {
            this.min = min;
            this.max = max;
            this.blockOutOfRangeInput = blockOutOfRangeInput;
        }

        void setMinimum(double min) {
            this.min = min;
        }

        void setMaximum(double max) {
            this.max = max;
        }

        double getMinimum() {
            return this.min;
        }

        double getMaximum() {
            return this.max;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            try {
                if (str == null) {
                    return;
                }
                for (int i = 0; i < str.length(); ++i) {
                    if (NumericalTextField.this.accepted.indexOf(String.valueOf(str.charAt(i))) != -1) continue;
                    return;
                }
                if ((NumericalTextField.this.accepted.equals(NumericalTextField.FLOAT) || NumericalTextField.this.accepted.equals("0123456789.-") && NumericalTextField.this.negativeAccepted) && str.indexOf(".") != -1 && this.getText(0, this.getLength()).indexOf(".") != -1) {
                    return;
                }
                if (NumericalTextField.this.negativeAccepted && str.indexOf("-") != -1 && (str.indexOf("-") != 0 || offset != 0)) {
                    return;
                }
                if (str.equals(".") && NumericalTextField.this.accepted.equals(NumericalTextField.FLOAT)) {
                    super.insertString(offset, str, a);
                } else if (str.equals("-") && NumericalTextField.this.negativeAccepted) {
                    super.insertString(offset, str, a);
                } else {
                    Object s = this.getText(0, this.getLength());
                    s = (String)s + str;
                    if (!this.blockOutOfRangeInput || this.isInRange((String)s)) {
                        super.insertString(offset, str, a);
                    }
                }
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

