/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SeparatorBorder
extends AbstractBorder {
    private static Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    private Insets insets = new Insets(2, 2, 2, 2);
    private Color lineColor;

    public SeparatorBorder() {
        this(DEFAULT_COLOR);
    }

    public SeparatorBorder(Color lineColor) {
        if (lineColor == null) {
            lineColor = DEFAULT_COLOR;
        }
        this.lineColor = lineColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color originalColor = g.getColor();
        g.setColor(this.lineColor);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.setColor(originalColor);
    }
}

