/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.tpane.TinyObserver;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

class ViewModeButton
extends JButton
implements TinyObserver,
PropertyChangeListener,
ActionListener {
    static final String SINGLE_VIEW_TOOLTIP = "Switch to single-view mode: view one item at a time.";
    static final String MULTI_VIEW = "Multi-view Mode";
    static final String DROP_DOWN_TOOLTIP = "List all contained items.";
    private TinyPane model;
    private JPopupMenu dropDownMenu;

    private void initDropDownMenu() {
        IconManager icons = IconManager.getInstance();
        JMenuItem switchItem = new JMenuItem(MULTI_VIEW, icons.getIcon(48));
        this.dropDownMenu.add(switchItem);
        switchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ViewModeButton.this.model.setSingleViewMode(false);
            }
        });
    }

    private void clearDropDownMenu() {
        int items = this.dropDownMenu.getComponentCount();
        while (1 < items) {
            this.dropDownMenu.remove(--items);
        }
    }

    private void displayMenu() {
        Component[] comp;
        String title;
        this.clearDropDownMenu();
        Component curView = this.model.getChildView();
        if (curView != null) {
            title = curView.getName();
            if (curView instanceof TinyPane) {
                title = ((TinyPane)curView).getTitle();
            }
            JCheckBoxMenuItem cvi = new JCheckBoxMenuItem(title);
            cvi.setSelected(true);
            this.dropDownMenu.add(cvi);
        }
        if (0 < (comp = this.model.getInternalDesktop().getComponents()).length) {
            String[] items = new String[comp.length];
            this.dropDownMenu.add(new JSeparator(0));
            for (int i = 0; i < comp.length; ++i) {
                Component child = comp[i];
                title = child.getName();
                if (child instanceof TinyPane) {
                    title = ((TinyPane)child).getTitle();
                }
                items[i] = title;
            }
            JList<String> list = new JList<String>(items);
            list.setSelectionMode(1);
            list.getSelectionModel().addListSelectionListener(new ListListener(list));
            list.setLayoutOrientation(0);
            JScrollPane sp = new JScrollPane(list);
            JMenu selectMenu = new JMenu("Select");
            list.setBackground(selectMenu.getBackground());
            selectMenu.add(sp);
            this.dropDownMenu.add(selectMenu);
        }
        Dimension d = this.getPreferredSize();
        this.dropDownMenu.show(this, 0, d.height);
    }

    ViewModeButton(TinyPane model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.dropDownMenu = new JPopupMenu();
        this.initDropDownMenu();
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
    }

    @Override
    public void attach() {
        this.addActionListener(this);
        this.model.addPropertyChangeListener("singleViewMode", this);
        this.propertyChange(null);
    }

    @Override
    public void detach() {
        this.model.removePropertyChangeListener("singleViewMode", this);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        IconManager icons = IconManager.getInstance();
        if (this.model.isSingleViewMode()) {
            this.setIcon(icons.getIcon(49));
            this.setRolloverIcon(icons.getIcon(50));
            this.setToolTipText(DROP_DOWN_TOOLTIP);
        } else {
            this.setIcon(icons.getIcon(46));
            this.setRolloverIcon(icons.getIcon(47));
            this.setToolTipText(SINGLE_VIEW_TOOLTIP);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.model.isSingleViewMode()) {
            this.displayMenu();
        } else {
            this.model.setSingleViewMode(true);
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private JList list;

        ListListener(JList list) {
            if (list == null) {
                throw new IllegalArgumentException("no list specified");
            }
            this.list = list;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                return;
            }
            int index = this.list.getSelectedIndex();
            Component child = ViewModeButton.this.model.getInternalDesktop().getComponent(index);
            ViewModeButton.this.model.setChildView(child);
            ViewModeButton.this.dropDownMenu.setVisible(false);
        }
    }
}

