/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert.figures;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectorHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.GraphicalCompositeFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ListFigure;
import org.jhotdraw.draw.LocatorConnector;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.VerticalLayouter;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.samples.pert.figures.DependencyFigure;
import org.jhotdraw.samples.pert.figures.SeparatorLineFigure;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFigure
extends GraphicalCompositeFigure {
    private HashSet<DependencyFigure> dependencies;
    private int startTime;

    public TaskFigure() {
        super(new RectangleFigure());
        this.setLayouter(new VerticalLayouter());
        RectangleFigure nameCompartmentPF = new RectangleFigure();
        AttributeKeys.STROKE_COLOR.basicSet(nameCompartmentPF, null);
        nameCompartmentPF.setAttributeEnabled(AttributeKeys.STROKE_COLOR, false);
        AttributeKeys.FILL_COLOR.basicSet(nameCompartmentPF, null);
        nameCompartmentPF.setAttributeEnabled(AttributeKeys.FILL_COLOR, false);
        ListFigure nameCompartment = new ListFigure(nameCompartmentPF);
        ListFigure attributeCompartment = new ListFigure();
        SeparatorLineFigure separator1 = new SeparatorLineFigure();
        this.applyAttributes(this.getPresentationFigure());
        this.add(nameCompartment);
        this.add(separator1);
        this.add(attributeCompartment);
        Insets2D.Double insets = new Insets2D.Double(4.0, 8.0, 4.0, 8.0);
        LAYOUT_INSETS.basicSet(nameCompartment, insets);
        LAYOUT_INSETS.basicSet(attributeCompartment, insets);
        TextFigure nameFigure = new TextFigure();
        nameCompartment.add(nameFigure);
        AttributeKeys.FONT_BOLD.basicSet(nameFigure, true);
        nameFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        TextFigure durationFigure = new TextFigure();
        attributeCompartment.add(durationFigure);
        AttributeKeys.FONT_BOLD.basicSet(durationFigure, true);
        durationFigure.setText("0");
        durationFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        TextFigure startTimeFigure = new TextFigure();
        attributeCompartment.add(startTimeFigure);
        startTimeFigure.setEditable(false);
        startTimeFigure.setText("0");
        startTimeFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        this.applyAttributes(this);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.pert.Labels");
        this.setName(labels.getString("taskDefaultName"));
        this.setDuration(0);
        this.startTime = 0;
        this.dependencies = new HashSet();
        nameFigure.addFigureListener(new NameAdapter(this));
        durationFigure.addFigureListener(new DurationAdapter(this));
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeLocator.southWest()));
            handles.add(new MoveHandle(this, RelativeLocator.southEast()));
            handles.add(new ConnectorHandle(new LocatorConnector(this, RelativeLocator.east()), new DependencyFigure()));
        }
        return handles;
    }

    public void setName(String newValue) {
        this.getNameFigure().setText(newValue);
    }

    public String getName() {
        return this.getNameFigure().getText();
    }

    public void setDuration(int newValue) {
        int oldValue = this.getDuration();
        this.getDurationFigure().setText(Integer.toString(newValue));
        if (oldValue != newValue) {
            for (TaskFigure succ : this.getSuccessors()) {
                succ.updateStartTime();
            }
        }
    }

    public int getDuration() {
        try {
            return Integer.valueOf(this.getDurationFigure().getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void updateStartTime() {
        this.willChange();
        int oldValue = this.getStartTime();
        int newValue = 0;
        for (TaskFigure pre : this.getPredecessors()) {
            newValue = Math.max(newValue, pre.getStartTime() + pre.getDuration());
        }
        this.getStartTimeFigure().setText(Integer.toString(newValue));
        if (newValue != oldValue) {
            for (TaskFigure succ : this.getSuccessors()) {
                if (this.isDependentOf(succ)) continue;
                succ.updateStartTime();
            }
        }
        this.changed();
    }

    public int getStartTime() {
        try {
            return Integer.valueOf(this.getStartTimeFigure().getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private TextFigure getNameFigure() {
        return (TextFigure)((ListFigure)this.getChild(0)).getChild(0);
    }

    private TextFigure getDurationFigure() {
        return (TextFigure)((ListFigure)this.getChild(2)).getChild(0);
    }

    private TextFigure getStartTimeFigure() {
        return (TextFigure)((ListFigure)this.getChild(2)).getChild(1);
    }

    private void applyAttributes(Figure f) {
        Map<AttributeKey, Object> attr = ((AbstractAttributedFigure)this.getPresentationFigure()).getAttributes();
        for (Map.Entry<AttributeKey, Object> entry : attr.entrySet()) {
            entry.getKey().basicSet(f, entry.getValue());
        }
    }

    @Override
    public TaskFigure clone() {
        TaskFigure that = (TaskFigure)super.clone();
        that.dependencies = new HashSet();
        that.getNameFigure().addFigureListener(new NameAdapter(that));
        that.getDurationFigure().addFigureListener(new DurationAdapter(that));
        that.updateStartTime();
        return that;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0.0);
        double y = in.getAttribute("y", 0.0);
        double w = in.getAttribute("w", 0.0);
        double h = in.getAttribute("h", 0.0);
        this.setBounds(new Point2D.Double(x, y), new Point2D.Double(x + w, y + h));
        this.readAttributes(in);
        in.openElement("model");
        in.openElement("name");
        this.setName((String)in.readObject());
        in.closeElement();
        in.openElement("duration");
        this.setDuration((Integer)in.readObject());
        in.closeElement();
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = this.getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        this.writeAttributes(out);
        out.openElement("model");
        out.openElement("name");
        out.writeObject(this.getName());
        out.closeElement();
        out.openElement("duration");
        out.writeObject(this.getDuration());
        out.closeElement();
        out.closeElement();
    }

    @Override
    public int getLayer() {
        return 0;
    }

    public Set<DependencyFigure> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public void addDependency(DependencyFigure f) {
        this.dependencies.add(f);
        this.updateStartTime();
    }

    public void removeDependency(DependencyFigure f) {
        this.dependencies.remove(f);
        this.updateStartTime();
    }

    public List<TaskFigure> getSuccessors() {
        LinkedList<TaskFigure> list = new LinkedList<TaskFigure>();
        for (DependencyFigure c : this.getDependencies()) {
            if (c.getStartFigure() != this) continue;
            list.add((TaskFigure)c.getEndFigure());
        }
        return list;
    }

    public List<TaskFigure> getPredecessors() {
        LinkedList<TaskFigure> list = new LinkedList<TaskFigure>();
        for (DependencyFigure c : this.getDependencies()) {
            if (c.getEndFigure() != this) continue;
            list.add((TaskFigure)c.getStartFigure());
        }
        return list;
    }

    public boolean isDependentOf(TaskFigure t) {
        if (this == t) {
            return true;
        }
        for (TaskFigure pre : this.getPredecessors()) {
            if (!pre.isDependentOf(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "TaskFigure#" + this.hashCode() + " " + this.getName() + " " + this.getDuration() + " " + this.getStartTime();
    }

    private static class DurationAdapter
    extends FigureAdapter {
        private TaskFigure target;

        public DurationAdapter(TaskFigure target) {
            this.target = target;
        }

        public void figureAttributeChanged(FigureEvent evt) {
            for (TaskFigure succ : this.target.getSuccessors()) {
                succ.updateStartTime();
            }
        }
    }

    private static class NameAdapter
    extends FigureAdapter {
        private TaskFigure target;

        public NameAdapter(TaskFigure target) {
            this.target = target;
        }

        public void figureAttributeChanged(FigureEvent e) {
        }
    }
}

