/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.meta.ExperimenterGroup;
import ome.security.AdminAction;
import ome.security.SecureAction;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.Roles;

public interface SecuritySystem {
    public void login(Principal var1);

    public int logout();

    public EventContext getEventContext();

    public Long getEffectiveUID();

    public EventContext getEventContext(boolean var1);

    public void loadEventContext(boolean var1);

    public void invalidateEventContext();

    public boolean isReady();

    public boolean isSystemType(Class<? extends IObject> var1);

    public boolean hasPrivilegedToken(IObject var1);

    public void checkRestriction(String var1, IObject var2) throws SecurityViolation;

    public void disable(String ... var1);

    public void enable(String ... var1);

    public boolean isDisabled(String var1);

    public boolean isGraphCritical(Details var1);

    public Details newTransientDetails(IObject var1) throws ApiUsageException, SecurityViolation;

    public Details checkManagedDetails(IObject var1, Details var2) throws ApiUsageException, SecurityViolation;

    public void runAsAdmin(ExperimenterGroup var1, AdminAction var2);

    public void runAsAdmin(AdminAction var1);

    public <T extends IObject> T doAction(SecureAction var1, T ... var2);

    public Roles getSecurityRoles();
}

