/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.spring;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class OnContextRefreshedEventListener
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext ctx;
    private final boolean handleOthers;
    private final int limit;
    private final AtomicInteger count = new AtomicInteger(0);

    public OnContextRefreshedEventListener() {
        this(false, 1);
    }

    public OnContextRefreshedEventListener(boolean handleOthers, int limit) {
        this.handleOthers = handleOthers;
        this.limit = limit;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() != this.ctx && !this.handleOthers) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring other application context refresh: " + this.ctx);
            }
            return;
        }
        int current = this.count.incrementAndGet();
        if (current > this.limit) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring refresh beyond limit: " + current);
            }
            return;
        }
        this.handleContextRefreshedEvent(event);
    }

    public abstract void handleContextRefreshedEvent(ContextRefreshedEvent var1);
}

