/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class MDLongArray
extends MDAbstractArray<Long> {
    private static final long serialVersionUID = 1L;
    private long[] flattenedArray;

    public MDLongArray(long[] dimensions) {
        this(new long[MDLongArray.getLength(dimensions, 0L)], MDLongArray.toInt(dimensions), false);
    }

    public MDLongArray(long[] dimensions, long capacityHyperRows) {
        this(new long[MDLongArray.getLength(dimensions, capacityHyperRows)], MDLongArray.toInt(dimensions), false);
    }

    public MDLongArray(long[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDLongArray.toInt(dimensions), true);
    }

    public MDLongArray(long[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDLongArray.toInt(dimensions), checkdimensions);
    }

    public MDLongArray(int[] dimensions) {
        this(new long[MDLongArray.getLength(dimensions, 0)], dimensions, false);
    }

    public MDLongArray(int[] dimensions, int capacityHyperRows) {
        this(new long[MDLongArray.getLength(dimensions, capacityHyperRows)], dimensions, false);
    }

    public MDLongArray(long[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDLongArray(long[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDLongArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    public MDLongArray(long[][] matrix) {
        this(matrix, MDLongArray.getDimensions(matrix));
    }

    public MDLongArray(long[][] matrix, int[] dimensions) {
        super(dimensions, 0, matrix.length);
        int sizeX = dimensions[0];
        int sizeY = dimensions[1];
        int length = MDLongArray.getLength(dimensions, 0);
        this.flattenedArray = new long[length];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(matrix[i], 0, this.flattenedArray, i * sizeY, sizeY);
            ++i;
        }
    }

    public MDLongArray(MDLongArray template) {
        super(template);
        this.flattenedArray = (long[])template.flattenedArray.clone();
    }

    private static int[] getDimensions(long[][] matrix) {
        assert (matrix != null);
        return new int[]{matrix.length, matrix.length == 0 ? 0 : matrix[0].length};
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public Long getAsObject(int ... indices) {
        return this.get(indices);
    }

    @Override
    public void setToObject(Long value, int ... indices) {
        this.set((long)value, indices);
    }

    @Override
    public Long getAsObject(int linearIndex) {
        return this.get(linearIndex);
    }

    @Override
    public void setToObject(Long value, int linearIndex) {
        this.set((long)value, linearIndex);
    }

    public long[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public long[] getCopyAsFlatArray() {
        return ArrayUtils.subarray((long[])this.flattenedArray, (int)0, (int)(this.dimensions[0] * this.hyperRowLength));
    }

    @Override
    protected void adaptCapacityHyperRows() {
        long[] oldArray = this.flattenedArray;
        this.flattenedArray = new long[this.capacityHyperRows * this.hyperRowLength];
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    public long get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public long get(int index) {
        return this.flattenedArray[index];
    }

    public long get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public long get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(long value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(long value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(long value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(long value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public long[][] toMatrix() {
        int sizeX = this.dimensions[0];
        int sizeY = this.dimensions[1];
        long[][] result = new long[sizeX][sizeY];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(this.flattenedArray, i * sizeY, result[i], 0, sizeY);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDLongArray other = (MDLongArray)obj;
        if (!Arrays.equals(this.getValuesAsFlatArray(), other.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private long[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }

    public MDLongArray clone() {
        return new MDLongArray(this);
    }
}

