/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import java.util.Objects;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.ConicProjection;
import org.locationtech.proj4j.util.ProjectionMath;

public class SimpleConicProjection
extends ConicProjection {
    private double n;
    private double rho_c;
    private double rho_0;
    private double sig;
    private double c1;
    private double c2;
    private int type;
    public static final int EULER = 0;
    public static final int MURD1 = 1;
    public static final int MURD2 = 2;
    public static final int MURD3 = 3;
    public static final int PCONIC = 4;
    public static final int TISSOT = 5;
    public static final int VITK1 = 6;
    private static final double EPS10 = 1.0E-10;
    private static final double EPS = 1.0E-10;

    public SimpleConicProjection() {
        this(0);
    }

    public SimpleConicProjection(int type) {
        this.type = type;
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(80.0);
    }

    @Override
    public String toString() {
        return "Simple Conic";
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double rho;
        switch (this.type) {
            case 2: {
                rho = this.rho_c + Math.tan(this.sig - lpphi);
                break;
            }
            case 4: {
                rho = this.c2 * (this.c1 - Math.tan(lpphi - this.sig));
                break;
            }
            default: {
                rho = this.rho_c - lpphi;
            }
        }
        out.x = rho * Math.sin(lplam *= this.n);
        out.y = this.rho_0 - rho * Math.cos(lplam);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = this.rho_0 - xyy;
        double rho = ProjectionMath.distance(xyx, out.y);
        if (this.n < 0.0) {
            rho = -rho;
            out.x = -xyx;
            out.y = -xyy;
        }
        out.x = Math.atan2(xyx, xyy) / this.n;
        switch (this.type) {
            case 4: {
                out.y = Math.atan(this.c1 - rho / this.c2) + this.sig;
                break;
            }
            case 2: {
                out.y = this.sig - Math.atan(rho - this.rho_c);
                break;
            }
            default: {
                out.y = this.rho_c - rho;
            }
        }
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        int err = 0;
        double p1 = Math.toRadians(30.0);
        double p2 = Math.toRadians(60.0);
        double del = 0.5 * (p2 - p1);
        this.sig = 0.5 * (p2 + p1);
        int n = err = Math.abs(del) < 1.0E-10 || Math.abs(this.sig) < 1.0E-10 ? -42 : 0;
        if (err != 0) {
            throw new ProjectionException("Error " + err);
        }
        switch (this.type) {
            case 5: {
                this.n = Math.sin(this.sig);
                double cs = Math.cos(del);
                this.rho_c = this.n / cs + cs / this.n;
                this.rho_0 = Math.sqrt((this.rho_c - 2.0 * Math.sin(this.projectionLatitude)) / this.n);
                break;
            }
            case 1: {
                this.rho_c = Math.sin(del) / (del * Math.tan(this.sig)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
                this.n = Math.sin(this.sig);
                break;
            }
            case 2: {
                double cs = Math.sqrt(Math.cos(del));
                this.rho_c = cs / Math.tan(this.sig);
                this.rho_0 = this.rho_c + Math.tan(this.sig - this.projectionLatitude);
                this.n = Math.sin(this.sig) * cs;
                break;
            }
            case 3: {
                this.rho_c = del / (Math.tan(this.sig) * Math.tan(del)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
                this.n = Math.sin(this.sig) * Math.sin(del) * Math.tan(del) / (del * del);
                break;
            }
            case 0: {
                this.n = Math.sin(this.sig) * Math.sin(del) / del;
                this.rho_c = (del *= 0.5) / (Math.tan(del) * Math.tan(this.sig)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
                break;
            }
            case 4: {
                double d;
                this.n = Math.sin(this.sig);
                this.c2 = Math.cos(del);
                this.c1 = 1.0 / Math.tan(this.sig);
                del = this.projectionLatitude - this.sig;
                if (Math.abs(d) - 1.0E-10 >= 1.5707963267948966) {
                    throw new ProjectionException("-43");
                }
                this.rho_0 = this.c2 * (this.c1 - Math.tan(del));
                this.maxLatitude = Math.toRadians(60.0);
                break;
            }
            case 6: {
                double cs = Math.tan(del);
                this.n = cs * Math.sin(this.sig) / del;
                this.rho_c = del / (cs * Math.tan(this.sig)) + this.sig;
                this.rho_0 = this.rho_c - this.projectionLatitude;
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof SimpleConicProjection) {
            SimpleConicProjection p = (SimpleConicProjection)that;
            return this.type == p.type && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, super.hashCode());
    }
}

