/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import ome.annotations.PermitAll;
import ome.annotations.RolesAllowed;
import ome.conditions.SecurityViolation;
import ome.security.MethodSecurity;
import ome.services.sessions.SessionManager;
import ome.system.Principal;
import org.springframework.aop.framework.Advised;

public class BasicMethodSecurity
implements MethodSecurity {
    private final boolean active;
    private SessionManager sessionManager;

    public BasicMethodSecurity() {
        this(true);
    }

    public BasicMethodSecurity(boolean active) {
        this.active = active;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void checkMethod(Object o, Method m, Principal p, boolean hasPassword) {
        Annotation[] anns;
        String[] allowedRoles = null;
        try {
            Class<?> c = o.getClass();
            while (Advised.class.isAssignableFrom(c)) {
                Advised advised = (Advised)o;
                o = advised.getTargetSource().getTarget();
                c = o.getClass();
            }
            Method mthd = c.getMethod(m.getName(), m.getParameterTypes());
            anns = mthd.getDeclaredAnnotations();
        }
        catch (Exception e) {
            throw new SecurityViolation("Invalid method accessed.");
        }
        for (Annotation annotation : anns) {
            if (annotation instanceof RolesAllowed) {
                RolesAllowed ra = (RolesAllowed)annotation;
                allowedRoles = ra.value();
                break;
            }
            if (!(annotation instanceof PermitAll)) continue;
            return;
        }
        if (allowedRoles == null) {
            throw new SecurityViolation("This method allows no remote access.");
        }
        boolean allow = false;
        boolean block = false;
        List<String> actualRoles = this.sessionManager.getUserRoles(p.getName());
        for (String allowed : allowedRoles) {
            if (actualRoles.contains(allowed)) {
                allow = true;
            }
            if (!"HasPassword".equals(allowed)) continue;
            block = !hasPassword;
        }
        if (block) {
            throw new SecurityViolation("Bad authentication credentials for this action.\nSee setSecurityPassword for more information");
        }
        if (!allow) {
            throw new SecurityViolation(String.format("No matching roles found in %s for session %s (allowed: %s)", actualRoles, p, Arrays.asList(allowedRoles)));
        }
    }

    class Info {
        RolesAllowed rolesAllowed;
        boolean permitAll;

        Info() {
        }
    }
}

