/*
 * Decompiled with CFR 0.152.
 */
package ome.services.pixeldata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import ome.api.IQuery;
import ome.conditions.LockTimeout;
import ome.io.nio.PixelsService;
import ome.model.core.Channel;
import ome.model.core.Pixels;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.stats.StatsInfo;
import ome.parameters.Parameters;
import ome.services.eventlogs.EventLogLoader;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class PixelDataHandler
extends Executor.SimpleWork {
    private static final Logger log = LoggerFactory.getLogger(PixelDataHandler.class);
    protected final EventLogLoader loader;
    protected final PixelsService pixelsService;
    protected int reps = 5;

    public void setRepetitions(int reps) {
        this.reps = reps;
    }

    public PixelDataHandler(EventLogLoader ll, PixelsService pixelsService) {
        super((Object)"PixelDataHandler", "process", new Object[0]);
        this.loader = ll;
        this.pixelsService = pixelsService;
    }

    @Override
    public synchronized void setSqlAction(SqlAction sql) {
        if (this.getSqlAction() == null) {
            super.setSqlAction(sql);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public Object doWork(Session session, ServiceFactory sf) {
        ArrayList<EventLog> logs = new ArrayList<EventLog>();
        while (logs.size() < this.reps) {
            try {
                logs.add(this.loader.next());
            }
            catch (NoSuchElementException nsee) {
                if (this.loader.hasNext()) continue;
                break;
            }
        }
        for (EventLog el : logs) {
            EventLog live = (EventLog)session.get(EventLog.class, (Serializable)el.getId());
            Event evt = live.getEvent();
            el.setEvent(evt);
        }
        return logs;
    }

    public void handleEventLog(EventLog eventLog, Session session, ServiceFactory sf) {
        long start = System.currentTimeMillis();
        boolean handled = this.process(eventLog.getEntityId(), sf, session);
        String msg = String.format("EventLog:%s(entityId=%s) [%s ms.]", eventLog.getId(), eventLog.getEntityId(), System.currentTimeMillis() - start);
        if (handled) {
            log.info("HANDLED " + msg);
        } else {
            log.debug("SKIPPED " + msg);
        }
    }

    public boolean process(Long id, ServiceFactory sf, Session s) {
        Pixels pixels = this.getPixels(id, sf);
        if (pixels == null) {
            log.error("No valid pixels found with id=" + id);
            return false;
        }
        try {
            StatsInfo[] statsInfo = this.pixelsService.makePyramid(pixels);
            if (statsInfo == null) {
                log.debug("No min/max values for pixels " + id);
                return false;
            }
            for (int c = 0; c < statsInfo.length; ++c) {
                StatsInfo si = statsInfo[c];
                Channel ch = pixels.getChannel(c);
                long siId = this.getSqlAction().setStatsInfo(ch, si);
                log.info(String.format("Added StatsInfo:%s for %s - C:%s Max:%s Min:%s", siId, ch, c, si.getGlobalMax(), si.getGlobalMin()));
            }
        }
        catch (LockTimeout lt) {
            log.warn("Pixels:" + id + " -- " + lt.getMessage());
            return false;
        }
        catch (Exception t) {
            log.error("Failed to handle pixels " + id, (Throwable)t);
            return false;
        }
        return true;
    }

    protected Pixels getPixels(Long id, ServiceFactory sf) {
        IQuery iQuery = sf.getQueryService();
        Pixels pixels = (Pixels)iQuery.findByQuery("select p from Pixels as p left outer join fetch p.channels ch join fetch p.pixelsType where p.id = :id ", new Parameters().addId(id));
        return pixels;
    }
}

