/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import ome.model.enums.AdminPrivilege;
import ome.model.internal.Permissions;
import ome.model.meta.Session;
import ome.services.sessions.SessionContextImpl;
import ome.services.sessions.stats.NullSessionStats;
import ome.system.Roles;

class InternalSessionContext
extends SessionContextImpl {
    Roles roles;

    InternalSessionContext(Session s, ImmutableSet<AdminPrivilege> adminPrivileges, Roles roles) {
        super(s, (Set<AdminPrivilege>)adminPrivileges, Arrays.asList(roles.getSystemGroupId()), Arrays.asList(roles.getSystemGroupId()), Arrays.asList(roles.getSystemGroupName()), new NullSessionStats(), roles, null);
        this.roles = roles;
    }

    @Override
    public String getCurrentEventType() {
        return "Internal";
    }

    @Override
    public Long getCurrentGroupId() {
        return this.roles.getSystemGroupId();
    }

    @Override
    public String getCurrentGroupName() {
        return this.roles.getSystemGroupName();
    }

    @Override
    public Long getCurrentUserId() {
        return this.roles.getRootId();
    }

    @Override
    public String getCurrentUserName() {
        return this.roles.getRootName();
    }

    @Override
    public boolean isCurrentUserAdmin() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Permissions getCurrentGroupPermissions() {
        return Permissions.USER_PRIVATE;
    }
}

