/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.Memoizer;
import ome.io.bioformats.MemoizerReadOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoizerFallback
extends Memoizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoizerFallback.class);
    private final Collection<MemoizerReadOnly> fallbacks;

    public MemoizerFallback(IFormatReader reader, long minimumElapsed, File directory, Collection<MemoizerReadOnly> fallbacks) {
        super(reader, minimumElapsed, directory);
        this.fallbacks = fallbacks;
    }

    public void setId(String id) throws FormatException, IOException {
        File memoRW = this.getMemoFile(id);
        if (memoRW != null && !memoRW.canRead()) {
            for (MemoizerReadOnly fallback : this.fallbacks) {
                File memoRO = fallback.getMemoFile(id);
                if (memoRO == null || !memoRO.canRead()) continue;
                LOGGER.info("for setId({}) copying {} to {}", new Object[]{id, memoRO, memoRW});
                try {
                    Files.copy(memoRO.toPath(), memoRW.toPath(), new CopyOption[0]);
                    break;
                }
                catch (IOException e) {
                    LOGGER.warn("copy failed, continuing anyway", (Throwable)e);
                }
            }
        }
        super.setId(id);
    }
}

