/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ome.conditions.ResourceError;
import ome.io.nio.PixelBuffer;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.QuantumDef;
import ome.model.enums.PixelsType;
import ome.util.PixelData;
import omeis.providers.re.QuantumManager;
import omeis.providers.re.RGBAIntBuffer;
import omeis.providers.re.RGBBuffer;
import omeis.providers.re.RGBIntBuffer;
import omeis.providers.re.RenderHSBRegionTask;
import omeis.providers.re.Renderer;
import omeis.providers.re.RenderingStats;
import omeis.providers.re.RenderingStrategy;
import omeis.providers.re.RenderingTask;
import omeis.providers.re.codomain.CodomainChain;
import omeis.providers.re.data.Plane2D;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.PlaneFactory;
import omeis.providers.re.quantum.BinaryMaskQuantizer;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HSBStrategy
extends RenderingStrategy {
    private static Logger log = LoggerFactory.getLogger(HSBStrategy.class);

    HSBStrategy() {
    }

    private int numTasks(int size) {
        for (int i = this.maxTasks; i > 0; --i) {
            if (size % i != 0) continue;
            return i;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Plane2D> getWavelengthData(PlaneDef pDef) {
        ChannelBinding[] channelBindings = this.renderer.getChannelBindings();
        Pixels metadata = this.renderer.getMetadata();
        PixelBuffer pixels = this.renderer.getPixels();
        ArrayList<Plane2D> wData = null;
        try {
            RenderingStats performanceStats = this.renderer.getStats();
            wData = new ArrayList<Plane2D>();
            for (int w = 0; w < channelBindings.length; ++w) {
                if (!channelBindings[w].getActive().booleanValue()) continue;
                performanceStats.startIO(w);
                wData.add(PlaneFactory.createPlane(pDef, w, metadata, pixels));
                performanceStats.endIO(w);
            }
            Map<byte[], Integer> overlays = this.renderer.getOverlays();
            if (overlays != null) {
                for (byte[] overlay : overlays.keySet()) {
                    PixelData data = new PixelData("bit", ByteBuffer.wrap(overlay));
                    wData.add(new Plane2D(pDef, metadata, data));
                }
            }
        }
        finally {
            try {
                pixels.close();
            }
            catch (IOException e) {
                log.error("Pixels could not be closed successfully.", (Throwable)e);
                throw new ResourceError(e.getMessage() + " Please check server log.");
            }
        }
        return wData;
    }

    private List<CodomainChain> getChains() {
        List<CodomainChain> chains = this.renderer.getCodomainChains();
        ChannelBinding[] channelBindings = this.renderer.getChannelBindings();
        ArrayList<CodomainChain> list = new ArrayList<CodomainChain>();
        for (int w = 0; w < channelBindings.length; ++w) {
            ChannelBinding cb = channelBindings[w];
            if (!cb.getActive().booleanValue()) continue;
            list.add(chains.get(w));
        }
        return list;
    }

    private List<int[]> getColors() {
        ChannelBinding[] channelBindings = this.renderer.getChannelBindings();
        ArrayList<int[]> colors = new ArrayList<int[]>();
        for (int w = 0; w < channelBindings.length; ++w) {
            ChannelBinding cb = channelBindings[w];
            if (!cb.getActive().booleanValue()) continue;
            int[] theNewColor = new int[]{cb.getRed(), cb.getGreen(), cb.getBlue(), cb.getAlpha()};
            colors.add(theNewColor);
        }
        Map<byte[], Integer> overlays = this.renderer.getOverlays();
        if (overlays != null) {
            for (byte[] overlay : overlays.keySet()) {
                Integer packedColor = overlays.get(overlay);
                Color color = new Color(packedColor);
                colors.add(new int[]{color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha()});
            }
        }
        return colors;
    }

    private List<QuantumStrategy> getStrategies() {
        ChannelBinding[] channelBindings = this.renderer.getChannelBindings();
        QuantumManager qManager = this.renderer.getQuantumManager();
        ArrayList<QuantumStrategy> strats = new ArrayList<QuantumStrategy>();
        for (int w = 0; w < channelBindings.length; ++w) {
            if (!channelBindings[w].getActive().booleanValue()) continue;
            strats.add(qManager.getStrategyFor(w));
        }
        Map<byte[], Integer> overlays = this.renderer.getOverlays();
        if (overlays != null) {
            QuantumDef def = new QuantumDef();
            Pixels pixels = new Pixels();
            PixelsType bitType = new PixelsType();
            bitType.setValue("bit");
            bitType.setBitSize(Integer.valueOf(1));
            pixels.setPixelsType(bitType);
            for (int i = 0; i < overlays.size(); ++i) {
                strats.add(new BinaryMaskQuantizer(def, pixels));
            }
        }
        return strats;
    }

    private RenderingTask[] makeRenderingTasks(PlaneDef def, RGBBuffer buf) {
        ArrayList<RenderHSBRegionTask> tasks = new ArrayList<RenderHSBRegionTask>();
        List<Plane2D> wData = this.getWavelengthData(def);
        List<int[]> colors = this.getColors();
        List readers = this.renderer.getLutProvider().getLutReaders(this.renderer.getChannelBindings());
        List<QuantumStrategy> strategies = this.getStrategies();
        int taskCount = this.numTasks(this.sizeX2);
        int delta = this.sizeX2 / taskCount;
        int x1Start = 0;
        int x1End = this.sizeX1;
        log.info("taskCount: " + taskCount + " delta: " + delta);
        for (int i = 0; i < taskCount; ++i) {
            int x2Start = i * delta;
            int x2End = (i + 1) * delta;
            tasks.add(new RenderHSBRegionTask(buf, wData, strategies, this.getChains(), colors, this.renderer.getOptimizations(), x1Start, x1End, x2Start, x2End, readers));
        }
        return tasks.toArray(new RenderingTask[tasks.size()]);
    }

    @Override
    RGBBuffer render(Renderer ctx, PlaneDef planeDef) throws IOException, QuantizationException {
        this.renderer = ctx;
        Pixels metadata = this.renderer.getMetadata();
        this.initAxesSize(planeDef, metadata);
        RGBBuffer buf = this.getRgbBuffer();
        this.render(buf, planeDef);
        return buf;
    }

    @Override
    RGBIntBuffer renderAsPackedInt(Renderer ctx, PlaneDef planeDef) throws IOException, QuantizationException {
        this.renderer = ctx;
        Pixels metadata = this.renderer.getMetadata();
        this.initAxesSize(planeDef, metadata);
        RGBIntBuffer buf = this.getIntBuffer();
        this.render((RGBBuffer)buf, planeDef);
        return buf;
    }

    @Override
    RGBAIntBuffer renderAsPackedIntAsRGBA(Renderer ctx, PlaneDef planeDef) throws IOException, QuantizationException {
        this.renderer = ctx;
        Pixels metadata = this.renderer.getMetadata();
        this.initAxesSize(planeDef, metadata);
        RGBAIntBuffer buf = this.getRGBAIntBuffer();
        this.render((RGBBuffer)buf, planeDef);
        return buf;
    }

    private void render(RGBBuffer buf, PlaneDef planeDef) throws IOException, QuantizationException {
        RenderingStats performanceStats = this.renderer.getStats();
        RenderingTask[] tasks = this.makeRenderingTasks(planeDef, buf);
        performanceStats.startRendering();
        int n = tasks.length;
        Future[] rndTskFutures = new Future[n];
        ExecutorService processor = Executors.newCachedThreadPool();
        while (0 < --n) {
            rndTskFutures[n] = processor.submit(tasks[n]);
        }
        if (n == 0) {
            tasks[0].call();
        }
        for (n = 1; n < rndTskFutures.length; ++n) {
            try {
                rndTskFutures[n].get();
                continue;
            }
            catch (Exception e) {
                if (e instanceof QuantizationException) {
                    throw (QuantizationException)e;
                }
                throw new RuntimeException(e);
            }
        }
        processor.shutdown();
        performanceStats.endRendering();
    }

    @Override
    int getImageSize(PlaneDef pd, Pixels pixels) {
        this.initAxesSize(pd, pixels);
        return this.sizeX1 * this.sizeX2 * 3;
    }

    @Override
    String getPlaneDimsAsString(PlaneDef pd, Pixels pixels) {
        this.initAxesSize(pd, pixels);
        return this.sizeX1 + "x" + this.sizeX2;
    }
}

