/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.SetMutator;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.GroupExperimenterMap;
import omero.rtypes;

public class GroupData
extends DataObject {
    public static final int PERMISSIONS_PRIVATE = 0;
    public static final int PERMISSIONS_GROUP_READ = 1;
    public static final int PERMISSIONS_GROUP_READ_LINK = 2;
    public static final int PERMISSIONS_GROUP_READ_WRITE = 3;
    public static final int PERMISSIONS_PUBLIC_READ = 4;
    public static final int PERMISSIONS_PUBLIC_READ_WRITE = 5;
    public static final String PERMISSIONS_PRIVATE_TEXT = "Private Group";
    public static final String PERMISSIONS_GROUP_READ_TEXT = "Collaborators can only read your data.";
    public static final String PERMISSIONS_GROUP_READ_LINK_TEXT = "Collaborators can read and annotate your data.";
    public static final String PERMISSIONS_GROUP_READ_WRITE_TEXT = "Collaborators can read, annotate, delete, etc., your data.";
    public static final String PERMISSIONS_PUBLIC_READ_TEXT = "Public";
    public static final String PERMISSIONS_PUBLIC_READ_WRITE_TEXT = "Public";
    public static final String PERMISSIONS_GROUP_READ_SHORT_TEXT = "Read-Only";
    public static final String PERMISSIONS_GROUP_READ_LINK_SHORT_TEXT = "Read-Annotate";
    public static final String PERMISSIONS_GROUP_READ_WRITE_SHORT_TEXT = "Read-Write";
    public static final String NAME = "ome.model.meta.ExperimenterGroup_name";
    public static final String DESCRIPTION = "ome.model.meta.ExperimenterGroup_description";
    public static final String GROUP_EXPERIMENTER_MAP = "ome.model.meta.ExperimenterGroup_groupExperimenterMap";
    public static final String USER = "user";
    public static final String SYSTEM = "system";
    public static final String GUEST = "guest";
    public static final String DEFAULT = "default";
    private Set<ExperimenterData> experimenters;
    private Set<ExperimenterData> leaders;

    public GroupData() {
        this.setDirty(true);
        this.setValue(new ExperimenterGroupI());
    }

    public GroupData(ExperimenterGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Annotation cannot null.");
        }
        this.setValue(group);
    }

    public String getName() {
        RString n = this.asGroup().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been be null");
        }
        return n.getValue();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asGroup().setName(rtypes.rstring(name));
    }

    public String getDescription() {
        RString n = this.asGroup().getDescription();
        if (n == null || n.getValue() == null) {
            return "";
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        this.setDirty(true);
        this.asGroup().setDescription(rtypes.rstring(description));
    }

    public Set<ExperimenterData> getLeaders() {
        if (this.leaders == null && this.asGroup().sizeOfGroupExperimenterMap() >= 0) {
            this.leaders = new HashSet<ExperimenterData>();
            List<GroupExperimenterMap> links = this.asGroup().copyGroupExperimenterMap();
            for (GroupExperimenterMap link : links) {
                if (!link.getOwner().getValue()) continue;
                this.leaders.add(new ExperimenterData(link.getChild()));
            }
        }
        return this.leaders == null ? null : new HashSet<ExperimenterData>(this.leaders);
    }

    public Set<ExperimenterData> getExperimenters() {
        if (this.experimenters == null && this.asGroup().sizeOfGroupExperimenterMap() >= 0) {
            this.experimenters = new HashSet<ExperimenterData>();
            List<GroupExperimenterMap> links = this.asGroup().copyGroupExperimenterMap();
            for (GroupExperimenterMap link : links) {
                this.experimenters.add(new ExperimenterData(link.getChild()));
            }
        }
        return this.experimenters == null ? null : new HashSet<ExperimenterData>(this.experimenters);
    }

    public Set<ExperimenterData> getMembersOnly() {
        Set<ExperimenterData> leaders = this.getLeaders();
        Set<ExperimenterData> experimenters = this.getExperimenters();
        if (leaders == null || leaders.size() == 0) {
            return experimenters;
        }
        if (experimenters == null || experimenters.size() == 0) {
            return leaders;
        }
        ArrayList<Long> ids = new ArrayList<Long>(leaders.size());
        Iterator<ExperimenterData> i = leaders.iterator();
        while (i.hasNext()) {
            ids.add(i.next().getId());
        }
        HashSet<ExperimenterData> members = new HashSet<ExperimenterData>();
        for (ExperimenterData exp : experimenters) {
            if (ids.contains(exp.getId())) continue;
            members.add(exp);
        }
        return members;
    }

    @Override
    public long getGroupId() {
        return this.getId();
    }

    public void setExperimenters(Set<ExperimenterData> newValue) {
        Set<ExperimenterData> currentValue = this.getExperimenters();
        SetMutator<ExperimenterData> m = new SetMutator<ExperimenterData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asGroup().unlinkExperimenter(m.nextDeletion().asExperimenter());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asGroup().linkExperimenter(m.nextAddition().asExperimenter());
        }
        this.experimenters = new HashSet<ExperimenterData>(m.result());
    }
}

