/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.Date;
import java.util.Iterator;

class HDF5DateTimeReader
implements IHDF5DateTimeReader {
    private final HDF5BaseReader baseReader;
    private final HDF5LongReader longReader;

    HDF5DateTimeReader(HDF5BaseReader baseReader, HDF5LongReader longReader) {
        assert (baseReader != null);
        assert (longReader != null);
        this.baseReader = baseReader;
        this.longReader = longReader;
    }

    @Override
    public long getAttrAsLong(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Long> getAttributeRunnable = new ICallableWithCleanUp<Long>(){

            @Override
            public Long call(ICleanUpRegistry registry) {
                long objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                long attributeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, attributeName, objectId, registry);
                long[] data = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, HDF5Constants.H5T_NATIVE_INT64, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public Date getAttr(String objectPath, String attributeName) {
        return new Date(this.getAttrAsLong(objectPath, attributeName));
    }

    @Override
    public long[] getArrayAttrAsLong(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> getAttributeRunnable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                long objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, attributeName, objectId, registry);
                return HDF5DateTimeReader.this.longReader.getLongArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDLongArray getMDArrayAttrAsLong(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDLongArray> getAttributeRunnable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                long objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, attributeName, objectId, registry);
                return HDF5DateTimeReader.this.longReader.getLongMDArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public Date[] getArrayAttr(String objectPath, String attributeName) {
        long[] timeStampArray = this.getArrayAttrAsLong(objectPath, attributeName);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public MDArray<Date> getMDArrayAttr(String objectPath, String attributeName) {
        MDLongArray timeStampArray = this.getMDArrayAttrAsLong(objectPath, attributeName);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public boolean isTimeStamp(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath, attributeName);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeStamp();
    }

    @Override
    public boolean isTimeStamp(String objectPath) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeStamp();
    }

    @Override
    public long readTimeStamp(final String objectPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Long> readCallable = new ICallableWithCleanUp<Long>(){

            @Override
            public Long call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                long[] data = new long[1];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeStampArray(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeStampArrayBlock(final String objectPath, final int blockSize, final long blockNumber) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, blockNumber * (long)blockSize, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeStampArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Date readDate(String objectPath) throws HDF5JavaException {
        return new Date(this.readTimeStamp(objectPath));
    }

    @Override
    public Date[] readDateArray(String objectPath) throws HDF5JavaException {
        long[] timeStampArray = this.readTimeStampArray(objectPath);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public MDLongArray readTimeStampMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDLongArray> readCallable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                return HDF5DateTimeReader.this.longReader.readLongMDArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDLongArray readTimeStampMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readTimeStampMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDLongArray readTimeStampMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDLongArray> readCallable = new ICallableWithCleanUp<MDLongArray>(){

            @Override
            public MDLongArray call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                long[] dataBlock = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                return new MDLongArray(dataBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayWithOffset(final String objectPath, final MDLongArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                long nativeDataTypeId = HDF5DateTimeReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT64, registry);
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt((long[])spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayBlockWithOffset(final String objectPath, final MDLongArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                long nativeDataTypeId = HDF5DateTimeReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT64, registry);
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt((long[])spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getTimeStampArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<long[]>>(){

            @Override
            public Iterator<HDF5DataBlock<long[]>> iterator() {
                return new Iterator<HDF5DataBlock<long[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<long[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        long[] block = HDF5DateTimeReader.this.readTimeStampArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<long[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Date[] readDateArrayBlock(String objectPath, int blockSize, long blockNumber) {
        long[] timestampArray = this.readTimeStampArrayBlock(objectPath, blockSize, blockNumber);
        return HDF5DateTimeReader.timeStampsToDates(timestampArray);
    }

    @Override
    public Date[] readDateArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        long[] timestampArray = this.readTimeStampArrayBlockWithOffset(objectPath, blockSize, offset);
        return HDF5DateTimeReader.timeStampsToDates(timestampArray);
    }

    @Override
    public Iterable<HDF5DataBlock<Date[]>> getDateArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<Date[]>>(){

            @Override
            public Iterator<HDF5DataBlock<Date[]>> iterator() {
                return new Iterator<HDF5DataBlock<Date[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<Date[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        long[] block = HDF5DateTimeReader.this.readTimeStampArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<Date[]>(HDF5DateTimeReader.timeStampsToDates(block), this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDLongArray>> getTimeStampMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDLongArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDLongArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDLongArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDLongArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDLongArray data = HDF5DateTimeReader.this.readTimeStampMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDLongArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static Date[] timeStampsToDates(long[] timeStampArray) {
        assert (timeStampArray != null);
        Date[] dateArray = new Date[timeStampArray.length];
        int i = 0;
        while (i < dateArray.length) {
            dateArray[i] = new Date(timeStampArray[i]);
            ++i;
        }
        return dateArray;
    }

    private static MDArray<Date> timeStampsToDates(MDLongArray timeStampArray) {
        assert (timeStampArray != null);
        long[] timeStampsFlat = timeStampArray.getAsFlatArray();
        MDArray dateArray = new MDArray(Date.class, timeStampArray.dimensions());
        Date[] datesFlat = (Date[])dateArray.getAsFlatArray();
        int i = 0;
        while (i < datesFlat.length) {
            datesFlat[i] = new Date(timeStampsFlat[i]);
            ++i;
        }
        return dateArray;
    }

    @Override
    public MDArray<Date> readDateMDArray(String objectPath) {
        MDLongArray timeStampArray = this.readTimeStampMDArray(objectPath);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public MDArray<Date> readDateMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        MDLongArray timeStampArray = this.readTimeStampMDArrayBlock(objectPath, blockDimensions, blockNumber);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public MDArray<Date> readDateMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        MDLongArray timeStampArray = this.readTimeStampMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<Date>>> getDateMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDArray<Date>>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDArray<Date>>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDArray<Date>>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDArray<Date>> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDLongArray data = HDF5DateTimeReader.this.readTimeStampMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDArray<Date>>(HDF5DateTimeReader.timeStampsToDates(data), this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

